/* uInspect.h

        Header of the kernel of the Inspector program

        See uInspect.cpp for explanations
*/

#ifndef UINSPECT_H
#define UINSPECT_H

#include <string>
#include <map>
#include "header.h"
#include "typedef.h"

// Constants
#define PATHLENGTH        512
extern const char BARBADOS_LETTER_FOR_CID;
extern const int  BARBADOS_ROOT_CONTAINER;
extern const void *CN_TABLE_FINISH_MARK;


// Published constants ------------------------------------------------------
extern const char * inspHEADER[];

// Interface with the shell unit---------------------------------------------
extern void puttext(const std::string &, bool = true);
extern const bool NOTCR;

// Classes of inspection -----------------------------------------------------

typedef std::map<std::string, namedobj_type> TNamedobjList;

class Inspect {
        private:
                // File
                static const std::string inspERROR;
                std::string filename;
                unsigned long int filelength;

                // Mapping in memory
                void *location;
                HANDLE memory;
                HANDLE file;
                bool errorhappened;
        protected:
                // Container properties
                static const char* kinds[];
                ContainerHeader *header;
                std::string kindoffile;
                class directory *direc;

                // Internal operations
                void *loadDll(void);
                void releaseDll(void);
                std::string printCid(int) const;
                std::string interpretClass(const namedobj &) const;
                std::string interpretObject(const namedobj &) const;
                std::string extime(const time_t &x) const;
                bool inline itsHere(void *) const;
        public:
                // Other structures
                TNamedobjList objlist;

                // Public operations
                Inspect(const std::string &);
                ~Inspect()            { releaseDll(); };

                void totalDump(void);
                void headerDump(void);
                void directoryDump(void);
                void CNTableDump(void) const;
                void Modify(namedobj_type, const std::string &);
                bool getSuccess(void) const { return !errorhappened; }
                std::string printVal(const namedobj &, bool &, void *val = NULL) const;

                template <class T> T *swizzle(T *) const;
                static const unsigned int version;
};

class CNInfo {
public:
        char name[PATHLENGTH];
        void *** pointer;
        container_id container;
};

#endif
