/* $Id: dragndrop.cpp 437 2005-10-14 05:00:17Z jla $ */


#include <windows.h>
#include <ole2.h>
#include "tfc.h"
#include "dragndrop.h"



#undef interface
#define interface

interface unsigned int SWX_CF_SECURITY;
interface unsigned int SWX_CF_SECURITIES;

static TfcCallback DropCallback;

extern void* (*TfcDropStart)(void* hWnd, TfcCallback callback);
extern void* (*TfcSWDropStart)(ScrollWin* sw, TfcCallback dropCallback);
extern void (*TfcDropStop)(void* droptarget);


class Unknown  : public IUnknown{
    DWORD refs;
public :

    Unknown();
    virtual ULONG STDMETHODCALLTYPE  AddRef(void);
    virtual ULONG STDMETHODCALLTYPE  Release(void);
    virtual HRESULT STDMETHODCALLTYPE QueryInterface( REFIID riid, void __RPC_FAR *__RPC_FAR *ppvObject) ;
};


class DropSource : public Unknown, public IDropSource
{
public:
  DropSource(): Unknown(){  }

  virtual HRESULT STDMETHODCALLTYPE QueryContinueDrag( BOOL fEscapePressed, DWORD grfKeyState) ;

  virtual HRESULT STDMETHODCALLTYPE GiveFeedback(DWORD dwEffect) ;//{    return DRAGDROP_S_USEDEFAULTCURSORS ;   }

  virtual HRESULT STDMETHODCALLTYPE QueryInterface(REFIID riid, void __RPC_FAR *__RPC_FAR *ppvObject) ;

  virtual ULONG STDMETHODCALLTYPE  AddRef(){  return Unknown::AddRef();}
  virtual ULONG STDMETHODCALLTYPE  Release(){ return Unknown::Release();};

};


class DataObject : public Unknown,  public IDataObject {
private:
  DWORD        refs;
public:
    DataObject(): IDataObject()    {refs=0;}

  virtual HRESULT STDMETHODCALLTYPE QueryInterface( REFIID riid, void __RPC_FAR *__RPC_FAR *ppvObject) ;

  virtual ULONG STDMETHODCALLTYPE  AddRef(void){  return Unknown::AddRef();  }
  virtual ULONG STDMETHODCALLTYPE  Release(void){ return Unknown::Release();}

  virtual HRESULT STDMETHODCALLTYPE GetData( FORMATETC __RPC_FAR *pformatetcIn, STGMEDIUM __RPC_FAR *pmedium) = 0;

  virtual HRESULT STDMETHODCALLTYPE GetDataHere(FORMATETC __RPC_FAR *pformatetc, STGMEDIUM __RPC_FAR *pmedium)  = 0;

  virtual HRESULT STDMETHODCALLTYPE QueryGetData(FORMATETC __RPC_FAR *pformatetc) = 0;

  virtual HRESULT STDMETHODCALLTYPE GetCanonicalFormatEtc(FORMATETC __RPC_FAR *pformatectIn,FORMATETC __RPC_FAR *pformatetcOut) {
      return DATA_S_SAMEFORMATETC;
    }

  virtual HRESULT STDMETHODCALLTYPE SetData(FORMATETC __RPC_FAR *pformatetc, STGMEDIUM __RPC_FAR *pmedium, BOOL fRelease) = 0;

  virtual HRESULT STDMETHODCALLTYPE EnumFormatEtc(
        DWORD dwDirection,
        IEnumFORMATETC __RPC_FAR *__RPC_FAR *ppenumFormatEtc) {

        return E_NOTIMPL;
    }

  virtual HRESULT STDMETHODCALLTYPE DAdvise(
        FORMATETC __RPC_FAR *pformatetc,
        DWORD advf,
        IAdviseSink __RPC_FAR *pAdvSink,
        DWORD __RPC_FAR *pdwConnection) {

        return E_NOTIMPL;
    }

  virtual HRESULT STDMETHODCALLTYPE DUnadvise(DWORD dwConnection) {
      return OLE_E_ADVISENOTSUPPORTED;
    }

  virtual HRESULT STDMETHODCALLTYPE EnumDAdvise( IEnumSTATDATA __RPC_FAR *__RPC_FAR *ppenumAdvise)
  {
      return OLE_E_ADVISENOTSUPPORTED;
   }

};

HRESULT CreateDataObject (FORMATETC *fmtetc, STGMEDIUM *stgmeds, UINT count, IDataObject **ppDataObject);
HANDLE BufferToHandle(void *Buffer, int nBufferLen);

class TfcDataObject : public IDataObject
{
public:
        //
    // IUnknown members
        //
    HRESULT __stdcall QueryInterface (REFIID iid, void ** ppvObject);
    ULONG   __stdcall AddRef (void);
    ULONG   __stdcall Release (void);

    //
        // IDataObject members
        //
    HRESULT __stdcall GetData                           (FORMATETC *pFormatEtc,  STGMEDIUM *pMedium);
    HRESULT __stdcall GetDataHere                       (FORMATETC *pFormatEtc,  STGMEDIUM *pMedium);
    HRESULT __stdcall QueryGetData                      (FORMATETC *pFormatEtc);
        HRESULT __stdcall GetCanonicalFormatEtc (FORMATETC *pFormatEct,  FORMATETC *pFormatEtcOut);
    HRESULT __stdcall SetData                           (FORMATETC *pFormatEtc,  STGMEDIUM *pMedium,  BOOL fRelease);
        HRESULT __stdcall EnumFormatEtc                 (DWORD      dwDirection, IEnumFORMATETC **ppEnumFormatEtc);
        HRESULT __stdcall DAdvise                               (FORMATETC *pFormatEtc,  DWORD advf, IAdviseSink *pAdvSink, DWORD *pdwConnection);
        HRESULT __stdcall DUnadvise                             (DWORD      dwConnection);
        HRESULT __stdcall EnumDAdvise                   (IEnumSTATDATA **ppEnumAdvise);

        //
    // Constructor / Destructor
        //
    TfcDataObject(FORMATETC *fmt, STGMEDIUM *stgmed, int count);
    ~TfcDataObject();

private:

        int LookupFormatEtc(FORMATETC *pFormatEtc);

    //
        // any private members and functions
        //
    LONG           m_lRefCount;

        FORMATETC *m_pFormatEtc;
        STGMEDIUM *m_pStgMedium;
        LONG       m_nNumFormats;

};


Unknown::Unknown() : IUnknown()
{
    refs = 0;
}

ULONG Unknown::AddRef(void)
{
    return ++refs;
};

ULONG Unknown::Release(void)
{
     --refs;
     return refs;
};

HRESULT Unknown::QueryInterface(REFIID riid, void __RPC_FAR *__RPC_FAR *ppvObject)
{
        *ppvObject=NULL;
        if (riid == IID_IUnknown)
            *ppvObject = this;
        if (NULL==*ppvObject)
        {
            return ResultFromScode(E_NOINTERFACE);
        }
        ((IUnknown*)*ppvObject)->AddRef();
        return NOERROR;
}

// ---------------- DATA OBJECT -------------------------
const ULONG MAX_FORMATS = 100;

HRESULT CreateEnumFormatEtc(UINT nNumFormats, FORMATETC *pFormatEtc, IEnumFORMATETC **ppEnumFormatEtc);


//
//      Constructor
//
TfcDataObject::TfcDataObject(FORMATETC *fmtetc, STGMEDIUM *stgmed, int count)
{
        m_lRefCount  = 1;
        m_nNumFormats = count;

        m_pFormatEtc  = new FORMATETC[count];
        m_pStgMedium  = new STGMEDIUM[count];

        for(int i = 0; i < count; i++)
        {
                m_pFormatEtc[i] = fmtetc[i];
                m_pStgMedium[i] = stgmed[i];
        }
}

//
//      Destructor
//
TfcDataObject::~TfcDataObject()
{
        // cleanup
        if(m_pFormatEtc) delete[] m_pFormatEtc;
        if(m_pStgMedium) delete[] m_pStgMedium;
}

//
//      IUnknown::AddRef
//
ULONG __stdcall TfcDataObject::AddRef(void)
{
    // increment object reference count
    return InterlockedIncrement(&m_lRefCount);
}

//
//      IUnknown::Release
//
ULONG __stdcall TfcDataObject::Release(void)
{
    // decrement object reference count
        LONG count = InterlockedDecrement(&m_lRefCount);

        if(count == 0)
        {
                delete this;
                return 0;
        }
        else
        {
                return count;
        }
}

//
//      IUnknown::QueryInterface
//
HRESULT __stdcall TfcDataObject::QueryInterface(REFIID iid, void **ppvObject)
{
    // check to see what interface has been requested
    if(iid == IID_IDataObject || iid == IID_IUnknown)
    {
        AddRef();
        *ppvObject = this;
        return S_OK;
    }
    else
    {
        *ppvObject = 0;
        return E_NOINTERFACE;
    }
}

HGLOBAL DupMem(HGLOBAL hMem)
{
        // lock the source memory object
        DWORD   len    = GlobalSize(hMem);
        PVOID   source = GlobalLock(hMem);

        // create a fixed "global" block - i.e. just
        // a regular lump of our process heap
        PVOID   dest   = GlobalAlloc(GMEM_FIXED, len);

        memcpy(dest, source, len);

        GlobalUnlock(hMem);

        return dest;
}

int TfcDataObject::LookupFormatEtc(FORMATETC *pFormatEtc)
{
        for(int i = 0; i < m_nNumFormats; i++)
        {
                if((pFormatEtc->tymed    &  m_pFormatEtc[i].tymed)   &&
                        pFormatEtc->cfFormat == m_pFormatEtc[i].cfFormat &&
                        pFormatEtc->dwAspect == m_pFormatEtc[i].dwAspect)
                {
                        return i;
                }
        }

        return -1;

}

//
//      IDataObject::GetData
//
HRESULT __stdcall TfcDataObject::GetData (FORMATETC *pFormatEtc, STGMEDIUM *pMedium)
{
        int idx;

        //
        // try to match the requested FORMATETC with one of our supported formats
        //
        if((idx = LookupFormatEtc(pFormatEtc)) == -1)
        {
                return DV_E_FORMATETC;
        }

        //
        // found a match! transfer the data into the supplied storage-medium
        //
        pMedium->tymed                   = m_pFormatEtc[idx].tymed;
        pMedium->pUnkForRelease  = 0;

        switch(m_pFormatEtc[idx].tymed)
        {
        case TYMED_HGLOBAL:

                pMedium->hGlobal = DupMem(m_pStgMedium[idx].hGlobal);
                //return S_OK;
                break;

        default:
                return DV_E_FORMATETC;
        }

        return S_OK;
}

//
//      IDataObject::GetDataHere
//
HRESULT __stdcall TfcDataObject::GetDataHere (FORMATETC *pFormatEtc, STGMEDIUM *pMedium)
{
        // GetDataHere is only required for IStream and IStorage mediums
        // It is an error to call GetDataHere for things like HGLOBAL and other clipboard formats
        //
        //      OleFlushClipboard
        //
        return DATA_E_FORMATETC;
}

//
//      IDataObject::QueryGetData
//
//      Called to see if the IDataObject supports the specified format of data
//
HRESULT __stdcall TfcDataObject::QueryGetData (FORMATETC *pFormatEtc)
{
        return (LookupFormatEtc(pFormatEtc) == -1) ? DV_E_FORMATETC : S_OK;
}

//
//      IDataObject::GetCanonicalFormatEtc
//
HRESULT __stdcall TfcDataObject::GetCanonicalFormatEtc (FORMATETC *pFormatEct, FORMATETC *pFormatEtcOut)
{
        // Apparently we have to set this field to NULL even though we don't do anything else
        pFormatEtcOut->ptd = NULL;
        return E_NOTIMPL;
}

//
//      IDataObject::SetData
//
HRESULT __stdcall TfcDataObject::SetData (FORMATETC *pFormatEtc, STGMEDIUM *pMedium,  BOOL fRelease)
{
        return E_NOTIMPL;
}

//
//      IDataObject::EnumFormatEtc
//
HRESULT __stdcall TfcDataObject::EnumFormatEtc (DWORD dwDirection, IEnumFORMATETC **ppEnumFormatEtc)
{
        if(dwDirection == DATADIR_GET)
        {
                // for Win2k+ you can use the SHCreateStdEnumFmtEtc API call, however
                // to support all Windows platforms we need to implement IEnumFormatEtc ourselves.
                return CreateEnumFormatEtc(m_nNumFormats, m_pFormatEtc, ppEnumFormatEtc);
        }
        else
        {
                // the direction specified is not support for drag+drop
                return E_NOTIMPL;
        }
}

//
//      IDataObject::DAdvise
//
HRESULT __stdcall TfcDataObject::DAdvise (FORMATETC *pFormatEtc, DWORD advf, IAdviseSink *pAdvSink, DWORD *pdwConnection)
{
        return OLE_E_ADVISENOTSUPPORTED;
}

//
//      IDataObject::DUnadvise
//
HRESULT __stdcall TfcDataObject::DUnadvise (DWORD dwConnection)
{
        return OLE_E_ADVISENOTSUPPORTED;
}

//
//      IDataObject::EnumDAdvise
//
HRESULT __stdcall TfcDataObject::EnumDAdvise (IEnumSTATDATA **ppEnumAdvise)
{
        return OLE_E_ADVISENOTSUPPORTED;
}

//
//      Helper function
//
HRESULT CreateDataObject (FORMATETC *fmtetc, STGMEDIUM *stgmeds, UINT count, IDataObject **ppDataObject)
{
        if(ppDataObject == 0)
                return E_INVALIDARG;

        *ppDataObject = new TfcDataObject(fmtetc, stgmeds, count);

        return (*ppDataObject) ? S_OK : E_OUTOFMEMORY;
}

HANDLE BufferToHandle(void *Buffer, int nBufferLen)
{
    void  *ptr;

    // if text length is -1 then treat as a nul-terminated string
    if(nBufferLen == -1)
        nBufferLen = lstrlen((str)Buffer) + 1;

    // allocate and lock a global memory buffer. Make it fixed
    // data so we don't have to use GlobalLock
    ptr = (void *)GlobalAlloc(GMEM_FIXED, nBufferLen);

    // copy the string into the buffer
    memcpy(ptr, Buffer, nBufferLen);

    return ptr;
}
// ---------------- DROP SOURCE -------------------------

HRESULT STDMETHODCALLTYPE DropSource::GiveFeedback(DWORD dwEffect)
{

     switch (dwEffect)
     {
        case DROPEFFECT_NONE:
        case DROPEFFECT_COPY:
        case DROPEFFECT_MOVE:
            return DRAGDROP_S_USEDEFAULTCURSORS;
     }
     return S_OK;
}

HRESULT DropSource::QueryContinueDrag( BOOL fEscapePressed, DWORD grfKeyState)
  {
    if (fEscapePressed ) {
          ShowCursor(TRUE);
          return DRAGDROP_S_CANCEL;
      }
    if ((grfKeyState & MK_LBUTTON) == 0)
    {
        ShowCursor(FALSE);
        return DRAGDROP_S_DROP;
      }

    ShowCursor(TRUE);
    return S_OK;
  }

HRESULT DropSource::QueryInterface(REFIID riid, void __RPC_FAR *__RPC_FAR *ppvObject)
{
    if (riid == IID_IDropSource)         *ppvObject=this;
    else  return Unknown::QueryInterface(riid, ppvObject);
    ((IUnknown*)*ppvObject)->AddRef();
    return NOERROR;
}



// ---------------- DATA OBJECT -------------------------


HRESULT STDMETHODCALLTYPE DataObject::QueryInterface( REFIID riid, void __RPC_FAR *__RPC_FAR *ppvObject)
    {

        if (riid == IID_IDataObject)
            *ppvObject=this;
        else return Unknown::QueryInterface(riid, ppvObject);
        ((IUnknown*)*ppvObject)->AddRef();
        return NOERROR;
    }



//-------------------- Drop Target ----------------------


class TfcDropTarget : public IDropTarget, public Unknown
{
    HGLOBAL hG;
    FORMATETC formatSingle;
    FORMATETC formatMulti;

public :
    void* window;
    ScrollWin* swTarget;
        TfcCallback fn;
        bool acceptDrops;
        //drop_fn fn;

    TfcDropTarget() : Unknown(), IDropTarget()
    {
                acceptDrops = yes;

                fn = NULL;
        swTarget = NULL;
        window = NULL;

        formatSingle.cfFormat = SWX_CF_SECURITY;
        formatSingle.tymed = TYMED_HGLOBAL;
        formatSingle.lindex = -1;
        formatSingle.dwAspect = DVASPECT_CONTENT;
        formatSingle.ptd = NULL;

        formatMulti.cfFormat = SWX_CF_SECURITIES;
        formatMulti.tymed = TYMED_HGLOBAL;
        formatMulti.lindex = -1;
        formatMulti.dwAspect = DVASPECT_CONTENT;
        formatMulti.ptd = NULL;
    }

        HWND hWnd()
    {
        if (window)
            return (HWND) window;
        if (swTarget)
            return (HWND) swTarget->_hWnd();
        return NULL;
    }


    virtual HRESULT STDMETHODCALLTYPE DragEnter( IDataObject __RPC_FAR *pDataObj,
        DWORD grfKeyState,POINTL pt,DWORD __RPC_FAR *pdwEffect)
    {


                if (!acceptDrops)
                        return E_INVALIDARG;

        if (grfKeyState & MK_CONTROL)
            *pdwEffect = DROPEFFECT_COPY;
        else
            *pdwEffect = DROPEFFECT_MOVE;

        HRESULT h1 = pDataObj->QueryGetData(&formatSingle);
        HRESULT h2 = pDataObj->QueryGetData(&formatMulti);
        //hG = medium.hGlobal;
        //HRESULT h = pDataObj->QueryGetData(&f);
        if (h1 != S_OK && h2 != S_OK)
            return E_INVALIDARG;

        return S_OK;
    }

    virtual HRESULT STDMETHODCALLTYPE DragOver( DWORD grfKeyState,POINTL pt,DWORD __RPC_FAR *pdwEffect)
    {
        if (grfKeyState & MK_CONTROL)
            *pdwEffect = DROPEFFECT_COPY;
        else
            *pdwEffect = DROPEFFECT_MOVE;

        return S_OK;

    }

    virtual HRESULT STDMETHODCALLTYPE DragLeave( void)
    {
         return S_OK;
    }

    virtual HRESULT STDMETHODCALLTYPE Drop(
            IDataObject __RPC_FAR *pDataObj, DWORD grfKeyState, POINTL pt, DWORD __RPC_FAR *pdwEffect)
    {
        STGMEDIUM stgmed = { TYMED_HGLOBAL, { 0 }, 0 };
        bool result;
        HWND hwnd;

                if (!acceptDrops)
                        return E_INVALIDARG;

        if (grfKeyState & MK_CONTROL)
            *pdwEffect = DROPEFFECT_COPY;
        else
            *pdwEffect = DROPEFFECT_MOVE;


        if (pDataObj->QueryGetData(&formatSingle) == S_OK)
        {
            if (pDataObj->GetData(&formatSingle, &stgmed) != S_OK)
                return E_INVALIDARG;
        }
        else
        if (pDataObj->QueryGetData(&formatMulti) == S_OK)
        {
            if (pDataObj->GetData(&formatMulti, &stgmed) != S_OK)
                return E_INVALIDARG;
        }
        else
            return E_INVALIDARG;

        void* buffer =   GlobalLock(stgmed.hGlobal);
        int size = GlobalSize(stgmed.hGlobal);
        POINT pos;
        GetCursorPos(&pos);
        hwnd = hWnd();
        if (hwnd)
            ScreenToClient(hwnd, &pos);

        result = fn(swTarget, buffer, size, pos.x, pos.y);
        if (!result) {
            *pdwEffect = DROPEFFECT_NONE;
            return E_INVALIDARG;
        }

        GlobalUnlock(stgmed.hGlobal);
        GlobalFree(stgmed.hGlobal);
        return S_OK;
    }

    virtual HRESULT STDMETHODCALLTYPE QueryInterface(REFIID riid, void __RPC_FAR *__RPC_FAR *ppvObject)
    {
        if (riid == IID_IDropTarget)
            *ppvObject=this;
        else
            return Unknown::QueryInterface(riid, ppvObject);
        ((IUnknown*)*ppvObject)->AddRef();
        return NOERROR;
    }

    virtual ULONG STDMETHODCALLTYPE  AddRef(void){ return Unknown::AddRef();}
    virtual ULONG STDMETHODCALLTYPE  Release(void){ return Unknown::Release();}
};


//
//      ENUMFORMAT.CPP
//
//      By J Brown 2004
//
//      www.catch22.net
//
//      Implementation of the IEnumFORMATETC interface
//
//      For Win2K and above look at the SHCreateStdEnumFmtEtc API call!!
//
//      Apparently the order of formats in an IEnumFORMATETC object must be
//  the same as those that were stored in the clipboard
//
//

class CEnumFormatEtc : public IEnumFORMATETC
{
public:

        //
        // IUnknown members
        //
        HRESULT __stdcall  QueryInterface (REFIID iid, void ** ppvObject);
        ULONG   __stdcall  AddRef (void);
        ULONG   __stdcall  Release (void);

        //
        // IEnumFormatEtc members
        //
        HRESULT __stdcall  Next  (ULONG celt, FORMATETC * rgelt, ULONG * pceltFetched);
        HRESULT __stdcall  Skip  (ULONG celt);
        HRESULT __stdcall  Reset (void);
        HRESULT __stdcall  Clone (IEnumFORMATETC ** ppEnumFormatEtc);

        //
        // Construction / Destruction
        //
        CEnumFormatEtc(FORMATETC *pFormatEtc, int nNumFormats);
        ~CEnumFormatEtc();

private:

        LONG            m_lRefCount;            // Reference count for this COM interface
        ULONG           m_nIndex;                       // current enumerator index
        ULONG           m_nNumFormats;          // number of FORMATETC members
        FORMATETC * m_pFormatEtc;               // array of FORMATETC objects
};

//
//      "Drop-in" replacement for SHCreateStdEnumFmtEtc. Called by CDataObject::EnumFormatEtc
//
HRESULT CreateEnumFormatEtc(UINT nNumFormats, FORMATETC *pFormatEtc, IEnumFORMATETC **ppEnumFormatEtc)
{
        if(nNumFormats == 0 || pFormatEtc == 0 || ppEnumFormatEtc == 0)
                return E_INVALIDARG;

        *ppEnumFormatEtc = new CEnumFormatEtc(pFormatEtc, nNumFormats);

        return (*ppEnumFormatEtc) ? S_OK : E_OUTOFMEMORY;
}

//
//      Helper function to perform a "deep" copy of a FORMATETC
//
static void DeepCopyFormatEtc(FORMATETC *dest, FORMATETC *source)
{
        // copy the source FORMATETC into dest
        *dest = *source;

        if(source->ptd)
        {
                // allocate memory for the DVTARGETDEVICE if necessary
                dest->ptd = (DVTARGETDEVICE*)CoTaskMemAlloc(sizeof(DVTARGETDEVICE));

                // copy the contents of the source DVTARGETDEVICE into dest->ptd
                *(dest->ptd) = *(source->ptd);
        }
}

//
//      Constructor
//
CEnumFormatEtc::CEnumFormatEtc(FORMATETC *pFormatEtc, int nNumFormats)
{
        m_lRefCount   = 1;
        m_nIndex      = 0;
        m_nNumFormats = nNumFormats;
        m_pFormatEtc  = new FORMATETC[nNumFormats];

        // copy the FORMATETC structures
        for(int i = 0; i < nNumFormats; i++)
        {
                DeepCopyFormatEtc(&m_pFormatEtc[i], &pFormatEtc[i]);
        }
}

//
//      Destructor
//
CEnumFormatEtc::~CEnumFormatEtc()
{
        if(m_pFormatEtc)
        {
                for(ULONG i = 0; i < m_nNumFormats; i++)
                {
                        if(m_pFormatEtc[i].ptd)
                                CoTaskMemFree(m_pFormatEtc[i].ptd);
                }

                delete[] m_pFormatEtc;
        }
}

//
//      IUnknown::AddRef
//
ULONG __stdcall CEnumFormatEtc::AddRef(void)
{
    // increment object reference count
    return InterlockedIncrement(&m_lRefCount);
}

//
//      IUnknown::Release
//
ULONG __stdcall CEnumFormatEtc::Release(void)
{
    // decrement object reference count
        LONG count = InterlockedDecrement(&m_lRefCount);

        if(count == 0)
        {
                delete this;
                return 0;
        }
        else
        {
                return count;
        }
}

//
//      IUnknown::QueryInterface
//
HRESULT __stdcall CEnumFormatEtc::QueryInterface(REFIID iid, void **ppvObject)
{
    // check to see what interface has been requested
    if(iid == IID_IEnumFORMATETC || iid == IID_IUnknown)
    {
        AddRef();
        *ppvObject = this;
        return S_OK;
    }
    else
    {
        *ppvObject = 0;
        return E_NOINTERFACE;
    }
}

//
//      IEnumFORMATETC::Next
//
//      If the returned FORMATETC structure contains a non-null "ptd" member, then
//  the caller must free this using CoTaskMemFree (stated in the COM documentation)
//
HRESULT __stdcall CEnumFormatEtc::Next(ULONG celt, FORMATETC *pFormatEtc, ULONG * pceltFetched)
{
        ULONG copied  = 0;

        // validate arguments
        if(celt == 0 || pFormatEtc == 0)
                return E_INVALIDARG;

        // copy FORMATETC structures into caller's buffer
        while(m_nIndex < m_nNumFormats && copied < celt)
        {
                DeepCopyFormatEtc(&pFormatEtc[copied], &m_pFormatEtc[m_nIndex]);
                copied++;
                m_nIndex++;
        }

        // store result
        if(pceltFetched != 0)
                *pceltFetched = copied;

        // did we copy all that was requested?
        return (copied == celt) ? S_OK : S_FALSE;
}

//
//      IEnumFORMATETC::Skip
//
HRESULT __stdcall CEnumFormatEtc::Skip(ULONG celt)
{
        m_nIndex += celt;
        return (m_nIndex <= m_nNumFormats) ? S_OK : S_FALSE;
}

//
//      IEnumFORMATETC::Reset
//
HRESULT __stdcall CEnumFormatEtc::Reset(void)
{
        m_nIndex = 0;
        return S_OK;
}

//
//      IEnumFORMATETC::Clone
//
HRESULT __stdcall CEnumFormatEtc::Clone(IEnumFORMATETC ** ppEnumFormatEtc)
{
        HRESULT hResult;

        // make a duplicate enumerator
        hResult = CreateEnumFormatEtc(m_nNumFormats, m_pFormatEtc, ppEnumFormatEtc);

        if(hResult == S_OK)
        {
                // manually set the index state
                ((CEnumFormatEtc *) *ppEnumFormatEtc)->m_nIndex = m_nIndex;
        }

        return hResult;
}




/*------------------------------------ SWX-specific stuff: -----------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>
#include "list.h"


static bool GetTagInternal(str data, str tag, str dest)
{
        char theTag[100];
        sprintf(theTag,"<%s", tag);
        str begin = strstr(data, theTag);
        if (!begin)
            return no;
        begin += strlen(theTag);
        begin = strchr(begin, '>')+1;
        sprintf(theTag,"</%s>", tag);
        str end = strstr(begin, theTag);
        if (!end)
            return no;
        strncpy(dest, begin, end - begin);
        dest[end-begin] = 0;
        return yes;
}


typedef unsigned char byte;
byte* SetupMarshalSecretData(byte* buffer, str xmlMsg);
str SetupUnMarshalSecretData(byte* buffer);


int* SwxParser(str xmlData, str market)
{       char securities[1024];
        str str_securities;
        char strId[10];
        int* IDs, id;

        //<XML_DND>    </XML_DND>
        str begin_tag = "<XML_DND>";

        if (strncmp(xmlData, begin_tag, strlen(begin_tag)) != 0) {
            TfcMessage("Drag'n drop error",'.',"Wrong format. Can not fing tag <XML_DND>");
            return NULL;
        }
        if (!GetTagInternal(xmlData, "MARKET", market)) {
            TfcMessage("Drag'n drop error",'.',"Wrong format. Can not fing tag <MARKET>");
            return NULL;
        }

        if (!GetTagInternal(xmlData, "SWX_CF_SECURITY", securities)
        && !GetTagInternal(xmlData, "SWX_CF_SECURITIES", securities) ) {
            TfcMessage("Drag'n drop error",'.',"Wrong format. Can not fing tag <SWX_CF_SECURITY>");
            return NULL;
        }

        str_securities = securities;
        IDs = NULL;
        while (GetTagInternal(str_securities , "SECURITY_ID", strId)) {
            id = atoi(strId);
            ListAdd(IDs, id);
            str_securities += strlen("<SECURITY_ID>")*2 + strlen(strId) +1;
        }

        return IDs;
}


int* SwxParser(void* data, int dataLength, str market)
{
        str xmlData = SetupUnMarshalSecretData((byte*) data);
        return SwxParser(xmlData, market);
}


void* CodeData(str data, int* length)
{
        *length = 32+4+strlen(data)*2;
        byte* buffer = new byte[*length];
        memset(buffer, 0, *length);
        buffer = SetupMarshalSecretData(buffer, data);
        return buffer;
}


void* SwxBuilder(int security, str market, int* length)
{       char dest[1024];

        str TEMPLATE = "<XML_DND><MARKET>%s</MARKET><SWX_CF_SECURITY>"
                "<SECURITY_ID>%d</SECURITY_ID></SWX_CF_SECURITY></XML_DND>";
        sprintf(dest, TEMPLATE, market, security);
        return CodeData(dest, length);
}


void* SwxBuilder(int* securities, int firstsecurity, str market, int* length)
{       char buf[1024], *s=buf;
        int i, id, j;

        if (ListSize(securities) == 1)
            return SwxBuilder(securities[0], market, length);

        id = 0;
        s += sprintf(s, "<XML_DND><MARKET>%s</MARKET>", market);
        s += sprintf(s, "<SWX_CF_SECURITIESCount=\"%d\">", ListSize(securities));
        if (firstsecurity)
            s += sprintf(s, "%s<SECURITY_ID>%d</SECURITY_ID>", s, firstsecurity);
        for (each_aeli(id, securities)) {
            if (id == firstsecurity)
                continue;
            s += sprintf(s, "%s<SECURITY_ID>%d</SECURITY_ID>", s, id);
            j = strlen(buf);
            if (s+100 > buf + sizeof(buf)) /* also need space for the final /SWX.. */
                break;
        }
        s += sprintf(s, "</SWX_CF_SECURITIES></XML_DND>");
        return CodeData(buf, length);
}


void SetInt32(byte* buffer, int lowPos, int value)
{
        long int4 = (long)value & 0x000000FF;
        buffer[lowPos++] = (byte) (int4);
        long int3 = value&0x0000FF00;
        buffer[lowPos++] = (byte) (int3 >> 8);
        long int2 = value&0x00FF0000;
        buffer[lowPos++] = (byte) (int2 >> 16);
        long int1 = value&0xFF000000;
        buffer[lowPos++] = (byte) (int1 >> 24);
}


str SetupUnMarshalSecretData(byte* buffer)
{
        int length  = *((int*)(buffer + 20));
        str stringData = (str) malloc(length+1);

        short* sbuffer = (short*)(buffer + 32);
        for (int i=0; i< length; i++)
            stringData[i] =(char)sbuffer[i];

        stringData[length] = 0;
        return stringData;
}
/// <summary>
/// Returns a buffer containing all data necessary for TNA+ to unmarshal the data
/// </summary>
/// <param name="buffer">Incoming buffer which will receive all binary marshall data</param>
/// <param name="xmlMsg">Incoming xml string contating all data for Dnd</param>
/// <returns>Buffer with all data set</returns>
byte* SetupMarshalSecretData(byte* buffer, str xmlMsg)
{
// setup marshal secret data (copied values for receiving Dnd data)
//
    int length = strlen(xmlMsg);
    int nr = 0;

    buffer[nr++] = 1;
    buffer[nr++] =  16;
    buffer[nr++] =   8;
    buffer[nr++] =   0;

    buffer[nr++] = 204;
    buffer[nr++] = 204;
    buffer[nr++] = 204;
    buffer[nr++] = 204;

    buffer[nr++] = 208;

    nr = 12;
    buffer[nr++] =   5;

    nr = 16;
    buffer[nr++] =  85;
    buffer[nr++] = 115;
    buffer[nr++] = 101;
    buffer[nr++] = 114;

    SetInt32(buffer, 20, length);
    SetInt32(buffer, 24, length * 2);
    SetInt32(buffer, 28, length);

    // copy the xml document
    //
    int j=32;
    for (int i=0;i<= length-1 ;i++)
    {
        byte byte1 = (byte) xmlMsg[i];//Convert.ToByte(xmlMsg[i]);

        buffer[j] =byte1;
        j=j+2;
    }

    return buffer;
}


//----------



//void TfcStartDragDrop()
//{}
static bool initialized = false;


void* _TfcSWDropStart(ScrollWin* sw, TfcCallback dropCallback);
void* _TfcDropStart(void* hWnd, TfcCallback dropCallback);
void _TfcDropStop(void* droptarget);


interface void* tfcSWDropStart(ScrollWin* sw, TfcCallback dropCallback)
{
        return TfcRegisterDragDrop(sw, dropCallback);
}


interface void* tfcDropStart(void* hWnd, TfcCallback dropCallback)
{
        return TfcRegisterDragDrop(hWnd, dropCallback);
}


interface void tfcDropStop(void* droptarget)
{
        if (droptarget)
            TfcUnregisterDragDrop(droptarget);
}


bool TfcInitDragDrop()
{

        if (initialized == true)
        return true;


        SWX_CF_SECURITY = RegisterClipboardFormat("SWX_CF_SECURITY");
        SWX_CF_SECURITIES = RegisterClipboardFormat("SWX_CF_SECURITIES");

        initialized = OleInitialize(NULL) == S_OK;
        if (initialized) {
            TfcDropStart = tfcDropStart;
            TfcSWDropStart = tfcSWDropStart;
            TfcDropStop = tfcDropStop;
        }

        return initialized;
}


void TfcDisposeDragDrop()
{
        TfcDropStart = _TfcDropStart;
        TfcSWDropStart = _TfcSWDropStart;
        TfcDropStop = _TfcDropStop;

        OleUninitialize();
        initialized = false;
}


void* TfcRegisterDragDrop(ScrollWin* swTarget, TfcCallback callback)
{	TfcDropTarget* target;

	if (swTarget->dropData)
	    TfcUnregisterDragDrop(swTarget->dropData);
	
	swTarget->dropCallback = callback ? callback : DropCallback;
	if (!swTarget->_hWnd())
	    return NULL;
	target = (TfcDropTarget*)TfcRegisterDragDrop(swTarget->_hWnd(), callback);
        if (target) {	
            target->swTarget = swTarget;	
	    swTarget->dropData = target;
        }    
        return target;
}


TfcCallback TfcRegisterDragDrop(TfcCallback callback)
{       TfcCallback prev=DropCallback;

        DropCallback = callback;
        return prev;
}


void* TfcRegisterDragDrop(void* hwndTarget, TfcCallback fn)
{
        TfcCallback drop_fn = fn ? fn : DropCallback ;
        if (!drop_fn)
            return NULL;
        TfcDropTarget* target = new TfcDropTarget();
        target->window = (HWND) hwndTarget;
        target->swTarget = NULL;
        target->fn = drop_fn ;
        RegisterDragDrop((HWND) hwndTarget, (IDropTarget*) target);
        CoLockObjectExternal((IUnknown*)(IDropTarget*)target, true, true);
        return target;
}


void TfcUnregisterDragDrop(void * dragDrop)
{
        TfcDropTarget* target = (TfcDropTarget*) dragDrop;
        RevokeDragDrop((HWND) target->window);
        CoLockObjectExternal((IUnknown*)(IDropTarget*)target, false, true);
        delete target;
}


int TfcDoDragDrop(void* buffer, int bufferLength, int format, ScrollWin* sw)
{
       FORMATETC fmtetc = { format, 0, DVASPECT_CONTENT, -1, TYMED_HGLOBAL };
       STGMEDIUM stgmed = { TYMED_HGLOBAL, { 0 }, 0 };
       DropSource* mds=new DropSource();
       IDataObject* pDataObject;
       DWORD rez = 0;

       stgmed.hGlobal = BufferToHandle(buffer, bufferLength);

       // If the window is a drop target -> stop accepting drops
       if (sw and sw->dropData)
           ((TfcDropTarget*)sw->dropData)->acceptDrops = no;

       if (CreateDataObject(&fmtetc, &stgmed, 1, &pDataObject) == S_OK) {
            DoDragDrop( pDataObject, (IDropSource*)mds, DROPEFFECT_COPY | DROPEFFECT_MOVE, &rez);
            if (pDataObject)
                delete pDataObject;
            pDataObject = NULL;
            if (mds)
                delete mds;
            mds = NULL;
       }

       // start accepting drops once again
       if (sw and sw->dropData)
           ((TfcDropTarget*)sw->dropData)->acceptDrops = yes;

       ReleaseStgMedium(&stgmed);
       ShowCursor(TRUE);
       if (rez == DROPEFFECT_COPY)
           return 1;
       if (rez == DROPEFFECT_MOVE)
           return -1;
       return 0;
}


interface void SwxDoDragDrop(char *market, int *securities, int security, ScrollWin *owner)
/* The caller retains ownership of 'securities'. */
{       int len, format;
        void* data;

        if (strstr(market, "swx"))
            market = "XSWX";
        else if (strstr(market, "vtx"))
            market = "XVTX";
        if (securities == NULL) {
            assert(security);
            data = SwxBuilder(security, market, &len);
            format = SWX_CF_SECURITY;
        }
        else if (ListSize(securities) == 1) {
            data = SwxBuilder(securities[0], market, &len);
            format = SWX_CF_SECURITY;
        }
        else {
            data = SwxBuilder(securities, security, market, &len);
            format = SWX_CF_SECURITIES;
        }
        TfcDoDragDrop(data, len, format, owner);
}

