/* $Id: dragndrop.h 200 2005-09-23 11:05:47Z cco $ */


extern unsigned int SWX_CF_SECURITY;
extern unsigned int SWX_CF_SECURITIES;

// Global drop callback. If the callback is setted, all new dialogs
// will be registered as drop target with this callback
// Note: When dialog is registered vial global callback, x & y coordinates
// passed to the function as parameters are in screen (not client) coordinates
//extern TfcCallback DropCallback;

// This function should be called at the begining of program which will use Drag'n Drop
bool TfcInitDragDrop();

// This function should be called in the end of progran
void TfcDisposeDragDrop();


// Register the window as Drop Target 
// The returned value should be saved for future pass of TfcUnregisterDragDrop
void* TfcRegisterDragDrop(void* hwndTarget, TfcCallback callback);

// Register the scroll window as Drop Target - i.e. 
void* TfcRegisterDragDrop(ScrollWin* swTarget, TfcCallback callback);

// Returns the previous value, in case you want to later restore the previous value.
TfcCallback TfcRegisterDragDrop(TfcCallback callback);

// Begin Drag of data specified 
// sw means the window that won't accept this buffer (unless it is already drop target)
// use this parameter to prevent window accept it's own drags
int TfcDoDragDrop(void* buffer, int bufferLength, int format, ScrollWin* sw = NULL);

// Stop accepting drops
void TfcUnregisterDragDrop(void * dragDrop);

// Returns an array of securities identifiers that were dropped as 'data' 
// 'market' variable is filled with market 
int* SwxParser(void* data, int dataLength, str market);

// Returns buffer in SWX format for single security and given market
// 'length' variable is filled with length of the buffer
// Note - application's responsible to delete the buffer after using it
void* SwxBuilder(int ID, str market, int* length);

// Returns buffer in SWX format for multiply securities and given market
// 'length' variable is filled with length of the buffer
// Note - application's responsible to delete the buffer after using it
void* SwxBuilder(int* ID, int *firstID, str market, int* length);

void SwxDoDragDrop(char *market, int *securities, int firstSec, ScrollWin *owner);
// Making it as easy as it can possibly be.
// Note 1: The caller retains ownership of 'securities'. 
// Note 2: We need to know 'owner' to prevent the user dragging onto the same
//     window.  Such actions should be done internally using ::Mousestroke().
