/* $Id: easyrowcol.h 437 2005-10-14 05:00:17Z jla $ */


#ifndef EASYROWCOL_H
#define EASYROWCOL_H


#include "rowcolumn.h"
#include "excel.h"
  
typedef enum {data_none, data_string, data_security, data_broker, data_trader, data_client,
                data_integer, data_decimal, data_currency, data_date, data_date2, 
                data_time, data_time2, data_key, data_sentinel } data_enum;

struct CellProperties {
	    int fgcolour;
	    int bgcolour;
	    data_enum datatype;
	    CellProperties(int fgc, int bgc, data_enum dt) { fgcolour = fgc; bgcolour = bgc; datatype = dt;}
};


class EasyRowColCell
{
private:		
	    int bgColour, fgColour;
	    str data;
	    data_enum dataType;
        char Alignment;
public:
	    EasyRowColCell(str value, int fColour, int bColour, data_enum dType = data_string, char alignment = 'C');
        EasyRowColCell::EasyRowColCell(EasyRowColCell & orig);
    	~EasyRowColCell();		
        char GetAlignment();
	    str GetValues(int *pfgColour = NULL, int *pbgColour = NULL);		
	    data_enum GetType();
	    void SetColour(int fColour, int bColour);
	    void SetValue(str value, data_enum dType = data_string);
	    void GetColour(int *pfgColour, int *pbgColour);
};


class EasyRowColRow
{
private:
	    EasyRowColCell ** Cells;
	    int bgColour, fgColour;
        int keyindex;
        int * FirstValuesIndex;
        data_enum * pSpecialRowDataTypes;
        bool bSpecialRow;
public:
    	EasyRowColRow();
        EasyRowColRow(EasyRowColRow & orig);
        ~EasyRowColRow();
        
        void SetColumns(str * listofcolval, int fColour = 0, int bColour = 0, int keycolumnindex = -1);
        /* lisofcolvals will contain strings of the column values (all treated as data_string type) */
        void SetColumns(TfcPair * listofcols);
        /* listofcols will contain a str name (the value) and a CellProperties struct data */
        void SetKeyColumn(int keycolumnindex);
		
	    void AddColumn(str value, int fColour = 0, int bColour = 0, data_enum dataType = data_string, char alignment = 'C');       
	    bool DeleteColumn(int index);
	    bool UpdateColumnValue(int n, str newvalue, data_enum dType = data_string, int fColour = NOCOLOUR, int bColour = NOCOLOUR);
	
    	void SetColour(int fColour, int bColour);
        void SetSpecialRow(bool yesorno) { bSpecialRow = yesorno; };
	    void GetColours(int *fColour, int *bColour);
        char GetColumnAlignment(int index);
	    str GetColumnValues(int index, int *cellfgColour = NULL, int *cellbgColour = NULL);
	    str GetKeyColumn();
        int GetKeyColumnIndex();
        str GetFirstDataColumn(data_enum dtype);
    	data_enum GetColumnType(int index);

        bool IsSpecialRow() { return bSpecialRow; };
        data_enum * GetSpecialDataTypes();
		
	    str * GetColumns();
	    int MaxColumns();
};


class EasyRowCol: public RowColumnWin {
private:
		TfcPair * Header;
		int TotalColumns;
		int HighlightBg, HighlightFg;
		char DateLocale;				
		bool WantRowNumbers;
public:
		void* Export_Dlg;

        EasyRowCol(str caption, int width, int height);        
        EasyRowCol(EasyRowCol &orig);
        ~EasyRowCol();
                
        void CleanUp();
        void Clear();
        void SetupData(TfcPair * Heading, EasyRowColRow ** Data);
        void SetupData(EasyRowColRow ** Data, int totcol);
        void SetHeading(TfcPair * Heading);
        void * FindKeyRow(str key);
	int FindKeyRowI(str key);
	void SetWantRowNumbers(bool want);
        
        /* See the EasyRowColRow SetColumns functions */
        void SetRow(str * listofcolval, int fColour = 0, int bColour = 0, int keycolumnindex = -1);
        void SetRow(TfcPair * listofcols);
        void SetDateLocale(char locale);
        
        void ExportData(Excel *excel);
        void ExportDataToExcel();
        void ExportDataToExcelFile();        
	void ExportDataToExcelSimple();        
        void ExportDataToFile();
        void ExportDialog();
        void ExportDialogSimple();

        TfcPair * GetHeading() const;
                                        
	void SetHighlightColour(int fColour, int bColour);

        void AddRow(EasyRowColRow * row, bool calibrate = true);
        void InsertRow(EasyRowColRow * row, bool after, EasyRowColRow * rowanchor, bool calibrate=true);

        data_enum StringToDataEnum(str headertype);
		                                        
        virtual bool Mousestroke(int op, int x, int y);
        virtual bool Keystroke(int key);
        virtual str GetField(void* row, column_id cid, char dest[], char status,
                             int *fgcolor, int *bgcolor, char *alignment);                
        virtual kstr GetHeading(column_id cid, kstr *helpp, char *statusp);
};

#endif