/* $Id: header.h 437 2005-10-14 05:00:17Z jla $ */


#ifndef HEADER_H
#define HEADER_H

#define and             &&
#define or              ||
#define yes             true
#define no              (bool)false
#define not             !
#define forever         while (1)
#define until(c)        while (!(c))
#define clearA(A)       memset(A, 0, sizeof(A))
#define clearS(S)       memset(&S, 0, sizeof(S))
#define newc(T)         (T*)calloc(sizeof(T),1)
#define assert(c)       if (c) ; else assert_failed(__FILE__, __LINE__, #c)
#define arraymax(A)     (sizeof(A)/sizeof(A[0]))
#define NoNum           -2147483648.0
        // This represents a 'missing value'. It is one value which can be
        // used as an integer, float or double and equality testing works
        // for all of these.
#undef interface
#define interface



typedef unsigned int uint;

#include <stdlib.h>
typedef char* str;
typedef wchar_t* wstr;
typedef const char* kstr;

typedef int (*cmp_fn)(const void* A, const void* B);
typedef int (*cmp_fn_cache)(const void* A, const void* B, bool);


#define IsUTF8Alpha(s) (((s) >= 'a' && (s) <= 'z') || ((s) >= 'A' && (s) <= 'Z'))
#define IsUTF8Digit(s) ((s) >= '0' && (s) <= '9')
#define IsUTF8AlphaNum(s) (IsUTF8Alpha(s) || IsUTF8Digit(s))
#define IsUTF8HexDigit(s) (((s) >= '0' && (s) <= '9') || ((s) >= 'A' && (s) <= 'F') || ((s) >= 'a' && (s) <= 'f') )


#if defined(__BORLANDC__)

/* Borland */
#define main        BorlandMain
#define WinMain TfcWinMain
int BorlandMain(int argc, char** argv);

#else

/* Visual C++ v5 */
#pragma warning(disable : 4018)
#pragma warning(disable : 4100)            // unreferenced formal parameter
#pragma warning(disable : 4244)            // conversion from int to short
#pragma warning(disable : 4514)            // unreferenced inline fn removed
#define strdup            _strdup
#define itoa            _itoa

#endif


void assert_failed(kstr filename, int LineNo, kstr condition);
void stop(void);
void set_version_for_assert(str version);
bool streq(kstr A, kstr B);
bool strieq(kstr A, kstr B);
bool strbegins(kstr bigs, kstr smalls, bool casesensitive = no);
bool strbegins(wstr bigs, wstr smalls, bool casesensitive = no);


#endif

