

class TfcPrintJob {
	friend class PrintPreviewCell;
	friend class PrintPreviewGrid;

	ScrollWin **List;

	struct Margin_node {
		int top,bottom,right,left;
	};


	int scrollwinTop_p, scrollwinLeft_p;
	Margin_node pixMargins;
	TfcFont headerFont, footerFont;
	int headerHeight, footerHeight;
	int innerWidth, innerHeight;		// The dimensions of the scrollwin content,
										// i.e. printer dimensions minus margins/header/footer.
    class PrintPreviewGrid *PPgrid;

	// Parameters stored in registry:
	char header[512],footer[512];
    Margin_node mmMargins;
    TfcRegistryKey PrintKey;

	bool Prepare(void *DC);
	void LoadFromRegistry();
	void SaveToRegistry();
	control ParametersGui();
	bool AsIfPrintDlg(void *OwnerHwnd);
	bool PrintWithOrWithoutPreview(bool withPreview);
	

protected:

	int MMwidth;
	int logPixelsY;		// not used at present.
	int printerWidth_p, printerHeight_p;

	virtual void GetDeviceSpec(void* DC);

public:
    tfccolourmode_enum colourmode;
	char printerName[512];				// Actually stores device driver, device name and output port, separated by '\1's
	int paperSize;
	bool inActualPrinting;				// We discourage you from using this - it's in advisable
										// to have any discrepancies between PrintPreview and real printing.
	bool rememberPrinter;				// For 'Print Slip' print jobs, we want to remember in the registry
										// the fact that the user uses a non-standard printer for this type of printout.
	bool continuousRollPaper;			// This will disable footers.
	bool landscape;
	ScrollWin *owner;					// What ScrollWin is owner of the PrintPreview window?
	kstr jobName;

	TfcPrintJob(kstr jobName);
	void Add(ScrollWin *win);			// The TfcPrintJob takes ownership of this 'win'.
	void SetRegistryBranch(kstr appName);	// Call this _before_ DlgBox().
	TfcRegistryKey& GetRegistryBranch();
	void TakeBackOwnership(ScrollWin *win);
	bool DlgBox(control Options=nullcontrol, char LorP='\0');
	bool PrintWithoutPreview() { return PrintWithOrWithoutPreview(no); }
	bool PreviewAndThenPrint() { return PrintWithOrWithoutPreview(yes); }
	int GetPrinterW() { return printerWidth_p; }
	int GetPrinterH() { return printerHeight_p; }
	void Stats();
	bool isEmpty() { return List == NULL; }
	ScrollWin** getPages() { return List; }
	void HelpOnHeadersAndFooters();
	void ExpandHeaderFooter(kstr s, PrintPreviewCell *PPcell, char dest[]);
	void SetHeader(kstr _header) { strcpy(header, _header); }	// Call this _after_ DlgBox().
	void SetFooter(kstr _footer) { strcpy(footer, _footer); }	// Call this _after_ DlgBox().
	virtual bool ExpandHeaderFooterToken(kstr &s, ScrollWin *win, char dest[]) { return false; }
	virtual void AddHelpOnHeaderAndFooterTokens(char dest[]) { *dest = '\0'; }
	virtual ~TfcPrintJob();
};

class TfcContinuousRollPrintJob : public TfcPrintJob
{
public:
	TfcContinuousRollPrintJob(kstr jobName);

private:

	virtual void GetDeviceSpec(void* DC);
};