/* $Id: textgrid.h 437 2005-10-14 05:00:17Z jla $ */


/* A TextGrid is a grid of string-based cells.  It works
a lot like a spreadsheet.  It completely hides the Cell
class from the user.
*/

#ifndef GRID_H
#define GRID_H

#ifndef TFC_H
#include "tfc.h"
#endif

#define TG_MAX_LINELEN            1024*3

class TextCell;


class TextGrid : public GridWin {
        struct {                    // A cell being dragged'n'dropped
            int i,j;                    // The destination coords
            int x,y;                    // The current top-left coord in grid coords
            int offset_x, offset_y; // Mouse offset of top-left corner
            bool middle_x, middle_y;// Is it going onto a cell or between cells?
            TextCell *cell;            // The cell itself.
        } floater;
        int cursor_n;                    // The character position of the cursor
        bool InsertMode;            // Affects the width of the inside-cell cursor.

        friend class TextCell;

        TextCell *Get(int x, int y) { return (TextCell*)GridWin::Get(x,y); }
                /* This gets the relevant cell, but casts it            */
                /* to a TextCell whether or not it is a TextCell.   */
                /* The caller must ensure this assumption is valid. */


public:
        TfcFont font;
        int fontheight;
        bool split_lines;
        int line_width;
        int Dirty;        // 0=no, 1=please calc Row & Column, 2=please choose params.
        int origClientWidth, origClientHeight;

        TextGrid(str caption, int width, int height, int bg_colour,
                 tfcgridgrowmode_enum GrowMode = tfc_colshugcells);
                /* Constructor. */

        TextGrid(TextGrid &orig);
                /* Deep copy constructor */

        void Set(int x, int y, str text, char line_below=1, char line_right=1,
                    int fg_colour=NOCOLOUR, int bg_colour=WHITE, void* data=NULL,
                    int cwidth=1, int cheight=1);
        void Set(int x, int y, int num, char line_below=1, char line_right=1,
                    int fg_colour=NOCOLOUR, int bg_colour=WHITE, void* data=NULL,
                    int cwidth=1, int cheight=1);
        void Set(int x, int y, double f, char line_below=1, char line_right=1,
                    int fg_colour=NOCOLOUR, int bg_colour=WHITE, void* data=NULL,
                    int cwidth=1, int cheight=1);
                /* Create a cell with these properties. */
        #define CENTRED            16
        #define ITALICS            32
        #define RIGHTALIGN         64
                /* To use the flags, or them with the line_right parameter. */

        void SetSymbol(int x, int y, char symbol, int colour);
        void SetFormatBelow(int x, int y, char line_below);
        void SetFormatRight(int x, int y, char line_right);
        void SetColour(int x, int y, int fg_colour, int bg_colour);
        void SetData(int x, int y, void* obj);
        void SetText(int x, int y, str text);
                /* Set the various properties of a cell. */

        char GetSymbol(int x, int y, int *colourp);
        char GetFormatBelow(int x, int y);
        char GetFormatRight(int x, int y);
        int GetFlags(int x, int y);
        int GetFgColour(int x, int y);
        int GetBgColour(int x, int y);
        void* GetData(int x, int y);
        str GetText(int x, int y);
                /* Set the various properties of a cell. */

        void SetParameters(int fontheight, bool split_lines, int bold=no, bool italic=no, bool FixedWidth=no, char* Face=NULL);
                /* Set this font and split_lines and recalculates all */
                /* row and column sizes based on them. */

        void ResizeFont(int SizeDiff);
        virtual void Resized();
                /* The client width & height have been changed. */
                /* Change the display parameters (font & split_lines) */
                /* accordingly. */

        virtual bool Mousestroke(int op, int pixelx, int pixely);
                /* Process a mouse event. */

        void Paint(int pixelx1, int pixely1, int pixelx2, int pixely2);
                /* We customise this because of the possibility of floaters. */

        void SetCharCursor(int n);
                /* For a character cursor ('caret') */

        void DoDrag(int x, int y, int bg_colour, bool middle_x, bool middle_y, int *xp, int *yp);
                /* Set up this cell as a floater and then allow the user */
                /* to drag it somewhere. Replace the cell with a blank   */
                /* cell of colour 'bg_colour'. Return the destination in */
                /* *xp and *yp. */

        int GetKey(int x, int y);
        int GetKey(int x, int y, int n, bool insert_mode);
        int mouse_x, mouse_y;
                /* Get a keystroke (or mousestroke). A flashing cursor will be displayed */
                /* in the cell until the user hits a key or moves the mouse (the first         */
                /* version puts the cursor over the whole cell, the second displays a         */
                /* character cursor inside the string of the cell).  Mouse events are         */
                /* returned as 'pseudo-keystrokes': MOUSE_PRESS, MOUSE_RELEASE,                 */
                /* MOUSE_DRAG etc.; you can get the cell coordinates via gridmouse_x         */
                /* and gridmouse_y. Note that if you move the mouse with all buttons up, */
                /* it ignores this type of event: there is a MOUSE_DRAG pseudo-keystroke,*/
                /* but no corresponding MOUSE_MOVE pseudo-keystroke. */

        str Edit(int x, int y, bool WantIdentifier, int maxwidth, int& response);
                /* Edit a text cell.  Returns the keystroke used to exit the cell. */

        virtual Litewin *DuplicateMe();
                /* Deep copy. */

        void AddPrintHeader();
                /* Add time & date & file version stamps. */

        void ExportToCsv(str suggestedname, int fromrow=-1, int torow=-1);

        virtual str PrintHeader(str title, str buf) { return "TFC (C) Tim Cooper"; }
};


extern str ContextHelp;

interface int ContrastWith(int colour, int background);
        /* If 'colour' is sufficiently different from 'background',  */
        /* return it.  Otherwise try to modify it to be sufficiently */
        /* different from 'background'. */




#endif

