

// This little beauty enables good, modern-looking GUI controls:
#pragma comment(linker, "/manifestdependency:\"type='win32' " \
        "name='Microsoft.Windows.Common-Controls' " \
        "version='6.0.0.0' " \
        "processorArchitecture='*' " \
        "publicKeyToken='6595b64144ccf1df' " \
        "language='*'\"")




#ifndef HEADER_H
#include "header.h"
#endif
#ifndef NULL
#include <stdlib.h>
#endif
#ifndef TFC_H
#define TFC_H

/*------------- Input primitives: ------------*/

#define UP      UPARROW
#define DOWN    DOWNARROW


#define CTRL(c)			(c-'@')			// use this for 'A'-'Z'
#define CTRL_(fk)		(fk+12)			// use this for special keys
#define SHIFT(fk)		(fk+24)
#define IS_FUNCTION_KEY(ch)	((ch) >=F1 && (ch) <= F12+12+24)


typedef enum {  /* Keystrokes: */
        ESC=27, ENTER=13, BACKSPACE=8, TAB=9, CTRL_ENTER=10,
        CTRL_I=-8, CTRL_F= 6, SCROLL_LOCK=-50,
        ZOOM_IN=-51, ZOOM_OUT=-52,      // numeric keypad +/-

		ALT_DOWN=-16, ALT_UP=-18, ALT_RIGHT=-17, ALT_LEFT=-19, ALT_END=-21,
        ALT_HOME=-20, UNDO=-48, BACKTAB=-49,

		F1=-99, F2=-98, F3=-97, F4=-96, F5=-95, F6=-94, F7=-93, F8=-92,		// -99..-60
        F9=-91, F10=-90, F11=-89, F12=-88,

		RIGHT=-139, LEFT=-138, UP=-137, DOWN=-136, END=-135,				// -139..-100
		INS=-134, DEL=-133, HOME=-132, PG_UP=-131, PG_DOWN=-130,
        
        /* Pseudo-keystrokes: */
        MOUSE_PRESS=-1, MOUSE_DRAG=-2, MOUSE_RELEASE=-3,
        //MOUSE_CLICK=-4,  mouse-clicks are currently de-implemented, dunno why!
        MOUSE_DOUBLECLICK =-5, MOUSE_MOVE=-8,
        MOUSE2_PRESS=-9, MOUSE2_DRAG=-10, MOUSE2_RELEASE=-11, MOUSE2_CLICK=-12,
        MOUSE_WHEEL=-13,

        WINDOW_QUIT=-6, WINDOW_RESIZE=-7, AUTO_SAVE=-46, AUTO_POLL=-47, AUTO_IDLE=-14
        //SHIFT_UNDEPRESSED=-41, SHIFT_DEPRESSED=-42,
} key_enum;


#define NOCOLOUR        -1
#define BLACK           0x000000
#define WHITE           0xffffff
#define RED             0x0000ff
#define GREEN           0x00ff00
#define BLUE            0xff0000
#define YELLOW          0x00ffff
#define CYAN            0xffff00
#define PURPLE          0xff00ff
#define MAGENTA         0xff00ff
#define BROWN           0x80c0c0
#define ORANGE          0x0080ff
#define DARK(C)         ((C)&0x7f7f7f)
#define LIGHT(C)        ((C)|0xC0C0C0)
#define GREY            0x808080
#define PINK            0x8080ff
#define DARK_GREY       0x404040
#define LIGHT_GREY      0xc0c0c0
#define TFC_TRANSLUCENT 0x3000000
#define TFC_HATCH       0x2000000
#define TFC_TOPMOST     0x0000001
#define TFC_NORESIZE    0x0000002
        // "OR" this with a colour to make a special brush, e.g.:
        // DrawRectangle(0,0,80,80,GREY|TFC_TRANSLUCENT);

#define stricmp         _stricmp
#define strnicmp        _strnicmp
#define getcwd          _getcwd
#ifdef __BORLANDC__
#define main        BorlandMain
#endif


extern int SelectKeyDown;
extern int response;
extern bool QuitEventLoop;  // Signal to exit the event loop (with all windows intact).
extern class ScrollWin *CursorSw;     // Which Scrollwin has focus?

/* All printable keystrokes are from 32 to 255.  All control keystrokes are from -128 to 31. */




/*----------- main(): ----------*/
int main(int argc, char* argv[]);


class control {
public:
        struct controlprivate_node *priv;

        /* A 'control' is essentially a pointer to a controlprivate_node. */
        /* We do it this rather nonstandard way so that (a) we can modify */
        /* the implementation of controls without requiring recompilation */
        /* of application modules, and (b) because WC++ didn't allow me   */
        /* to declare operator|(class X, class X) for an as-yet undefd    */
        /* class X. An alternative is to implement this class as a pure   */
        /* virtual class (an 'interface' class). */

        void SetText(const char* newname);
                /* NB: Since this cannot resize the control, you must initialise */
                /* the control with the largest possible static text string and  */
                /* then change it. */

        str GetText(str dest, int sizeofdest);
        bool Defined() { return priv != NULL; }   /* OBSOLETE */
        operator bool() { return priv != NULL; }
        int Width();
        int Height();
        int Value();
        void SetValue(double newval);   // Works with just 'double' controls.
        void SetValue(int newval);      // Works with 'int', 'double', 'bool' and 'list' controls.
        void SetEnumValue(int n, void* varp);  // Call this on the grouping
                                        // control which includes all enum
                                        // controls for 'var'.
        void SetList(struct TfcPair* newlist);
        void SetList(str *newlist, char *newflags=NULL);     // for ComboControls
                        // and SetControls only - newflags for SetControls only
        void ChangeIcon(int icon_id);   // Works for both icons and bitmaps.
        void Enable() { SetGrey(no); }     // Un-grey
        void Disable() { SetGrey(yes); }   // Grey out
        bool IsEnabled(); // Is control enabled or not?
        void SetGrey(bool grey);
		void SetFocus();
        void Refresh();     // Refreshes selection in Set Control
                            // or appearence of toggle button if toggle status is changed
        void SelectTab(int tab);
        int WhichTabIsSelected();
		control GetLeft();
		control GetRight();
        bool operator==(control &b) { return priv == b.priv; }
        bool operator!=(control &b) { return priv != b.priv; }

        bool TextInList(str field, bool case_sensitive = false);

        void CloseDialog(int returnval = 1);
                // Closes parent dialog
                // as OK (returnval = 1) or CANCEL (returnval = -1) button pressed
};


struct controldebug_node {
        // This closely matches the 'controlprivate_node' defined inside
        // tfc.cpp, but is different.  We're trying to (a) avoid clients
        // of TFC from having to #include <windows.h>, and (b) get around
        // the bug in Borland's debugger that means it never sees the
        // definition of 'controlprivate_node'.  This is the only way;
        // if the definition of controlprivate_node is moved here, then
        // suddenly we will have HWND's etc. inside tfc.h.
        char en;
        char alignx;
        char aligny;
        char disabled;
        int x, y;
        int cx, cy;
        struct {
            union {
                void (ScrollWin::*VoidMember)();
                void *fn;
            } u;
            char ty;
            int data;
        } IfChanged;
        controldebug_node *next;
        int id;
        char* name;
        struct dialog_node* dlgOwner;
        union {
            struct {
                char* buf;
                int sizeofbuf;
                uint flags;
            } s;
            struct {
                int *ip;
                int maxm, minm;
            } i;
            struct {
                double *fp;
                double maxm, minm;
            } f;
            struct {
                bool *bp;
            } b;
            struct {
                int *ip;
                TfcPair *list;
                char sizeofi;
            } l;
            struct {
                char *flags;
                str *A;
                int A_len;
            } set;
            struct {
                char *ip;
                int value;
            } e;
            struct {
                    void *data;
                    void (*DataToString)(void *data, char* buf);
                void (*StringToData)(char* buf, void *data);
            } c;
            struct {
                control a;
                control b;
                char o;        // '-'=a on top of b,  '|'=a to the left of b
            } g;
            struct {
                void* normal;
                void* depressed;
                int cx;
                int cy;
            } bitmap;
            struct {
                control sub;
            } enclosure;
            struct {
                struct controlprivate_node **Subs;
                int Selected;
            } swapper;
            struct {
                struct tabcontrol_node* Tabs;
                int Selected;
                int height;
            } tabcontrol;
            struct {
                char* buf;
                int sizeofbuf;
                str* list;
            } combo;
            ScrollWin *sw;
            void* menu;
        } u;
};




/*----------- TfcCallbacks: ----------*/

class ScrollWin;
class CanvasObj;
class control;
struct ExpandedJpeg;


typedef void (*VoidData_fn)(void* data);
typedef int (*IntData_fn)(void* data);
typedef void (ScrollWin::*SwVoidVoid_fn)();
typedef void (ScrollWin::*SwVoidData_fn)(void* data);
typedef void (ScrollWin::*SwVoidIData_fn)(int data);
typedef void (ScrollWin::*SwVoidBData_fn)(bool data);
typedef void (ScrollWin::*SwVoidSData_fn)(str data);
        // These functions must return 0 to continue, != 0 to terminate the dialog box.

typedef bool (*drop_fn)(void* data, int dataLength,  int x, int y) ;
typedef bool (ScrollWin::*swdrop_fn)(void* data, int dataLength,  int x, int y) ;


class TfcCallback {
        /* This class allows you to take advantage of a variety */
        /* of callback formats.   (12 bytes)                    */
        union {
            int (*IntCtrlGlobal)(control c);
            int (*IntGlobal)();
            void (*VoidGlobal)();
            void (*VoidCtrlGlobal)(control c);
            int (ScrollWin::*IntCtrlMember)(control c);
            int (ScrollWin::*IntMember)();
            void (ScrollWin::*VoidMember)();
            void (ScrollWin::*VoidCtrlMember)(control c);
            void (ScrollWin::*VoidDataMember)(void *data);
            void (ScrollWin::*VoidIDataMember)(int data);
            void (ScrollWin::*VoidBDataMember)(bool data);
            void (ScrollWin::*VoidSDataMember)(str data);
            int (*IntData)(void *data);
            void (*VoidData)(void *data);
            int (*IntCanvas)(CanvasObj *data);
            void (*VoidCanvas)(CanvasObj *data);
            
            bool (*Drop)(void* data, int dataLength,  int x, int y) ;
			bool (ScrollWin::*DropMember)(void* data, int dataLength,  int x, int y) ;

            void (*VoidCtrlDataGlobal)(control c, void* data);
            int (*IntCtrlDataGlobal)(control c, void* data);

            int ReturnVal;
        } u;
        enum { IntCtrlGlobal,IntGlobal,VoidGlobal,VoidCtrlGlobal,
                IntCtrlMember,IntMember,VoidMember,VoidCtrlMember,
                VoidDataMember,
                IntData, VoidData, IntCanvas, VoidCanvas,
                DropGlobal, DropMember,
                VoidCtrlDataGlobal, IntCtrlDataGlobal,
                ReturnVal, DoNothing } type;
        void *data;

public:
        TfcCallback(int (*fn)(control c)) { u.IntCtrlGlobal = fn; type = IntCtrlGlobal; }
        TfcCallback(int (*fn)()) { u.IntGlobal = fn; type = IntGlobal; }
        TfcCallback(void (*fn)(control c)) { u.VoidCtrlGlobal = fn; type = VoidCtrlGlobal; }
        TfcCallback(void (*fn)()) { u.VoidGlobal = fn; type = VoidGlobal; }

        TfcCallback(int (*fn)(control c, void* _data), void* _data) { u.IntCtrlDataGlobal = fn; type = IntCtrlDataGlobal; data = _data; }
        TfcCallback(void (*fn)(control c, void* _data), void* _data) { u.VoidCtrlDataGlobal = fn; type = VoidCtrlDataGlobal; data = _data; }

        template <class CLASS>
        TfcCallback(int (CLASS::*fn)(control c)) { u.IntCtrlMember = (SwVoidData_fn)fn; type = IntCtrlMember; }
        template <class CLASS>
        TfcCallback(int (CLASS::*fn)()) { u.IntMember = (SwVoidVoid_fn) fn; type = IntMember; }
        template <class CLASS>
        TfcCallback(void (CLASS::*fn)(control c)) { u.VoidCtrlMember = (SwVoidData_fn) fn; type = VoidCtrlMember; }
        template <class CLASS>
        TfcCallback(void (CLASS::*fn)()) {u.VoidMember = (SwVoidVoid_fn)fn; type = VoidMember; }

        TfcCallback(drop_fn fn) { u.Drop = fn; type =DropGlobal; }			
		template <class CLASS>
		TfcCallback(bool (CLASS::*fn)(void* data, int dataLength,  int x, int y)) { u.DropMember = (swdrop_fn)fn; type =DropMember; }
		

        template <class CLASS>
        TfcCallback(void (CLASS::*fn)(int v), int _data){u.VoidIDataMember = (SwVoidIData_fn) fn; type = VoidDataMember; data = (void*) _data; }

        template <class CLASS>
        TfcCallback(void (CLASS::*fn)(bool v), bool _data){u.VoidBDataMember = (SwVoidBData_fn) fn; type = VoidDataMember; data = (void*) _data; }

        template <class CLASS>
        TfcCallback(void (CLASS::*fn)(str v), str _data){u.VoidSDataMember = (SwVoidSData_fn) fn; type = VoidDataMember; data = (void*) _data; }

        template <class TYPE, class CLASS>
        TfcCallback(void (CLASS::*fn)(TYPE v), TYPE _data){u.VoidDataMember = (SwVoidData_fn) fn; type = VoidDataMember; data = (void*) _data; }

        template <class TYPE>
        TfcCallback(int (*fn)(TYPE data), TYPE _data) { u.IntData = (IntData_fn) fn; type = IntData; data = (void*) _data; }
        template <class TYPE>
        TfcCallback(void (*fn)(TYPE data), TYPE _data){u.VoidData = (VoidData_fn) fn;type = VoidData;data = (void*) _data;}
        TfcCallback(void (*fn)(int *data), int* _data){u.VoidData = (VoidData_fn) fn;type = VoidData;data = (void*) _data;}
        TfcCallback(void (*fn)(void**data), void** _data){u.VoidData = (VoidData_fn) fn;type = VoidData;data = (void*) _data;}

        TfcCallback(int (*fn)(CanvasObj *obj)) { u.IntCanvas = fn; type = IntCanvas; data = NULL; }
        TfcCallback(void (*fn)(CanvasObj *obj)) { u.VoidCanvas = fn; type = VoidCanvas; data = NULL; }
        TfcCallback(int return_val) { u.ReturnVal = return_val; type = return_val ? ReturnVal : DoNothing; }
        TfcCallback() { u.ReturnVal = 0; type = DoNothing; }

        bool operator()(ScrollWin* sw, void* data, int dataLength,  int x, int y) ;
        int operator()(ScrollWin *sw, control c);
        int operator()(ScrollWin *sw, CanvasObj *obj);
        bool IsNull() { return type == DoNothing; }
        operator bool() { return type != DoNothing; }
        int IsSimpleInteger() { return (type == ReturnVal) ? u.ReturnVal : 0; }
};


struct TfcPoint {
    int x,y;
    // Just like POINT.  It means my clients don't need to #include <windows.h>
};


struct TfcRect {
    int top, left, right, bottom;
    // Just like RECT.  It means my clients don't need to #include <windows.h>
    void Init(int l, int t, int r, int b)
            { top=t, left=l, right=r, bottom=b; }
    bool Has(int x, int y)
            { return x >= left and x < right and y >= top and y < bottom; }
    bool Has(TfcPoint pt)
            { return pt.x >= left and pt.x < right
                    and pt.y >= top and pt.y < bottom; }

	void intersect(TfcRect &other)
	{
		top = top > other.top ? top : other.top;
		bottom = bottom < other.bottom ? bottom : other.bottom;
		left = left > other.left ? left : other.left;
		right = right < other.right ? right : other.right;
	}

	bool isEmpty() { return bottom <= top or right <= left; }
};


typedef void* TfcFont;

enum tfccolourmode_enum { tfc_unknownmode=0, tfc_blackandwhite=1, tfc_shadesofgrey=2, tfc_colour=3 };

enum tfcshowstate_enum { tfc_hiddenshouldshow, tfc_dirtyshouldpaint,
                    tfc_hidden, tfc_shown, tfc_minimised };

struct TfcPaintDetails {
	void *hDC;
	int winX,winY;				// The windows coordinate of the Litewin's (0,0) point
	TfcRect clipRegion;			// The windows coordinates of what we're allowed to paint.
	tfccolourmode_enum colourMode;
	char lineWidth;

	TfcPaintDetails() { hDC = NULL; }
	TfcPaintDetails(TfcPaintDetails &orig) { 
				hDC = orig.hDC;
				winX = orig.winX;
				winY = orig.winY;
				colourMode = orig.colourMode;
				clipRegion = orig.clipRegion;
			}
	void SetClipper();
	~TfcPaintDetails();
};


/* Distinct fonts are collected in a cache and never disposed of.
   Applications can not dispose of fonts
   Flags for describing a font to TfcFindFont(): */
#define TFC_BOLD       (1<<0)
#define TFC_ITALIC     (1<<1)
#define TFC_FIXED      (1<<2)
#define TFC_UNDERLINE  (1<<3)
#define TFC_TTONLY     (1<<4)
        // (TFC_TTONLY:  True type fonts are better on print-preview & printers)
str TfcFontName(TfcFont font, str buffer, int bufsize);
TfcFont TfcFindFont(int size, unsigned int Flags=0, char* Face=NULL);
TfcFont TfcFindFont(int height, bool bold, bool italic=no, bool FixedWidth=no, char* Face=NULL);
        /* Create a font with these properties or find an existing font */
        /* if you've already created one.   If you specify 'size' as    */
        /* negative, then this matches the Microsoft point size, e.g.   */
        /* Times Roman 12 would be TfcFindFont(-12,0,"Times Roman").    */

TfcFont TfcDefaultFont(bool bFixed = false);
TfcFont TfcPrinterFont(TfcFont ModelFont, int iNewHeight, str Face = NULL);
int TfcFontHeight(TfcFont font);
TfcFont TfcChooseFont(TfcFont font, bool bTTOnly=false);
str TfcFontToString(TfcFont font, char dest[]);
TfcFont TfcStringToFont(str s);
TfcFont TfcGetSystemFont();
str TfcGetUserName(char dest[]);
str TfcGetComputerName(char dest[]);

bool TfcShiftStatus();
bool TfcCtrlStatus();

void* TfcTopLevelHwnd(bool AllowDlgHwnds);		// Please cast this as a (HWND)
ScrollWin* TfcTopLevelSW();

int TfcContrastingColour(int colour);
void TfcBitmapDimensions(int id, int flags/*0 or TFC_JPEG*/, int *widthp, int *heightp);

/* No-one is allowed to measure text anymore without a Litewin.
It was too error-prone when trying to get printing to work.
void TextDimensions(char* buf, int n, TfcFont font, ...);
*/

class Litewin {                 // A rectangle for drawing and accepting user commands

    void* GetReady(TfcPaintDetails *paintDetails, int x, int y);

public:
    /*** Data members: ***/         // Only 8 bytes overhead!
    Litewin *parent;


    /*** Subclasses must define: ***/
    virtual void Paint(int x1, int y1, int x2, int y2) = 0;
                            // How to paint it
    virtual void CursorPaint() { };
                            // How to paint a cursor.
    virtual void Measure(int *widthp, int *heightp) = 0;
                            // Get the required width and height of this
                            // subwindow. (For all ScrollWin's, this is
                            // just defined to return realWidth/realHeight).
    virtual void GetPaintDetails(TfcPaintDetails *paintDetails, int x, int y) = 0;
                            // Interpret 'xy' as (x,y) in Windows coordinates,
							// and so on.
    virtual bool Mousestroke(int op, int x, int y) { return no; }
                            // Process a mouse button-press/release/drag.
                            // op=MOUSE_PRESS, MOUSE_DRAG or MOUSE_RELEASE.
    virtual bool Keystroke(int key) { return no; }
                            // Process keyboard input. Returns 'yes' if understood.
    virtual bool Mousemove(int x, int y) { return no; }


    /*** The Paint() function can use: ***/
    void DrawString(kstr buf, int n, TfcFont font,
                int x1, int y1, int x2, int y2,
                int foreground, int background=NOCOLOUR, int flags=0);
	void DrawStringU(kstr buf, int n, TfcFont font,
                int x1, int y1, int x2, int y2,
                int foreground, int background=NOCOLOUR, int flags=0);
    void DrawStringU(const wchar_t* wbuf, int n, TfcFont font,
        int x1, int y1, int x2, int y2,
        int foreground, int backgroun=NOCOLOUR, int flags=0);

    
    #define TFC_SINGLELINE          1
    #define TFC_WORDBREAK           2
    #define TFC_CENTRE              4
    #define TFC_RIGHTALIGN          8
    #define TFC_UPWARDSTEXT         16
    #define TFC_DOWNWARDSTEXT       32
    /* Draw this string in this rectangle.  If necessary, it first     */
    /* clears the whole rectangle, because Windows doesn't necessarily */
    /* use the whole rectangle.   Set n=-1 for the whole string. */

    void DrawString(kstr buf, TfcFont font, int x, int y, str pos,
            int foreground, int background);
    /* A quick form that saves you calling TextDimensions.  pos consists */
    /* of 2 chars: the x-position and the y-position.  x-position:       */
    /* '<'=to the left of (x,y);  '>'=to the right;  '|'=centred.        */
    /* y-position:  '^'=above y;  'v'=below;  '|'=centred. */

    void TextDimensions(kstr buf, int n, TfcFont font, uint *widthp, uint *heightp,
                    int flags=0, int maxwidth=32767);
    void TextDimensions(kstr buf, int n, TfcFont font, int *widthp, int *heightp,
                    int flags=0, int maxwidth=32767)
            { TextDimensions(buf, n, font, (uint*)widthp, (uint*)heightp, flags, maxwidth); }
    int TextWidth(kstr buf, int n, TfcFont font, int flags=0)
            { uint w,h; TextDimensions(buf, n, font, &w, &h, flags, 32767); return w; }
    /* For the whole string, you want n=-1. */

    void DrawPixel(int x0, int y0, int colour);
    /* Set a pixel. */

    void DrawLine(int x0, int y0, int x1, int y1, int colour=BLACK, int width=1);
    /* Draw a line. */

	void DrawLineWithArrow(int x0, int y0, int x1, int y1, int arrowheadSize, int colour, int width);
	/* Draw a line with an arrowhead at (x1,y1). */

    void DrawRectangle(int x0, int y0, int x1, int y1, int colour, int border=NOCOLOUR);
    /* A rectangle filled with 'colour'. */

    void DrawRectangle(TfcRect &Rect, int colour, int border=NOCOLOUR)
            { DrawRectangle(Rect.left,Rect.top,Rect.right,Rect.bottom,colour,border); }
    /* A rectangle filled with 'colour'. */

    void DrawBlendRectangle(int x0, int y0, int x1, int y1, int colour1, int colour2,
                    int clipy0=-9999, int clipy1=-9999);
    /* A rectangle whose colour blends from colour1 (top) to colour2 (bottom). */
    /* If only part of the rectangle needs updating, specify 'clipy0' and      */
    /* 'clipy1' as the range that needs painting, with y0..y1 being the range  */
    /* corresponding to colour1/colour2. */

    void DrawPolygon(int colour, int border, int x1, int y1, ...);
    #define TFC_ENDOFPOLY      -9999
    /* A polygon filled with 'colour'.  Specify the points as a variable argument   */
    /* list, terminated by TFC_ENDOFPOLY.  The last point is automatically linked  */
    /* to the first - don't specify the starting point twice. */

    void DrawPolygon(int colour, int border, TfcPoint *List, int List_idx);
    /* As above but specifies the points as an array of points. */

	void DrawRoundedPolyLine(int colour, int width, int x1, int y1, int radius, ...);
	/* A polyline with rounded corners. */

    void DrawEllipse(int x1, int y1, int x2, int y2, int colour, int border=NOCOLOUR);
    /* Draw a circle or ellipse. */

    void DrawPieSlice(int x1, int y1, int x2, int y2, double r1, double r2, int colour, int border=NOCOLOUR);
    /* Draw an arc in ellipse. */

    void DrawCurve(int Ax, int Ay, int Bx, int By, TfcRect rect, int colour, int linewidth = 1);
    /* Draw an elliptic arc. */

    #define TFC_JPEG              1
    void DrawBitmap(int x1, int y1, int x2, int y2, int bitmap_id,
                    int sourcewidth=0, int sourceheight=0, int flags=0);
    void DrawBitmap(int x1, int y1, int x2, int y2, void* hBitmap,
                    int sourcewidth=0, int sourceheight=0, int flags=0);
    void DrawMonoBitmap(int x1, int y1, int x2, int y2, int bitmap_id,
                    int fg_colour, int bg_colour,
                    int sourcewidth=0, int sourceheight=0, int flags=0);
    void DrawTransparentBitmap(int x1, int y1, int x2, int y2,
                             void* bmpImg, void* bmpMsk);
    /* Draw a bitmap, scaled if necessary. */

	void DrawJpeg(int x1, int y1, int x2, int y2, ExpandedJpeg *jpeg, int BackgroundColour=NOCOLOUR, bool border=no);
	void DrawJpeg(int x1, int y1, ExpandedJpeg *jpeg);		// <- Uses the natural dimensions.
	void DrawJpeg(TfcRect rect, ExpandedJpeg *jpeg, int BackgroundColour=NOCOLOUR, bool border=no) 
			{ DrawJpeg(rect.left, rect.top, rect.right, rect.bottom, jpeg, BackgroundColour, border); }
	/* Draw a Jpeg bitmap. */

    void PaintWhole();
    /* Paint the whole rectangle. */

	virtual void PaintWithUnscrollables(int x1, int y1, int x2, int y2) { Paint(x1,y1,x2,y2); }
	/* Overridden only by ScrollWin. */

	void Paint(TfcRect rect) { Paint(rect.left, rect.top, rect.right, rect.bottom); }
    /* Paint the specified rectangle. */

    virtual void GetFontRange(int *minheight, int *maxheight);
    /* Work out the smallest and largest readable fonts. */

    int PopUpBox(int XPos, int YPos, bool bHardy, TfcCallback OnExit, const char *Title, const char *Text, ...);
    int PopUpBox(int XPos, int YPos, const char *Title, const char *Text, ...);
    /* Pop up a little message box. */

    virtual void* FindDC();
    /* Get the device context. (Only class ScrollWin will */
    /* redefine these functions). */

	virtual ScrollWin* FindSW();

    virtual void MapXYToWindowCoords(int *Xp, int *Yp);
    virtual void MapXYToScreenCoords(int *Xp, int *Yp);
    /* Put values into X and Y and they will be adjusted into screen coords.*/

	void PopUpRect(int PopInt, TfcRect *rect);
	/* Window coords to Litewin coords */

    virtual void* _hWnd();
    /* Returns the HWND of the enclosing windows window. */
};


extern control nullcontrol;


// Constructs StatusBox for status bar
// If width is not specified, box is adjusted to fit text
struct StatusBox {   
    
    StatusBox(str text, int width = -1, int icon=-1);
    StatusBox() {text = NULL;}

    str text;
    int icon;
    int width;    
};

struct statusbox;


class ScrollWin : public Litewin {

    /*** Interfacing with Windows: ***/
    struct {
        int ms_on, ms_off;  // The cursor blink rate in milliseconds
        TfcRect rect;
        bool state;
    } cursor;
	struct {
		int x,y;
	} mousePos;
	void *hRebar;
    void *hWnd;
    void *hDC;
    void *hMemDC;
    void* hMemBuffer;
    void* oldObject;
    struct dialog_node *dialogbar;
    int DialogHeight;        
    int SbRealWidth, SbRealHeight, SbClientWidth, SbClientHeight;
    class ScrollWin *next;
    class TfcMenu *menu;
    struct accel_node {
        TfcCallback Callback;
        int key;
        struct accel_node *next;
    } **Accelerator;

    static void ReadyForMessages();
    void RestoreRebar(); /* Restore rebar in case window was detached from ScrollWin */
    void MoveRebar(void* rect);
    void SetDialogBar(class control &c, bool setup = yes);
    dialog_node *RebarFromWnd(void* hwnd);
    void DetachRebar();
    void RestoreSWParent();
	void SetFocusToChildIfNecessary();

    friend class Litewin;
    friend class PrintPreviewCell;
    friend class TfcPrintJob;
    friend class ScrollWinGridCell;
    friend class SplitWindow;
    friend void OnPaint(void* hWnd);
    friend long _stdcall ScrollWinProc(void* hWnd, uint uMsg, uint wParam, long lParam);
    friend long _stdcall DialogBarProc(void* hWnd, uint uMsg, uint wParam, long lParam);
    friend void _stdcall TimerCursorOn(void* hWnd, uint message, uint Timer, long SysTime);
    friend void _stdcall TimerCursorOff(void* hWnd, uint message, uint Timer, long SysTime);
    friend void* GetNextDialogBar(void* hwnd);
    friend struct controlprivate_node* CtlFromId(ScrollWin* sw, int id);
    friend bool PrintScrollWins2(   ScrollWin **List, str PrintJobName, str header, str footer, 
                                    void (*pFunc)(str s, char dest[]),
                                    void (*pFunc2)(void* ptr, int SheetLeft, int SheetRight, int SheetTop, int SheetBottom, bool leftLogo, bool topLogo),
									bool hidePreview);

        // Usage : 
        // 
        //  SetStatusBar("Drag window edge to add new window",
        //                StatusBox("INS"),
        //                StatusBox("SCROLL"),
        //    StatusBox("",25,100),
        //    NULL);
    void* hStatus;
    struct statusbox* sbox;

public:
    tfccolourmode_enum colourmode;

    void SetTopmost(bool set);
    void CursorOn();
    void CursorOff();
    virtual void CursorPaint() { SetCursorBlinkRate(0,0); cursor.state = no; }
    virtual void AttachToWindow(void* _hWnd);
    virtual void DetachFromWindow();
    void* _hWnd() { return hWnd; }
    tfcshowstate_enum GetShowState() { return ShowState; }
    ScrollWin *NextSw() { return next; }
    void Measure(int *widthp, int *heightp) { *widthp = realWidth; *heightp = realHeight; }
    int GetLogPixelsY(int *iScreen, int *iCurrent);
	void WakeUpWindows7();

    /*** User fields: ***/
    bool isBufferOutput;            // if true - drawing goes through memory buffer.
                                    // If you use this, you may need to call 'FlushBuffer'
                                    // after doing paints.  'FlushBuffer()' is called
                                    // automatically for you after keystroke, mouse,
                                    // WM_PAINT and menu events, but not after Timer
                                    // or TFC_CALLCALLBACK events.
    int realWidth, realHeight;      // Dimensions of the scrollable area
    int clientWidth, clientHeight;  // Dimensions of the window onto the scrollable area
    int scrollX;                    // Position of the top-left corner of the window
    int scrollY;                    // in terms of the scrollable area.
	int dontScrollX,dontScrollY;	// Size of the left and top unscrollable margins
    char ScrollbarMode;             // 'E'=easygoing, 'N'=disabled, 'X'=exact.
                                    // Warning:  'X' often leads to strange artefacts.
    int Background;                 // If scrollable is smaller than window, what colour is the background?
    char* windowTitle;              // The text that goes on the window title-bar
	char* pageTitle;				// The text that goes into printouts, or export filenames,
									// often a repeat of what's in a significant toolbar dropdown.
    tfcshowstate_enum ShowState;    // Is it hidden? Dirty? minimised?
    class TfcPrintJob *printJob;    // The TfcPrintJob that owns us, or NULL.
	bool inPrint;					// DEPRECATED: Use 'printJob!=NULL' instead.  Are we in PrintPreview/Print, or not?
	ScrollWin *owner;				// If one WS_OVERLAPPED scrollwin must be always in front of another WS_OVERLAPPED scrollWin.


    /**** ScrollWin member functions: ****/
    void SuppressPaints();  // If there's a WM_PAINT (all) in the message queue, don't bother painting anything
    void Focus(bool bUncoverApp = false); // Set the keyboard focus to this window.
                            // Use bUncoverApp to bring the whole app to the foreground
    void Hide();            // Hide
    void Show();            // Restore & show
    void Minimise();        // Minimise
    void Maximise();        // Maximise
    void Restore();         // Restore
    void InvalidateRect(int x1, int y1, int x2, int y2);
	void InvalidateRect(TfcRect rect) { InvalidateRect(rect.left,rect.top,rect.right,rect.bottom); }
                            // Send a message to (eventually) redraw this section.
    void UpdateScrollbars(int NewScrollX, int NewScrollY);
                            // Set the new scroll position to (NewScrollX, NewScrollY).
                            // It adjusts the new position according to the size of the underlying canvas.
    bool isVerticalScrollbar();
                            // Used to determine if a scrollbar is active.
	void setDontScrollMargins(int marginX, int marginY) 
			{ dontScrollX = marginX; dontScrollY = marginY; }
    void SetMenu(class TfcGenericMenuItem first, ...);
                            // Set the scrollwin's menu bar to this.
    TfcMenu* GetMenu() { return menu; }
                            // Return the handle to the menu bar.
    void SetRebar(class control c, ...);
    dialog_node *GetRebar() { return dialogbar; }
    void RemoveRebarBand(int bandN);
    void SetCursorBlinkRate(int ms_on, int ms_off) { cursor.ms_on = ms_on; cursor.ms_off = ms_off; }
    void GetCursorBlinkRate(int *ms_onp, int *ms_offp) { *ms_onp = cursor.ms_on; *ms_offp = cursor.ms_off; }
    void SetCursor(TfcRect rect);
                            // Creates a cursor.
    void GetCursorRect(TfcRect *rectp) { *rectp = cursor.rect; }
                            // Get the cursor rect in ScrollWin coordinates

    void Flash(int N);      // flash window N times
    static void Beep();     // Do BEEP. ("static" means you can use this syntax:  ScrollWin::Beep() without a scrollwin.)

    void SetMousePos(int x, int y); // Move the mouse cursor
    void SetTitle(kstr title);		// Sets the window title.
	void SetPageTitle(str name);	// Sets the page title.
    int GetKey();           // Get keyboard (or mouse) input.
    static void EventLoop();// Process all events until all windows have been killed, or see below.
    virtual bool Mousestroke(int op, int x, int y)  { return no; }
                            // Process a mouse button-press/release/drag.
                            // op=MOUSE_PRESS, MOUSE_DRAG or MOUSE_RELEASE.
    virtual bool Keystroke(int key);
                            // Process keyboard input. Returns 'yes' if understood.
    virtual void Resized(); // Process the message that the clientRect has changed.
    void PaintWhole();      // Paint the whole window including the cursor if necessary.
	void PaintWithUnscrollables(int x1, int y1, int x2, int y2);
    void SetBackground(int bg_colour) { Background = bg_colour; }
                            // Change the background colour (but don't repaint yet).
    void AddAccelerator(int key, TfcCallback Callback);
                            // Add an accelerator key.  Specify Callback=0 to remove the accelerator.
    bool ProcessAccelerator(int key);
                            // Process a keystroke with the accelerator table. This is
                            // usually only used as an internal function.
    void PopupMenu(int x, int y, TfcGenericMenuItem first, ...);
    void PopupMenu(int x, int y, TfcGenericMenuItem *items);
                            // Open a right-button popup menu

    bool IsValid();         // This must never be 'virtual'! It's used to
                            // check if a ScrollWin has been destructed.

    void SetSWParent(ScrollWin* _parent);       // set new parent to ScrollWin, 
                                                // i.e. child window

    void Move(int x0, int y0, int width, int height);   // Move the window

    void GetPaintDetails(TfcPaintDetails *paintDetails, int x, int y);
	void* FindDC();
	ScrollWin* FindSW() { return this; }

    void BufferPaints(void* DC);
    void ClearMemBuffer();
    void FlushBuffer();     //  Outputs memory buffer to screen

    void PaintCursorIfNeeded(int x0, int y0, int x1, int y1);
                            // If this area intersects the cursor rectangle
                            // and the cursor is on, paint the cursor.

    virtual Litewin* DuplicateMe() { return NULL; }
                            // Deep-copy
    ScrollWin(kstr _title, int _clientWidth, int _clientHeight, int flag = 0, ScrollWin *Owner=NULL);
                            // Constructor
                            /* flag can be combination of */
                            /* TFC_TOPMOST (Places the window above all non-topmost windows)*/
                            /* and TFC_NORESIZE (Disables window resizing feature) */
    ScrollWin(ScrollWin &orig);
                            // Deep-copy constructor
    virtual ~ScrollWin();   // Destructor

	virtual void DecideOnPageBreakPosX(int x, int *endX, int *startOfNextX);
	virtual void DecideOnPageBreakPosY(int y, int *endY, int *startOfNextY);
			// If the page break comes at pixel 'y' in the scroll-win coordinates, 
			// then at what pixel will we end the page, and at what pixel will we
			// start the next page?  Note:  startOfNextY <= endY.

    /*** Some functions we'd like to be private: ***/
    void RedrawDialogBar();
    void RedrawMenuBar();
    void TfcCheckMenuItemPressed(void* _item);
    static ScrollWin* SwFromWnd(void *hWnd);


    /*** To satisfy Litewin: ***/
    /* void Paint(..)  is still pure virtual. */


    int GetDialogHeight() { return DialogHeight; };
    void SetClientSize(int newWidth, int newHeight);
    void SetClientHeight(int newHeight) { SetClientSize(0, newHeight); };

    /* Dialog functions */
    int DoDialog(kstr title, control rootcontrol, control
            default_control=nullcontrol, int flags = 0);
    
    void* CreateModelessDialog(kstr title, control rootcontrol,
            control default_control=nullcontrol,
            TfcCallback OnExit=0, int flags=0);
            // If the title starts with '*', then it gets the WS_EX_TOPMOST
            // property i.e. stays visible at all times.

    /* Copy active window snapshot to the clipboard */
    bool SaveSnapshot(str filename, bool UseOpenFileDlg=yes, bool IncludeFrame=yes, 
            bool bToPrinter=no, str header=NULL, str footer=NULL, 
            void (*pFunc)(str s, char dest[])=NULL, 
            void (*pFunc2)(void* ptr, int SheetLeft, int SheetRight, 
                    int SheetTop, int SheetBottom, bool leftLogo, bool topLogo)=NULL);
            // If UseOpenFileDlg, then 'filename' becomes the
            // default filename for the "Open file" dialog box.
            // If IncludeFrame=yes, window is saved with frame, caption, menus, rebar etc.
            // Otherwise only client area is saved 
            
    void GetClientWindowSize(int *width, int *height);
    /* Return the true full windows size inclusive of resize bars, menus */
    /* bars and window title */

    bool IsMaximised();        
    bool IsMinimised();
    void GetClientWindowPosition(int *top, int *left);

    // Initializes application's status bar.
        // Parameters :
        //      StatusText  - text that will appear at left side of status bar
        //      box1, ... (optional) - additional status boxes that will appear on right side of status bar
    void SetStatusBar(str StatusText, StatusBox box1=StatusBox(NULL), ... );    
        // Update specified status bar box with text and/or icon
        // 0 index is for left pane
        // indexes from 1 are for right boxes
    void UpdateStatusBar(int boxN, str text, int icon = -1, int nWidth = -1); 
        // Update text at the begining of status bar 
    void UpdateStatusBar(str text);
    int  RedrawStatusBar(bool reposition = false);
    int  GetStatusBarHeight();
    
    TfcCallback dropCallback;
    void* dropData;		
};



/*----------- BitmapWin's - for cacheing graphics: -----------*/

class BitmapWin : public Litewin {
	void *hDC;
	void *hBitmap;

public:
	BitmapWin(int width, int height);
	void Paint(int x0, int y0, int x1, int y1) { }
	void Measure(int *widthp, int *heightp) { *widthp = *heightp = 0; }
	void* getBitmap();
    void GetPaintDetails(TfcPaintDetails *paintDetails, int x, int y);
	~BitmapWin();
};




/*----------- RowWin's: -----------*/

class Row : public Litewin {
public:
        int y;
        class Row *prev, *next; // The previous and next rows
        unsigned short width, height;   // The width and height of this row
        Row() { parent = NULL; prev = next = NULL; }


        /*** The application-writer provides: ***/
        virtual void Paint(int x1, int y1, int x2, int y2) = 0;
            /* Paint this row.  */

        virtual ~Row() { }


        /*** TFC provides: ***/
        void SetCursor(int x1, int y1, int x2, int y2);
            /* Create a cursor. */

        void GetPaintDetails(TfcPaintDetails *paintDetails, int x, int y);

        bool GetWinRect(TfcRect *Rect);
            /* Get the rectangle. */
};




class RowWin : public ScrollWin {
public:
        Row *root;              // The root line
        Row *focus;             // A row which hopefully takes us near where we need to start printing.


        /*** The class inheriting from RowWin provides: ***/
        virtual void PointerHasChanged(Row* Old, Row* New) { }
                                // To update all references in the application



        /*** RowWin provides: ***/
        RowWin(char* Caption, int screenwidth, int screenheight, ScrollWin *OwnerSw=NULL);
            /* Constructor. Creates it in an inactive state. */

        Row* Insert(Row* AfterThis, Row* row);
            /* Insert a row.  If AfterThis==NULL, it means at the very top. */

        Row* Delete(Row* row);
            /* Delete this row. Since the caller alloc'd it, the caller must then free it. */
            /* In case this gets complicated for the caller, we return the same row. */

        Row* Replace(Row *Old, Row *New);
            /* Replace 'Old' with 'New'.  Since the caller alloc'd Old, */
            /* the caller must then free it. */
            /* In case this gets complicated for the caller, we return Old. */

        void Paint(int x1, int y1, int x2, int y2);
            /* How to paint it */

        void Clear();
            /* We want to clear all the rows and start afresh. */

        int GetKey() { return ScrollWin::GetKey(); }
            /* Process events until we get a keystroke. */

        Row* FindRow(int y);
            /* Which row exists at this y-value? */

        void Resized();
            /* Recalculate the RowWin parameters given that rows have */
            /* changed dimensions (outside IoRowWin_ReplaceRow()). */

        void Measure(int *widthp, int *heightp);
            /* Get the width and height */

        virtual bool Mousestroke(int op, int x, int y);
        virtual bool Keystroke(int key);

        virtual ~RowWin();
            /* Delete this RowWin.  Since the caller alloc'd the rows, */
            /* the caller must free them. */

        friend class Row;
};







/*===================== GridWin's: ========================*/

/*
A GridWin is a 2-D array of GridCell's.  A GridCell is an abstract
class (it's nothing until you inherit from it and define
the Paint() member function).

The GridWin owns all objects in it.  That means that (a) you
must only pass dynamically allocated objects to a GridWin,
and (b) once you pass an object, the GridWin is responsible
for deleting it.  It deletes the GridCell's when (a) it is
deleted itself, or (b) GridWin::Clear() is called, or (c)
if you overwrite an existing GridCell with a GridWin::Set() call.

GridWin's give you a spreadsheet-like functionality.  Often,
you will find the RowColumnWin class more appropriate:  use
RowColumnWin instead of GridWin's if you have a very large
number of rows of identical format.
*/

/* How should the gridwin deal with having more room than it's cells need?
tfc_colsgrowA and tfc_colsgrowB are just spares for derived classes. */
enum tfcgridgrowmode_enum { tfc_colshugcells, tfc_colsgrowonly, tfc_colsfillwidth, tfc_colsgrowA, tfc_colsgrowB };

class GridWin : public ScrollWin {
        /* If you just want to put text strings in the cells, then */
        /* please use TextGrid (which of course is a derivative of */
        /* a GridWin). See textgrid.h. */

protected:
        void Paint(int x0, int y0, int x1, int y1);
        void PaintBottom(int x0, int y0, int x1, int y1) { };
        class GridCell ***A;
        int *Row;           // Contains numrows+1 entries
        int *Column;        // Contains numcols+1 entries
        int *Hidden;        // Contains a list of hidden columns
        bool MeasurementsDirty;     // Do we need to CalcRowY/CalcColumnX?
		bool highlightFocusedRow;
        tfcgridgrowmode_enum GrowMode;

        friend class GridCell;
        void CalcColumnX();
		
public:
        void CalcRowY();

public:
        int numrows, numcols;
        struct {
            int i,j;
        } focus, movefocus,prevfocus;
        int FontHeight;

        GridWin(kstr title, int clientWidth, int clientHeight, int colour,
					tfcgridgrowmode_enum GrowMode = tfc_colshugcells, 
					ScrollWin *Owner=NULL);
                // Constructor

        GridWin(GridWin &orig);

		virtual void HighlightFocusedRow();

        virtual Litewin* DuplicateMe();
                // Do a deep-copy

        virtual ~GridWin();
                // Destructor.

        void Set(int i, int j, GridCell *cell);
                // Set a single-cell cell.  If the location is already occupied,
                // call the destructor on the original cell.  As of this moment,
                // the grid owns the cell, not you!

        void SetExtended(int x, int y, GridCell *cell, int sx, int sy);
                // As above but allows you to span multiple rows or columns.

		void EnableFocusedRowHighlighting(bool enable);

        GridCell* TakeOwnership(int i, int j);
                // Remove this cell from this grid, replacing it with a NULL.
                // Returns the cell, which you now own.

        void TakeOwnershipAndClear();
                // Clear the grid without calling the cells' destructor. The caller now
                // owns all the cells, i.e. the caller has the responsibility of
                // deleting them.

		void DeleteRow(int y);
        void Clear();
                // Clear all cells in this grid, calling destructors for each cell.

        void CursorPaint();
        GridCell* Get(int i, int j);                // Get the cell at this grid location
        GridCell* GetFromXY(int x, int y, int *ip, int *jp);  // Get the cell at this pixel location.
                                                // Returns NULL, (-1,-1) if we're outside the grid.
		GridCell* GetRaw(int i, int j);
        int GetKey();
        int GetKey(int i, int j);
        void MoveTo(int i, int j);
        void MoveTo(GridCell *cell);
        GridCell* GetCurrentCell() { return Get(focus.i, focus.j); }
        int ColumnWidth(int i) { return Column[i+1] - Column[i]; }
        int RowHeight(int j) { return Row[j+1] - Row[j]; }
        void CalcCursorRect();
        GridCell* Sink(int x, int y);
                // Map this (x,y) value to a cell that exists.

        virtual void AddPrintHeader() { }
                // Child classes can redefine this to insert headers & footers for printing

        void Print(control c=nullcontrol);
                // Send this grid on its own to the printer.

        void SuppressPaints() { ScrollWin::SuppressPaints(); MeasurementsDirty = yes; }
                // Until further notice, don't paint or calc measurements.

        virtual void MakeMeasurements();
                // CalcRowY/CalcColumnX if necessary.
        void RemeasureCells();


        /* To satisfy 'Litewin': */
        void Measure(int *widthp, int *heightp);
        bool Mousestroke(int op, int x, int y); // Process mouse input.
        bool Keystroke(int key);                // Process keyboard input. Returns 'yes' if understood.
        virtual void Resized(); // Process the message that the clientRect has changed.
};


class GridCell : public Litewin {           // A cell of a grid.
public:
        unsigned short i,j;
        int req_width, req_height;      // Requested width and requested height.
                                        // The actual width and height (see Width() and Height())
                                        // are often larger.

		bool emptyCell;

        /* The application-writer defines: */
        virtual void CursorPaint();
                                        // How to paint a cursor.
        virtual bool Mousestroke(int op, int x, int y) { return no; }
                                        // Process a mouse button-press/release/drag.
                                        // op=MOUSE_PRESS, MOUSE_DRAG or MOUSE_RELEASE.
        virtual bool Keystroke(int key) { return no; }
                                        // Process a keyboard stroke. Returns 'yes' if understood.
        virtual Litewin* DuplicateMe() = 0;
                                        // Deep-copy
        GridCell() { parent = NULL; }       // Constructor
        virtual ~GridCell() { }             // Destructor


        /* TFC provides: */
        bool Exists() { return (unsigned long long)this > 3; }
                                        // NULL cells and EXTENSIONs don't exist.
        int Width();
        int Height();
                // This gives the actual dimensions.
        void Resize(int newwidth, int newheight);
                // Change the (requested) size.
        virtual void Measure(int *widthp, int *heightp) { *widthp = req_width; *heightp = req_height; }
                // Get the requested width and height
		void GetPaintDetails(TfcPaintDetails *paintDetails, int x, int y);

        friend class GridWin;
};


#define EXTENDED_FROM_LEFT          (GridCell*)0x1
#define EXTENDED_FROM_ABOVE         (GridCell*)0x2
#define EXTENDED_FROM_ABOVELEFT     (GridCell*)0x3



class ScrollWinGridCell : public GridCell {
public:
        ScrollWin *child;

        ScrollWinGridCell(ScrollWin* sw)
                { child = sw; sw->ShowState = tfc_shown; }

        ScrollWinGridCell(ScrollWinGridCell &orig)
                { child = (ScrollWin*)orig.child->DuplicateMe(); }

		void GetPaintDetails(TfcPaintDetails *paintDetails, int x, int y) 
				{ assert(false); /* not implemented */ }

        void Paint(int x1, int y1, int x2, int y2)
                { child->Paint(x1, y1, 9999, y2); }

        void CursorPaint()
                { child->CursorPaint(); }

        void Measure(int *widthp, int *heightp)
                { child->Measure(widthp, heightp); }

        bool Keystroke(int key)
                { return child->Keystroke(key); }

        bool Mousestroke(int op, int x, int y)
                { ((GridWin*)parent)->MoveTo(this); return child->Mousestroke(op, x, y); }

        Litewin* DuplicateMe()
                { return new ScrollWinGridCell(*this); }
};






/*------------------ Dialog Boxes: ----------------*/

class CanvasObj;





control operator-(control a, control b);
control operator|(control a, control b);
control operator/(control a, control b);        // A high-precedence alternative to operator|
control AlignXCentre(control a);
control AlignXRight(control a);
control AlignXLeft(control a);
control AlignXExpand(control a);
control AlignYCentre(control a);
control AlignYTop(control a);
control AlignYBottom(control a);
control AlignYExpand(control a);
control GridLayout(control a);
control StaticText(kstr name);
control StaticBitmap(int bitmap_id, int cx=0, int cy=0);
control StaticIcon(int icon_id);
        #define TFC_HAND            32513
        #define TFC_QUESTION        32514
        #define TFC_EXCLAMATION     32515
        #define TFC_ASTERISK        32516
control BitmapButton(int bitmap_id,
                int pressedbitmap_id, TfcCallback IfChanged);
control BitmapButton(int bitmap_id,
                int pressedbitmap_id, int cx, int cy, TfcCallback IfChanged);
control IconButton(int icon_id, TfcCallback);
control IconButton(int icon_id, int size, TfcCallback);
control ToggleButton(kstr name, bool* status, TfcCallback IfPressed=0, uint flags=0);
control Button(kstr name, TfcCallback, uint flags=0);
        #define TFC_GREYED              1
        #define TFC_SKINNYBUTTON        2
        #define TFC_SHORTBUTTON         4
        #define TFC_DEFPUSHBUTTON       8
control MenuControl(kstr name, TfcMenu* menu, uint flags=0);
control ColourControl(int *colour, TfcCallback IfChanged=0);
control Control(bool *bp, kstr name, TfcCallback IfChanged=0);
control Control(int *ip, kstr name, int minm, int maxm, TfcCallback IfChanged=0);
control Control(double *fp, kstr name, double minm=-1e12, double maxm=1e12, TfcCallback IfChanged=0);

control Control(char* buf, int sizeofbuf, kstr name,
                int width=20, TfcCallback IfChanged=0, uint flags=0, int height=3);
/* The height parameter is only needed for multiple line textboxes.
   It is the MINIMUM number of lines to be shown. */
        #define TFC_NOEDIT              2
        #define TFC_MULTILINE           4
        #define TFC_PASSWORD            8

control Control(ScrollWin *sw);
control CustomControl(void* data, char* name, int width,
                        void (*DataToString)(void *data, char* buf),
                        void (*StringToData)(char* buf, void* data), 
						TfcCallback IfChanged=0);
        /* This creates a 'customedit' control, which is a string edit box */
        /* where the caller defines the way the string is converted to/from */
        /* the underlying data. */

control TrackBarControl(int nMinValue, int nMaxValue, int nWidth, int nHeight, TfcCallback IfChanged=0);
control OkButton();
control CancelButton();

struct TfcPair {                /* (name,value) pairs for the benefit of the List controls. */
        kstr name;
        const void *data;

        TfcPair(kstr _name, const void* _data) { name = _name; data = _data; }
        TfcPair(kstr _name, int _data) { name = _name; data = (void*)(long)_data; }
};

int compar_pairs(TfcPair *A, TfcPair *B);

control ComboControl(char *buf, int sizeofbuf, str *Suggestions /*dynamic array*/,
        int width=-1 /*in chars*/, str heading=NULL, TfcCallback IfChanged=0);
control ListControlWithSize(void *ip, int sizeofi/*1 or 4*/,
                TfcPair *list/*dynamic array*/, TfcCallback IfChanged=0);
control SetControl(char flags[], char* A[], int A_len=-2, TfcCallback IfChanged=0, str NormalWidthString=NULL, bool SetSingle=false);
control SetControl(bool flags[], char* A[], int A_len=-2, TfcCallback IfChanged=0, str NormalWidthString=NULL, bool SetSingle=false);
control EnumControlWithSize(void *vp, int sizeofv/*1 or 4*/, int value,
                char* name, TfcCallback IfChanged=0);
#define ListControl(field,list,callback)\
                ListControlWithSize(field, sizeof(*field),list,callback)
        /* Warning: don't change 'list' while the ListControl still exists, */
        /* unless you do it via c.SetList(). */
#define EnumControl(field,value,name,callback)\
                EnumControlWithSize(field, sizeof(*field),value,name,callback)
control FillerControl(int x, int y);
control Enclosure(char *name, control sub);
control Swapper(control *Subs, int Default);
control Swapper(int NumControls, int Default, /* Num controls */...);
void    SwapperSelect(control swapper, int Selected);

typedef struct tabcontrol_node {        // This is for the 'tabcontrol' for people who
        str name;                       // don't like the variable-argument-list method.
        controlprivate_node *sub;
        tabcontrol_node(str _name, control c)
                { name = _name; sub = *(controlprivate_node**)&c; }
} *tabcontrol_type;

control TabControl(int NumTabs, int DefaultTab, /* name1, control1, name2, control2, etc. */...);
control TabControl(tabcontrol_type Tabs, int Default);
/*      Example of use:

        DoDialog("Tabbed Dialog", TabControl(3,1,
                        "Pane 1", StaticText("Hello"),
                        "Pane 2", Button("Press me, please", 2),
                        "Pane 3", OkButton()
        ));
*/

void TfcEndDialog(int returnval);       // controls in modal dialog boxes may want to call this.

#define TFC_DLG_MODELESS		1	
#define TFC_DLG_CHILD			2
#define TFC_DLG_MINIMISE		4


interface int DoDialog(kstr title, control rootcontrol, control default_control=nullcontrol,
                ScrollWin* Owner=NULL, int flags=0);

int DoDialog(kstr title, control rootcontrol, control
                default_control, ScrollWin* Owner, int flags);
int DoChildDialog(kstr title, control rootcontrol, control
                default_control=nullcontrol);
        // Create a dialog box owned by the currently open dialog box.
        // It's just a wrapper around DoDialog().

void* CreateModelessDialog(kstr title, control rootcontrol,
                control default_control=nullcontrol,
                TfcCallback OnExit=0,
                ScrollWin* Owner=NULL,
                int flags=0);
        // If the title starts with '*', then it gets the WS_EX_TOPMOST
        // property i.e. stays visible at all times.
void KillModelessDialog(void* hWnd);
void FocusModelessDialog(void* hWnd);
void HideModelessDialog(void *hWnd);
void ShowModelessDialog(void *hWnd);

		// If the change messages are enabled
		// then en_string control call TfcCallback after each string text change
void EnableChangeMessages();
void DisableChangeMessages();


/* Example of use:


static int PressMe() { return 5; }
static int NameChanged() { return 0; }

int main(int argc, char* argv[])
{       control left, right, phase;
        static struct {
                char Name[12];
                char Word[12];
                bool Adult;
                bool ByteSwapped;
                int Age;
                int Hobbies;
                int Phase;
        } X;
        static char* HobbyArray[] = { "golf", "tennis", "rowing", "singing", NULL };
        int result;

        left =  Control(&X.Adult, "Adult")
                    -
                StaticText("Tim's test Dialog Box");
                    -
                Control(X.Name, "Name", sizeof(X.Name), NameChanged)
                    -
                Button("Press me now please", PressMe)
                    -
                (OkControl() | Control(X.Word, "Word", sizeof(X.Word)))
                    -
                BitmapButton(IDB_BITMAP1, IDB_BITMAP2, 48, 48, PressMe)
                    -
                StaticBitmap(IDB_BITMAP2, 48, 48);
        right = Control(&X.ByteSwapped, "ByteSwapped")
                    -
                Control(&X.Age, "Age", 2, 50, NULL)
                    -
                ListControl(&X.Hobbies, HobbyArray)
                    -
                Button("PressMe", PressMe)
                    -
                CancelButton();
        phase = (EnumControl(&X.Phase, 1, "Red", NULL) | EnumControl(&X.Phase, 2, "Green"))
                    -
                (EnumControl(&X.Phase, 3, "Blue") | EnumControl(&X.Phase, 4, "Black"));
        right = right
                    -
                phase;
        result = DoDialog("Tester", left | (r -
                                            phase));
        return result;
}
*/


/* FAQ: When are callbacks called?

for Control(char*,..), Control(float*,...), Control(int*,...):
        - On killing focus if data was changed
        - On hitting ENTER in rebars

for ComboControl and ListControl
        - drop-down list is closed : on killing focus (or ENTER in rebars)
          if data was changed
        - drop-down list is open :
            On selection, using mouse or keyboard (arrow keys + ENTER)
            On ENTER after typing (only in rebars)

for all buttons:
        - When hit.
*/





/*---------------- Standard dialog boxes: ---------------*/

void TfcMessage(kstr title, char icon, const char* text, ...);
        /* Display a message box. */

void TfcMessageWithHelp(kstr title, char icon, kstr helpText, char* fmt, ...);
        /* Display a message box with a help button. */

void TfcQuickMessage(int milliseconds, kstr fmt, ...);
		/* Display a message that disappears by itself. */

int TfcChoose(kstr title, kstr choices, kstr text, ...);
        /* This provides a dialog box with a small set of alternatives. */
        /* The alternatives are specified as a sequence of null-terminated  */
        /* strings, e.g.:  "One\0Two\0Three\0Four\0".  It returns a number  */
        /* in this case from 1 to 4, being the index into this sequence, or */
        /* -1=none of the above.  Following the TFC dialog box conventions, */
        /* -1=cancel, 1+ is the choice and it never returns 0 because 0     */
        /* means nothing yet chosen.                                        */
        /* (NB: DON'T FORGET THE '\0' AT THE END OF THE LAST ALTERNATIVE!)  */
        /* E.g.:

            result = TfcChoose("Choosing", "Kill\0Die\0Learn\0~Live\0Love\0", "Choose one:");
        */

char* TfcSelectFilename(bool for_save,
            char* dest, int sizeofdest,
            kstr filter, kstr extension,
            kstr title=NULL);
        /* Choose a filename. Example:
                TfcSelectFilename(yes, filename, sizeof(filename),
                        "Comma-separated values (eg. excel)\0*.csv\0"
                        "Tab-separated values (eg. OASIS)\0*.txt\0",
                        "csv");
        */


char** TfcSelectMultiFilenames(
            char* defvalue,
            char* filter, char* extension, str title=NULL);
        /* Choose a set of filenames. */

str TfcSelectDir(char dest[], str title);
        /* Choose a directory */

int TfcChooseColour(str title, int defaultcolour);
        /* Choose a colour. */

void TfcSetWaitBoxButtonText(str text);
void TfcYesTheyWantToCancel();
void TfcClearWantToCancel();
bool TfcWantsCancel();
void TfcWaitBoxOnTheTop(bool on=yes);
bool TfcWaitBox(str fmt, ...);
        /* Set up a modeless 'wait while I'm processing' box. */
        /* Pass it fmt=NULL to close the box. */

int  TfcPopUp(int XPos, int YPos, bool bHardy, TfcCallback OnExit, char *Title, char *Text, ...);
void TfcPopDown(int PopInt);
void TfcPopUpRect(int PopInt, TfcRect *pRect);
        /* Create and display a Popup window. Copy Text to a strduped buffer,   */
        /* and put the buffer pointer in window extra membory.                  */

str TfcStrerror(int LastError=0);
        /* Like a Win32API version of 'strerror(errno)'. */



/*------------------- Menu's: -------------------*/

class TfcGenericMenuItem {
public:
        kstr name;
        int icon;
        int flags;
        void* hmenu;
        void* value;
        void** selector;
        int id;
        TfcCallback Callback;
        class TfcMenu *winMenu;
        bool IsNull() { return Callback.IsNull() and selector == NULL
                                and value == NULL and winMenu == NULL; }
                        // Sometimes menu entries are made completely
                        // unavailable, not just greyed out.
        TfcGenericMenuItem() {value = NULL; selector = NULL; }
};


class TfcMenu {
        void *winMenu;
        virtual void Dummy() = 0;
        // This is a strange class - there is never any instance
        // of it.  Instead we pretend that Menu handles are pointers and
        // use this class to implement some member functions.
public:
        void Add(TfcGenericMenuItem item);
        void Del(str name);
        void Del(int id);
        void Del(TfcMenu* menu);
        void Grey(str name, bool greyed);
        void Grey(int id, bool greyed);
        void GreyLeaves(bool greyed);
        void SetCheckMark(int id, bool checked);
        void Clear();
        void RedrawIfNecessary();
};


TfcGenericMenuItem TfcMenuItem(kstr name, TfcCallback Callback, bool greyed=no, int icon=0);
TfcGenericMenuItem TfcCheckMenuItem(kstr name, bool* checkValue, TfcCallback Callback=0, bool greyed=no, int icon=0);
TfcGenericMenuItem TfcRadioMenuItem(kstr name, void** selector, const void* value, TfcCallback Callback=0, bool greyed=no, int icon=0); // for 4-byte variables
TfcGenericMenuItem TfcRadioMenuItem(kstr name, char* selector, char value, TfcCallback Callback=0, bool greyed=no, int icon=0);  // for 1-byte variables
TfcGenericMenuItem TfcSubMenu(kstr name, TfcGenericMenuItem first, ...);
TfcGenericMenuItem TfcSubMenu(TfcMenu **destp, kstr name, TfcGenericMenuItem first, ...);
TfcGenericMenuItem TfcSubMenu(kstr name, TfcGenericMenuItem *List);
TfcGenericMenuItem TfcSubMenu(TfcMenu **destp, kstr name, TfcGenericMenuItem *List);
TfcMenu*           TfcPopupMenu(TfcGenericMenuItem first, ...);
TfcGenericMenuItem TfcSeparator();

void TfcRefreshCheckMenuItem(bool* value);
void TfcRefreshRadioMenuItem(void** selector);


/* Use it e.g. like this:
        #define Sub     TfcSubMenu
        #define It      TfcMenuItem
        scrollwin->SetMenu(
            Sub("&File",
                It("&New", New),
                It("&Open", Open),
                It("&Save", (SwVoidVoid_fn)MyGrid::Save),
                NULL),
            NULL
        );
*/







/*---------------- A busy cursor: ---------------*/

void TfcBusyOn();
void TfcBusyOff();
void TfcBusyPush();
void TfcBusyPop();
        /* Turn on and off the busy cursor.  */

void TfcCursorNormal();
void TfcSplitCurOn();
void TfcSplitCurOff();
void TfcDragCurOn();
void TfcDragCurOff();
void TfcSetCursor(int cursor_id);

bool TfcCommandReady();

bool TfcYield(bool DoCommands);
        /* Process all pending messages, with the possible exception    */
        /* of menu selections and button messages where the user has    */
        /* specified DoCommands=no.   This allows users to do a form of */
        /* cooperative multitasking, and get the advantages of multi-   */
        /* threaded programs without the effort of using semaphores etc.*/
        /* Returns 'yes' if there's a keystroke event or other command  */
        /* pending. */

void TfcSleep(int milliseconds);
        /* Sleep for this many milliseconds.  Currently it won't process */
        /* messages during the sleep, eventually we might make it process */
        /* non-command messages during the sleep. */

#define TFC_CALLCALLBACK        8111
        /* This is a windows message-type requesting the ScrollWin      */
        /* message-processor to call a Tfc callback. */

void TfcPostCallback(void (*Callback)());
        /* Post a callback call to the message loop, to be done after all */
        /* other pending messages. */

void TfcDebug(const char* fmt, ...);

typedef void (*TfcMsgHandler_fn)(int msg, long wParam, long lParam);
uint TfcRegisterMsgHandler(str MessageName, TfcMsgHandler_fn Handler);
        /* Register this function as a handler for the specified        */
        /* message.  'MessageName' is any string up to 256 bytes long   */
        /* which corresponds to what has been passed to the Win32       */
        /* RegisterWindowMessage() function (=GlobalAddAtom?) by        */
        /* another application.  (Returns the message id).              */

typedef kstr (*TfcDisplayStringConverter_fn)(kstr s);
extern TfcDisplayStringConverter_fn TfcDisplayStringConverter;
		/* An inversion-of-control method of passing every string thru */
		/* a regional customiser. */



/*------------------- Saving & restoring window positions: ---------------*/

class TfcWindowPosition {
public:
	int left, top, width, height;
	bool maximised;
	bool defined;

	TfcWindowPosition();
	void readFromString(kstr s);
	void writeToString(char dest[]);
	void sendToWindow(ScrollWin *win);
	void readFromWindow(ScrollWin *win);
	void sendToRegistry(kstr subkeyName);
	void readFromRegistry(kstr subkeyName);

	// Putting it all together:
	void saveToRegistry(ScrollWin *win, kstr subkeyName);
	bool restoreFromRegistry(ScrollWin *win, kstr subkeyName);
};

/* Example:
int main()
{
	TfcPrintParamSetRegistryBranch("Edval");
	GridWin *grid = new GridWin("main",200,200);
	TfcWindowPosition posn;
	posn.restoreFromRegistry(grid, "position_mainWindow");
	...
	posn.saveToRegistry(grid, "position_mainWindow");
}
*/




/*---------------- Help: ---------------*/


void ViewHelp(kstr text);
        /* View this help text by creating or recreating or raising the help window. 
           The width and height is locked to 400 by 600. */

void ViewHelpWithPosition(int w, int h, kstr text);
        /* View this help text by creating or recreating or raising the help window. 
           This version gives the option of width and height. */

void ViewHelpFile(str filename);
        /* DON'T USE THIS FUNCTION unless you really want to.  It is like the above fn          */
        /* but views a file.  Programmers are encouraged to use 'ViewHelp("...help text...")'   */
        /* rather than ViewHelpFile(filename) because this way the help-text is automatically   */
        /* linked into the executable, it is closely associated with the relevant area of       */
        /* source-code, and it is more convenient to provide fine-grained context-specific help.*/

TfcCallback HelpCallback(kstr helpText);
TfcGenericMenuItem TfcHelpMenuItem(kstr menuText, kstr helpText);

extern TfcCallback F1Callback;



/*--------------- Printing: --------------*/

bool PrintScrollWins1(control Options=nullcontrol, char LorP='\0', bool hideDialog = no);
        /* This does the setting up: the Print dialog box(es). */
        /* LorP must be 'L' for Landscape, 'P' for Portrait or */
        /* '\0' for UseDefault, except that on at least one    */
        /* Win98 machine, anything other than '\0' causes it   */
        /* to crash so '\0' is safest. */

bool PrintScrollWins2(ScrollWin **List, str PrintJobName=NULL,
                str header=NULL, str footer=(str)0x1, void (*pFunc)(str s, char dest[])=NULL, 
				void (*pFunc2)(void* ptr, int SheetLeft, int SheetRight, int SheetTop, int SheetBottom, bool leftLogo, bool topLogo)=NULL,
				bool hidePreview = no);
        /* After processing the print parameters, the caller passes */
        /* in the list of ScrollWin's. Here we do the Print Preview */
        /* and eventual printing. */

bool PrintScrollWins(ScrollWin **List, str PrintJobName=NULL,
                control Options=nullcontrol, char LorP='\0',
                str header=NULL, str footer=(str)0x1, void (*pFunc)(str s, char dest[])=NULL, 
				void (*pFunc2)(void* ptr, int SheetLeft, int SheetRight, int SheetTop, int SheetBottom, bool leftLogo, bool topLogo)=NULL);
        /* If the set of ScrollWins doesn't depend on any print parameters, */
        /* you can just use this 1-function version.  See above for the     */
        /* parameter definitions. */

tfccolourmode_enum PrintScrollWinsColourMode();

void TfcPrintParamSetRegistryBranch(kstr appName);		// store settings here
control TfcPrintParamGui();
void TfcPrintParamSaveToRegistry();
void TfcPrintRegisterHeaderToken(str name, str helpText, str (*fn)(ScrollWin*, char[]));
		/* Control over TFC-level print controls */



/*------------------ Splitter Windows: ---------------*/
class Splitter;


class SplitWindow : public ScrollWin {

        SplitWindow* childLT;           // These 3 ptrs define a tree
        SplitWindow* childRB;
        SplitWindow* parent;

        ScrollWin* leaf;                // This is the application object!

        Splitter*  splitter;            // Misc objects.
        Splitter*  splitterL;            // Misc objects.
        Splitter*  splitterR;            // Misc objects.
        Splitter*  splitterT;            // Misc objects.
        Splitter*  splitterB;            // Misc objects.
        ScrollWin* maxWindow;

        void SetWinToAdd(str win_code);
public:
        SplitWindow(char* title, int x, int y, ScrollWin* topWin = NULL);
                // creates top-level split window

        virtual ~SplitWindow();
        
        void Split(ScrollWin* win, ScrollWin* new_win, double ratio = 0.5, char direction = 'T');
                        // With this method, the caller specifies the
                        // placement details
        void Split(ScrollWin *origWin, ScrollWin* newWin, int x, int y);
                        // With this method, the diagonal cross method
                        // is used.

        void Remove(ScrollWin* win);

        void MaximizeChild(ScrollWin* win);
                // maximize window
        void RestoreChild();
                // restore all windows

        bool isMaximized() { return maxWindow != NULL;}

        str SavePositions(char dest[]);        
        void LoadWindows(str s);      // LoadWindows is the inverse of
        // SavePositions, except that it calls "virtual CreateWin()"
        // many times in order to restore the positions.
        bool Keystroke(int key);
        bool Mousestroke(int op, int x, int y);

        virtual void AttachToWindow(void* _hWnd);
        virtual void DetachFromWindow();
        
        str RecurseSavePositions(char dest[], SplitWindow* top);

        // use this to adjust split windows size from a save string
        // note: RecurseLoadWindows will create windows
        // but this function just adjust existing windows
        void RecurseAdjustPositions(str& s, SplitWindow* top);


protected :
        SplitWindow(SplitWindow* parent, ScrollWin* stuff);
        void SplitInternal(SplitWindow* leftWin, SplitWindow* rightWin,
                        double dividerLocation, char direction);
        SplitWindow* Find(ScrollWin* win);
        void MaximizeChild(SplitWindow* win);
        int Remove(SplitWindow* win);
        int removeLeft();
        int removeRight();
        bool isLeft(SplitWindow* win);
        bool isRight(SplitWindow* win);
        void Substitute(SplitWindow* oldWin, SplitWindow* newWin);
        void ShowLeft(bool show = yes);
        void ShowRight(bool show = yes);
        void SetSplitMode(char mode);   // = '-' or '|'
        void Resized();        // Process the message when the clientRect has changed.
        virtual void Paint(int x1, int y1, int x2, int y2) {}
        virtual void Measure(int *widthp, int *heightp) {}
        double splitRatio;
        bool disableChildDelete;

        bool DeleteChild();

        char splitMode;                 // = '-' or '|'
        int showMode;
        void GetClientRect(void* rect);
        void MoveSplitter(int newlocation, bool include_rebar = false);
        void MoveSplitter( double newlocation);

        int cx;
        int cy;

        virtual str* GetWindowList() {return NULL;} 
                /* Must be reloaded to use mouse 'right-grag' feature for split creation*/
                /* Must return a TfcArray of strings that will be shown in popup menu */ 
                /* after dragging as a suggestion of window to create */
                /* Note : item of this list will be send as a parameter to CreateWin to */
                /* create selected window */

        void RemoveAll();
                /* Removes all split sub-window. Leaves only top-level window (whithout any child in it */ 

        // Use this to get the number of window splits in the application
        int GetNumWindowSplits();
        // Then use it to pass an array of size GetNumWindowSplits() into this function
        // Note, negative denotes horizontal splits
        int SavePositionsArray( double* arrays );
        
        void RecurseLoadWindows(str &s, SplitWindow* top);
        virtual str GetWinCode(ScrollWin* sw) {return "";} 
                /* must set meaningfull codes  for each window. */
                /* Used for saving positions  */
        virtual ScrollWin* CreateWin(str s) {return NULL;}
                /* must create window depending on window code  */
        

        SplitWindow* GetTopSplit();        

        void DeleteSplitters();
        void SetSplittersAround();

            // functions for right-button drag splitting
        void SplitStart(char split_mode);                
        void SplitEnd();                
        void SplitDrag(int x, int y);                
        void DoSplitDrag(int x, int y, char mode, void* _wndGrey);
        void DoSplitEnd(char mode, void* _wndGrey);
        void* wndGrey;
        double ratio;        
        char _splitting;
        ScrollWin* _new_window;        

        friend class Splitter;
};

/* Use as follows : 

  //To create SplitWindow with single child window
            splitWin = new SplitWindow("Main",400,400, scrollwin1);  
    
  // or
            splitWin = new SplitWindow("Main",400,400);  
            .....
            splitWin->Split(NULL,scrollwin1);


  // To place another window on top of scrollwin1
                splitWin->Split(scrollwin1,  scrollwin2,0.5,'T');

  // To (re)place scrollwin2 window on left of scrollwin1
            splitWin->Split(scrollwin1,  scrollwin2 ,0.75,'L');

            
  
*/

/*------------------ The Windows Clipboard: ----------------*/

void ClipboardSetText(wchar_t* text);

void ClipboardSetText(kstr text);
        /* Copy this text into the clipboard.  The caller */
        /* still owns 'text', i.e. should eventually free it. */

wstr ClipboardGetTextW();

str ClipboardGetText();
        /* Return the text in the clipboard.  NULL=no clipboard. */
        /* The caller must free the string that is returned. */





/*----------------- Timers: ----------------*/

int TfcStartTimer(int MilliSec, TfcCallback callback);
void TfcKillTimer(int timer);
        /* Warning: you can't use ScrollWin member function callbacks here, */
        /* only static functions. */



/*----------------- AATimers: ----------------*/

int AAStartTimer(int MilliSec, VoidData_fn callback, void * data);
void AAKillTimer(int timer);



/*--------------- The Registry: -----------------*/

#define TFC_CURRENT_USER        "a"
#define TFC_LOCAL_MACHINE       "b"
#define TFC_USERS               "c"
#define TFC_CURRENT_CONFIG      "d"
#define TFC_CLASSES_ROOT        "e"


class TfcRegistryKey {
        void *hKey;   // <-- the Win32 API 'HKEY'

public:
        TfcRegistryKey(bool allow_create, kstr root, ...);
        TfcRegistryKey() { hKey = NULL; }
        operator bool() { return hKey != NULL; }
        str Get(char dest[], int sizeofdest);
        void Set(kstr value);
        void SetBinary(void* data, int len);
        str Get(kstr subkey, char dest[], int sizeofdest);
        void Set(kstr subkey, kstr value);
        TfcRegistryKey Subkey(bool allow_create, kstr s);
		TfcRegistryKey ChildKey(int idx, char name[], int sizeofname);
};


/* Use as follows:
  // Getting:
  TfcRegistryKey foo(no,TFC_CURRENT_USER,"Software","Smarts","foo",NULL);
        if (foo) {
          char buf[512];
                foo.Get(buf,sizeof(buf));
                printf("foo = %s\n", buf);
        }

        // Setting:
  TfcRegistryKey foo(yes,TFC_CURRENT_USER,"Software","Smarts","foo",NULL);
        foo.Set("Hello");

        // Or the short forms:
  TfcRegistryKey(no,TFC_CURRENT_USER,"Software","Smarts",
            "foo",NULL).Get(buf,sizeof(buf));
  TfcRegistryKey(yes,TFC_CURRENT_USER,"Software","Smarts",
            "foo",NULL).Set("Hello");
*/







/*--------------- File mapping, filename locking: -----------------*/

void* TfcMapFile(const char* filename, unsigned int *lengthp, char errormsg[], bool for_write=no);
void TfcUnmapFile(void *mem);

bool TfcLockFilename(str filename, int seconds_to_wait, char *errormsg=NULL);
bool TfcUnlockFilename(str filename);
        /* Set 'seconds_to_wait' to 99999 for the blocking version, or  */
        /* 0 for an immediate failure.  To trap the return message on   */
        /* failure, specify a destination buffer 'errormsg'.            */
        /*      Filename locking is different to file-locking.  You use */
        /* filename locking if you use 'fopen(..., "wt")' to write the  */
        /* file. */

class TfcLnkFile {
        /* This class helps you decode the shortcut files (*.LNK's) */

public:
        char arguments[512];
        char description[512];
        unsigned short hotkey;
        char iconPath[512];
        int  icon;
        char filePath[512];
        int  showCmd; //SW_SHOWNORMAL, SW_SHOWMAXIMIZED, SW_SHOWMINIMIZED
        char workingDirectory[512];
        char linkPath[512];
        char dirPath[512];

        TfcLnkFile(char* _linkPath);
};

str TfcNormalisePath(str filename, char dest[512]);
        /* Resolve any *.LNK references in this path. */

str TfcDesktopFolder(char dest[]);



/*------------------ Unicode and UTF8: --------------------*/
bool WideToUtf8(wchar_t *wide, char utf8[], int sizeofutf8);
bool Utf8ToWide(kstr utf8, wchar_t wide[], int sizeofwide);
int utf8len(str buf, str bufEnd = 0);
wchar_t* ToWideStrdup(const char *buf);

bool ConvertFileFromUT8ToUnicode(const char* sUTFInput, const char* sUnicodeOutput, bool bConvertCommaToTabs = false);



/*----------------- Invoke the browser -------------------*/
void InvokeURL(kstr URL);



//------------------- JpegFile.h: -------------------
struct ExpandedJpeg;

ExpandedJpeg* JpegLoad(kstr filename, int maxWidth=1<<30);
void JpegDestroy(ExpandedJpeg* jpeg);
void JpegGetNaturalDimensions(ExpandedJpeg* jpeg, int *widthp, int *heightp);
bool JpegIsDownscaled(ExpandedJpeg* jpeg);
bool JpegDownscale(kstr source_filename, char dest_filename[], int maxWidth, char errmsg[]);
ExpandedJpeg* BitmapResourceAsExpandedJ(int id);
char* JpegData(ExpandedJpeg *jpeg, unsigned int *lenp);
bool JpegSave(ExpandedJpeg *jpeg, const char dest_filename[], char errmsg[]);
int JpegGetWidth(ExpandedJpeg* jpeg);
int JpegGetHeight(ExpandedJpeg* jpeg);
bool IsInActualPrinting();
int GetPrinterW();
int GetPrinterH();


/*------------------ DPI Macros --------------------*/


// how much to scale a design that assumes 96-DPI pixels


#define SCALEX(argX) ((int) ((argX) * DpiGetScaleX()))
#define SCALEY(argY) ((int) ((argY) * DpiGetScaleY()))


double DpiGetScaleX();
double DpiGetScaleY();
void DpiInitScaling();


// Use this for doing initialisation and clean up, e.g.
//        AutoInitAndCleanUp AutoConfigInit(&initConfig, NULL);
// * initFunc will be called at constructor (or right after winmain and before the app main if its global)
// * cleanUpFunc will be called at destructor


typedef void (*VoidFuncPtr)();


class AutoInitAndCleanUp {
private:
    VoidFuncPtr initFunc;
    VoidFuncPtr cleanUpFunc;

public:
    AutoInitAndCleanUp(VoidFuncPtr initFunc, VoidFuncPtr cleanUpFunc);
    ~AutoInitAndCleanUp();

    void CallInitFunc() const;
    void CallCleanUpFunc() const;
};


kstr TfcGetAppVersion();
kstr TfcGetExePath();
kstr TfcGetFileVersion(kstr filePath);
str TfcGetTempFileName(char dest[]);
kstr TfcCreateGuid(char dest[]);


/*--------------- 7z Edval compression: -----------------*/

// return value 0 = all is ok
// return value not null => it is bug, described in errorCompress
int CompressInMemory(char* inBuf, size_t inBufLen, char* outBuf, size_t &outBufLen, char errmsg[]);
int UnCompressInMemory(char* inBuf, size_t inBufLen, char* outBuf, size_t &outBufLen, char errmsg[]);

int CompressFile(char* fromFilePath, char* toFilePath, char errmsg[]);
int UnCompressFile(char* fromFilePath, char* toFilePath, char errmsg[]);

// buffer is allocated using maloc(), you need free(buffer) after use it
int FilePathToBuffer(char* filePath, unsigned long& buffer, unsigned long &bufferSize, char errmsg[]);
int UncompressBuffer(char* inData, size_t inDataSize, char*& outData, unsigned long &outSize, char errorCompress[]);

const char* PJsonDecode(const char* inbuffer, int len, size_t unpackedSize);

/*--------------- Laco's Dump system -------------------------------------*/
void OpenDump(str filepath=NULL);
void CloseDump();
void StartClock(str message);
void DumpClock(str message, bool deltaTime = no);
void Dump(str window, int resp=210);

#endif      // ifdef TFC_H