#include <stdio.h>
#include <a.out.h>
#include <ldfcn.h>
typedef LDFILE *LDPTR;
#define NULL_LDPTR ((LDPTR)NULL)


static int symndx;
static LDPTR gldptr;
static SYMR sym;
static char *name;

extern char *ldgetname();

static void process(LDPTR ldptr)
{
  extern void ProcessLocalEntry(),ModuleOutOfDate();
  extern unsigned char ProcessExportEntry(); /* boolean */

  symndx = 0;
  gldptr = ldptr;		/* for global access */
  if (ldtbread(ldptr,symndx,&sym) == SUCCESS) {
    if (strncmp("/stab",ldgetname(ldptr,&sym),5)) { /* not a mod2 file */
      return;
    }
    symndx++;
    if (ldtbread(ldptr,symndx,&sym) != SUCCESS) {
      fprintf(stderr,"Couldn't read second symbol\n");
      return;
    }
    while (1) {
      if (sym.st != scNil) ModuleOutOfDate();
      if (sym.value || (sym.st == stGlobal)) {
	if (!ProcessExportEntry()) break; /* end of module info */
      }
      else {
	ProcessLocalEntry();
      }
    }
  }
  else {
    fprintf(stderr,"Couldn't read first symbol\n");
  }
}

void GetNewEntry(char **entry)
{
  *entry = ldgetname(gldptr,&sym);
  symndx++;
  if (ldtbread(gldptr,symndx,&sym) != SUCCESS) {
    fprintf(stderr,"ldtbread failed in GetNewEntry\n");
  }
}

void ProcessObject(char *fn, int fnlen) 
{
  LDPTR ldptr,newptr;

  if (NULL_LDPTR != (ldptr = ldopen(fn,NULL))) {
    if (ISARCHIVE(ldptr->type)) {
      newptr = ldaopen(fn,ldptr);
      do {
	process(newptr);
      } while (ldclose(newptr) == FAILURE);
    }
    else {
      process(ldptr);
      ldclose(ldptr);
    }
  }
  else
    fprintf(stderr,"imc:ProcessObject:ldopen(%s) failed\n",fn);
}
