/*****************************************************************************
 *									     *
 *             Copyright 1984-1992 Digital Equipment Corporation             *
 *                         All Rights Reserved				     *
 *								             *
 * Permission to use, copy, and modify this software and its documentation   *
 * is hereby granted only under the following terms and conditions.  Both    *
 * the above copyright notice and this permission notice must appear in all  *
 * copies of the software, derivative works or modified versions, and any    *
 * portions thereof, and both notices must appear in supporting              *
 * documentation.							     *
 *									     *
 * Users of this software agree to the terms and conditions set forth        *
 * herein, and hereby grant back to Digital a non-exclusive, unrestricted,   *
 * royalty-free right and license under any changes, enhancements or         *
 * extensions made to the core functions of the software, including but not  *
 * limited to those affording compatibility with other hardware or software  *
 * environments, but excluding applications which incorporate this software. *
 * Users further agree to use their best efforts to return to Digital any    *
 * such changes, enhancements or extensions that they make and inform        *
 * Digital of noteworthy uses of this software.  Correspondence should be    *
 * provided to Digital at:						     *
 * 									     *
 *                       Director of Licensing				     *
 *                       Western Research Laboratory			     *
 *                       Digital Equipment Corporation			     *
 *                       250 University Avenue				     *
 *                       Palo Alto, California  94301  			     *
 * 									     *
 * This software may be distributed (but not offered for sale or transferred *
 * for compensation) to third parties, provided such third parties agree to  *
 * abide by the terms and conditions of this notice.  			     *
 * 									     *
 * THE SOFTWARE IS PROVIDED "AS IS" AND DIGITAL EQUIPMENT CORP. DISCLAIMS    *
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED        *
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.   IN NO EVENT SHALL DIGITAL    *
 * EQUIPMENT CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR     *
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF    *
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR     *
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR    *
 * PERFORMANCE OF THIS SOFTWARE.				    	     *
 *									     *
 *****************************************************************************/

/* This was written by CED on 3/21/87 */
/* updated on 3/24/87 (corrected & improved by our local C expert, DBW) */
/* further commented on 3/21/88 (which happens to be exactly 1 year later) */

/* This function duplicates that provided by libpc, so you can use %n in 
   Modula-2 even though you don't have Berkeley Pascal. */

/* This is called to get the name of an enumerated type variable or constant.*/
/* The enumerated type name table is generated by the compiler, */
/* and this function does a table look-up. */

/* The comments below were taken from {../mod2/,[-.mod2]}CheckBuiltin.mod */

/*
The NameTable for an enumerated type looks like:

NameTable   .WORD16     # elements (n)
	    .WORD16     Name0 - NameTable - 2
	    .WORD16     Name1 - NameTable - 2
	    ...
	    .WORD16     Namen - NameTable - 2
Name0	    .BYTE       name0 string followed by null (i.e. a CString or ASCIIZ)
Name1	    .BYTE       name1 string followed by null
	    ...
Namen			nothing at all...just a pointer past end of table

*/

/* This should return a pointer to a CString suitable */
/* for printing by fprintf (i.e. writef in DECWRL Modula-2). */

/* The format character to print the name of an enumerated type is %n. */
/* The compiler changes that to %s (CString) and a call to this function. */

/* For the Ultrix version of this, see shodha::/src/V2.0/usr.lib/libpc/NAM.c */

#include <stdio.h>

char *NAM (e, table)
int e;		/* an enumerated type ordinal value (a 32 bit int or a long) */
char *table;	/* a pointer to an enumerated type name table */
{

    /* We hope register hints and initialization should improve optimization. */

    /* Address of first table element (skip the first two bytes of count) */
    register int tmp = (int) (table + 2);
    /* Number of elements in the table (first two bytes, n = count) */
    register short *n = (short *)table;
    
    if (e < 0 || e >= *n)
    {
	/* Most errors (like this) are usually handled by runtime.c */
	/* In this case, I copied the behavior of NAM.c (w/ a better err msg) */

	fprintf(stderr,
       "\nEnumerated type value of %ld is out of range (%d,...,%d) on output\n",
	e,0,*n);

#ifndef VMS
	_cleanup(); /* Only used on Ultrix (see {../lib/,[-.lib]}runtime.c) */
#endif
	abort();
    }

    /* The return statement below was optimized. These comments should help */
    /* understand what is going on. The table description above should help. */
    /* Apparently, vcc generates better code for this than the other version */
    /* of NAM.c (used in libpc). */

    /* name_offset below is offset from "table" for a particular string name */
    /* which corresponds to a particular enumerated-type ordinal value "e" */

    /* (e<<1) = e * 2 = offset into table to which contains (name_offset - 2) */
    /* (tmp + (e<<1)) gives actual address of (name_offset - 2) */
    /* *(short *)(tmp + (e<<1)) gives contents = (name_offset - 2) */
    /* (*(short *)(tmp + (e<<1)) + tmp) gives (name_offset - 2) + tmp */
    /* or (name_offset - 2) + (table + 2) or (table + name_offset) */
    /* which is the address of the string name, then typecast with (char *) */
    
    return((char *)(*(short *)(tmp + (e<<1)) + tmp));
}
