(*
    RealInOut module for the DEC MIPS Modula-2 compiler.
    Philip A. Nelson   (phil@cs.wwu.edu)
    April 1991

    This is public domain software.

    This module was provided as central point for all the TextIO
    calls in the "standard Wirth" I/O modules.  It is not part
    of the standard library as defined by Wirth.
*)


IMPLEMENTATION MODULE TextIO;

IMPORT io;

FROM strings IMPORT Length, Append;

FROM unix IMPORT fflush;


  PROCEDURE OpenIn (VAR f: File; FileName : ARRAY OF CHAR);
    VAR newfile : File;
    BEGIN
      newfile := io.Open(FileName,"r");
      IF newfile <> NIL THEN
        f := newfile;
        Done := TRUE;
      ELSE
        Done := FALSE;
      END;
    END OpenIn;

  PROCEDURE OpenOut (VAR f: File; FileName : ARRAY OF CHAR);
    VAR newfile : File;
    BEGIN
      newfile := io.Open(FileName,"w");
      IF newfile <> NIL THEN
        f := newfile;
        Done := TRUE;
      ELSE
        Done := FALSE;
      END;
    END OpenOut;

  PROCEDURE OpenInput (VAR f: File; defext: ARRAY OF CHAR);
    VAR FileName : ARRAY [ 0 .. 80 ] OF CHAR;
        itms : INTEGER;
        len  : INTEGER;
        ch   : CHAR;
    BEGIN
      FileName[0] := 0C;
      io.Writef (io.output, "Input File Name: ");
      itms := io.Readf (io.input, "%s", FileName);
      REPEAT
        IF io.Readc (io.input, ch) < 0 THEN
     	  ch := EOL;
        END;
      UNTIL ch = EOL;
      len := Length(FileName);
      IF len > 0 THEN
        IF FileName[len-1] = '.' THEN
           Append (FileName, defext);
        END;
        OpenIn (f, FileName);
      ELSE
        Done := FALSE;
      END;
    END OpenInput;

  PROCEDURE OpenOutput (VAR f: File; defext: ARRAY OF CHAR);
    VAR FileName : ARRAY [ 0 .. 80 ] OF CHAR;
        itms : INTEGER;
        len  : INTEGER;
        ch   : CHAR;
    BEGIN
      FileName[0] := 0C;
      io.Writef (io.output, "Output File Name: ");
      itms := io.Readf (io.input, "%s", FileName);
      REPEAT
        IF io.Readc (io.input, ch) < 0 THEN
     	  ch := EOL;
        END;
      UNTIL ch = EOL;
      len := Length(FileName);
      IF len > 0 THEN
        IF FileName[len-1] = '.' THEN
           Append (FileName, defext);
        END;
        OpenOut (f, FileName);
      ELSE
        Done := FALSE;
      END;
    END OpenOutput;

  PROCEDURE Close (VAR f : File);
    BEGIN
      IF f <> NIL THEN
        io.Close(f);
        f := NIL;
      END;
    END Close;

  PROCEDURE  Read (f: File; VAR ch : CHAR);
    BEGIN
      IF f = tty THEN f := io.input END;
      Done := io.Readc (f, ch) = 0;
    END Read;

  PROCEDURE  ReadLn (f: File) ;
    VAR ch : CHAR;
    BEGIN
      REPEAT Read (f, ch) UNTIL (ch = EOL) OR NOT Done;
    END ReadLn;

  PROCEDURE ReadString (f: File; VAR str : ARRAY OF CHAR);
    VAR Ix : INTEGER;
        ch : CHAR;
    BEGIN
      Ix := 0;
      REPEAT
        Read (f, ch);
      UNTIL NOT Done OR (ch <> " ");
      WHILE Done AND (Ix < HIGH(str)-1) AND (ch > " ") DO
        str[Ix] := ch;
        INC(Ix);
        Read (f, ch);
      END;
      str[Ix] := 0C;
      termCH := ch;
    END ReadString; 

 
  PROCEDURE  ReadInt (f: File; VAR int : INTEGER);
    BEGIN 
      IF f = tty THEN f := io.input END;
      Done := io.Readf (f, "%d", int) = 1;
    END ReadInt;

  PROCEDURE  ReadCard (f: File; VAR card : CARDINAL);
    BEGIN
      IF f = tty THEN f := io.input END;
      Done := io.Readf (f, "%u", card) = 1;
    END ReadCard;

  PROCEDURE  ReadOct (f: File; VAR card: CARDINAL);
    BEGIN
      IF f = tty THEN f := io.input END;
      Done := io.Readf (f, "%o", card) = 1;
    END ReadOct;

  PROCEDURE  ReadHex (f: File; VAR card: CARDINAL);
    BEGIN
      IF f = tty THEN f := io.input END;
      Done := io.Readf (f, "%x", card) = 1;
    END ReadHex;

  PROCEDURE  ReadReal (f: File; VAR r: REAL);
    BEGIN
      IF f = tty THEN f := io.input END;
      Done := io.Readf (f, "%f", r) = 1;
    END ReadReal;


  PROCEDURE  Write (f: File; ch : CHAR);
    BEGIN
      io.Writec (f, ch);
    END Write;

  PROCEDURE  WriteLn (f: File);
    BEGIN
      io.Writec (f, EOL);
      fflush (f);
    END WriteLn;

  PROCEDURE WriteNStr (f: File; Str : ARRAY OF CHAR; n : CARDINAL);
    VAR len, ix : INTEGER;
    BEGIN
      len := Length (Str);
      WHILE n > len DO
     	io.Writec (f, " ");
        DEC(n);
      END;
      ix := 0;
      WHILE ix < len DO
        io.Writec (f, Str[ix]);
        INC(ix);
      END;
      Done := TRUE;
    END WriteNStr;

  PROCEDURE  WriteString (f: File; str : ARRAY OF CHAR);
    BEGIN
      WriteNStr (f, str, 0);
    END WriteString;

  PROCEDURE  WriteInt (f: File; int : INTEGER; n : CARDINAL);
    VAR Str : ARRAY [ 1..30 ] OF CHAR;
    BEGIN
      io.SWritef (Str, "%d", int);
      WriteNStr (f, Str, n);
    END WriteInt;

  PROCEDURE  WriteCard (f: File; card, n : CARDINAL);
    VAR Str : ARRAY [ 1..30 ] OF CHAR;
    BEGIN
      io.SWritef (Str, "%u", card);
      WriteNStr (f, Str, n);
    END WriteCard;

  PROCEDURE  WriteOct (f: File; card, n : CARDINAL);
    VAR Str : ARRAY [ 1..30 ] OF CHAR;
    BEGIN
      io.SWritef (Str, "%o", card);
      WriteNStr (f, Str, n);
    END WriteOct;

  PROCEDURE  WriteHex (f: File; card, n: CARDINAL);
    VAR Str : ARRAY [ 1..30 ] OF CHAR;
    BEGIN
      io.SWritef (Str, "%x", card);
      WriteNStr (f, Str, n);
    END WriteHex;

  PROCEDURE  WriteReal (f: File; r: REAL; n: CARDINAL);
    VAR Str : ARRAY [ 1..30 ] OF CHAR;
    BEGIN
      io.SWritef (Str, "%g", r);
      WriteNStr (f, Str, n);
    END WriteReal;

BEGIN
  tty := io.output;
END TextIO.
