/* coroutine procedures for DEC/MIPS modula-2.

   Written by Philip A. Nelson,  April 21, 1991.
   
   This is public domain software.

   Due to the lack of the "asm" construct, we have
   to modify the .s file after a "cc -S ...".
   Just add the assembly line in each "asm" comment.

*/

#include <stdio.h>

/* Process structure */

typedef struct process_rec {
    char    *base;
    unsigned size;
    char    *stack_ptr;
    void    (*entry)();
    long     state;
} process_rec;

/* Definitions for coroutines*/
#define READY 1
#define NOT_READY 0
#define STACK_MIN_SIZE 512

static process_rec main_prog = { 0, 0, 0, 0, READY };

static process_rec *current_process = &main_prog;


/* NEWPROCESS:  Set up the process structure at the end of the
   stack area.  Mark not ready so transfer can call the 
   procedure. */

void SYSTEM_newprocess (proc, base, size, pcss)
    void (*proc)();
    char *base;
    unsigned size;
    process_rec **pcss;
{
  /* Check stack size */
  if (size < STACK_MIN_SIZE) {
    fprintf (stderr,"NEWPROCESS: Stack too small.\n");
    exit (1);
  }

  /* Set up stack and record structure. */
  *pcss = (process_rec *) (base + size - sizeof (process_rec) - sizeof(long));
  (*pcss)->base = base;
  (*pcss)->size = size;
  (*pcss)->entry = proc;
  (*pcss)->stack_ptr = ((char *) *pcss) - 2*sizeof (long);
  (*pcss)->state = NOT_READY;
}


/* TRANSFER:  transfer control to another coroutine. */

void SYSTEM_transfer (current, new)
   process_rec **current, **new;
{
  char *_tmp;
  register void (*_tmp1)();

  /* Save current process information and check stack. */
  *current = current_process;
/*asm   sw $sp,_tmp    */
  (*current)->stack_ptr = _tmp;

/*d printf ("Old stack = 0x%x\n", _tmp); */
  if ((*current)->stack_ptr < (*current)->base) {
    fprintf (stderr, "TRANSFER: Stack overflow, process = 0x%x\n",
             (*current)->entry);
    exit(1);
  }

  /* Run the new process. */
  current_process = *new;
/*d printf ("New stack = 0x%x\n", (*new)->stack_ptr); */
  if ((*new)->state == NOT_READY) {
    (*new)->state = READY;
    _tmp1 = (*new)->entry;
    _tmp = (*new)->stack_ptr;
/*asm  lw $sp, _tmp */
    (*_tmp1)();
    /* if we return from here, there is trouble! */
    fprintf (stderr, "TRANSFER: Returned from a process. \n");
    exit(1);
  } else {
    _tmp = (*new)->stack_ptr;
/*asm  lw $sp,_tmp  */
    return;
  }
}
