#include <stdio.h>
#include <sym.h>
#include <symconst.h>
#include <cmplrs/stinfc.h>
#include <cmplrs/stsupport.h>

extern pDNR st_pdn_idn(int idn);
extern pEXTR st_pext_iext(int index);
extern pSYMR st_psym_ifd_isym(int ifd,int index);
extern pAUXU st_paux_iaux(int iaux);

int rfd_idn(int idn)
{
  return st_pdn_idn(idn)->rfd;
}

int index_idn(int idn)
{
  return st_pdn_idn(idn)->index;
}

int sneak_iaux_idn(int idn)
{
  pDNR pdn;
 
  pdn = st_pdn_idn(idn);
  return st_iaux_rfd_index(pdn->rfd,pdn->index);
}

int st_iaux_rfd_index(int rfd,int index)
{
  pAUXU paux;
  int iaux;
  pEXTR pext;

  iaux = indexNil;
  if (rfd == ST_EXTIFD) {
    pext = st_pext_iext (index);
    if (pext->ifd == st_currentifd())
      iaux = (st_psym_ifd_isym(pext->ifd, pext->asym.index))->index;
  } 
  else if (rfd == st_currentifd()) 
    iaux = (st_psym_ifd_isym(rfd,index))->index;
  if (iaux != indexNil) {
    paux = st_paux_iaux(iaux);
    if ((paux->ti.bt == btTypedef) &&
	(paux->ti.tq0 == tqNil) && /* no type quals */
	(paux->ti.fBitfield == 0) && /* no size specifier */
	(paux[1].isym != -1)) {	/* and not waiting for BackPatch */
      iaux = st_iaux_rfd_index(paux[1].rndx.rfd,paux[1].rndx.index);
    }
  }
  return iaux;
}
#if 0
void st_addtq(int iaux,int tq)
{
  pAUXU paux;

  paux = st_paux_iaux(iaux);
  if (paux->ti.tq0 == tqNil)
    paux->ti.tq0 = tq;
  else if (paux->ti.tq1 == tqNil)
    paux->ti.tq1 = tq;
  else if (paux->ti.tq2 == tqNil)
    paux->ti.tq2 = tq;
  else if (paux->ti.tq3 == tqNil)
    paux->ti.tq3 = tq;
  else if (paux->ti.tq4 == tqNil)
    paux->ti.tq4 = tq;
  else if (paux->ti.tq5 == tqNil)
    paux->ti.tq5 = tq;
  else
    st_warning("auxialary overflow in st_addtq");
}
#endif

int FileNumber(FILE *f) 
{
  return fileno(f);
}
