MODULE prep;

(*****************************************************************************
 *									     *
 *         Copyright 1987, 1988, 1989 Digital Equipment Corporation          *
 *                         All Rights Reserved				     *
 *								             *
 * Permission to use, copy, and modify this software and its documentation   *
 * is hereby granted only under the following terms and conditions.  Both    *
 * the above copyright notice and this permission notice must appear in all  *
 * copies of the software, derivative works or modified versions, and any    *
 * portions thereof, and both notices must appear in supporting              *
 * documentation.							     *
 *									     *
 * Users of this software agree to the terms and conditions set forth        *
 * herein, and hereby grant back to Digital a non-exclusive, unrestricted,   *
 * royalty-free right and license under any changes, enhancements or         *
 * extensions made to the core functions of the software, including but not  *
 * limited to those affording compatibility with other hardware or software  *
 * environments, but excluding applications which incorporate this software. *
 * Users further agree to use their best efforts to return to Digital any    *
 * such changes, enhancements or extensions that they make and inform        *
 * Digital of noteworthy uses of this software.  Correspondence should be    *
 * provided to Digital at:						     *
 * 									     *
 *                       Director of Licensing				     *
 *                       Western Research Laboratory			     *
 *                       Digital Equipment Corporation			     *
 *                       250 University Avenue				     *
 *                       Palo Alto, California  94301  			     *
 * 									     *
 * This software may be distributed (but not offered for sale or transferred *
 * for compensation) to third parties, provided such third parties agree to  *
 * abide by the terms and conditions of this notice.  			     *
 * 									     *
 * THE SOFTWARE IS PROVIDED "AS IS" AND DIGITAL EQUIPMENT CORP. DISCLAIMS    *
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED        *
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.   IN NO EVENT SHALL DIGITAL    *
 * EQUIPMENT CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR     *
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF    *
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR     *
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR    *
 * PERFORMANCE OF THIS SOFTWARE.				    	     *
 *									     *
 *****************************************************************************)


(*

prep runs the Preprocess module on the standard input file and writes to the
standard output file.  For now it always runs in "match-any-case" mode.

||| This really should take real live file names and stuff, but people in
Colorado Springs wanted it in a hurry.

*)


FROM IO IMPORT
    File, input, output, terminal, Open, Close, ReadS, WriteS, WriteF, WriteC;

FROM ASCII IMPORT
    TAB, LINEFEED, CharSet;

IMPORT strings;
IMPORT Preprocess;

CONST MAXLINEINDEX = 2048;

TYPE
    LineIndex   = [0..MAXLINEINDEX];
    Line	= ARRAY [0..MAXLINEINDEX-1] OF CHAR;
    FileDesc    = POINTER TO FileDescRec;
    FileDescRec = RECORD
	next	    : FileDesc;
	name	    : Preprocess.FileName;
	file	    : File;
	lineNumber  : CARDINAL;
    END;

VAR
    topFileDesc : FileDesc;
    line	: Line;
    lineIndex   : LineIndex;

PROCEDURE Error(CONST line    : ARRAY OF CHAR;
		CONST position: INTEGER);
    VAR i : INTEGER;
BEGIN
    i := 0;
    LOOP
	CASE line[i] OF
	| TAB, ' '..'~' :
	    WriteC(terminal, line[i]);
	| LINEFEED, 0C :
	    EXIT;
	| ELSE
	    WriteC(terminal, '?');
	END;
	INC(i);
    END;
    WriteC(terminal, '\n');
    FOR i := 0 TO position-1 DO
	IF line[i] = '\t' THEN
	    WriteF(terminal, '\t');
	ELSE
	    WriteC(terminal, ' ');
	END;
    END;
    WriteF(terminal, '^\n');
END Error;

PROCEDURE InitError(CONST message : ARRAY OF CHAR;
		    CONST line    : ARRAY OF CHAR;
		    CONST position: INTEGER);
BEGIN
    WriteF(terminal, 'Bad program argument: %s\n', message);
    Error(line, position);
END InitError;

PROCEDURE DirectiveError(CONST message : ARRAY OF CHAR;
			 CONST line    : ARRAY OF CHAR;
			 CONST position: INTEGER);
BEGIN
    WriteF(terminal, 'File %s, line %d: %s\n',
	    topFileDesc^.name^, topFileDesc^.lineNumber, message);
    Error(line, position);
END DirectiveError;

PROCEDURE EndError(CONST message   : ARRAY OF CHAR;
		   CONST lineNumber: INTEGER);
BEGIN
    WriteF(terminal, 'End-of-file %s: %s %d\n',
	    topFileDesc^.name^, message, lineNumber);
END EndError;


VAR info    : Preprocess.Info;
    newFile : File;
    fileDesc: FileDesc;

BEGIN (* prep *)
    Preprocess.Init(FALSE, InitError, DirectiveError, EndError);
    Preprocess.StartFile();

    NEW(topFileDesc);
    WITH topFileDesc^ DO
	next	    := NIL;
	NEW(name, strings.Length('input')+1);
	name^	    := 'input';
	file	    := input;
	lineNumber  := 0;
    END;

    REPEAT
	WHILE ReadS(topFileDesc^.file, line) DO
	    INC(topFileDesc^.lineNumber);
	    lineIndex := 0;
	    WHILE line[lineIndex] IN CharSet{' ', TAB} DO
		INC(lineIndex);
	    END;
	    IF (line[lineIndex] = '$') AND
	       (* Don't bother if it looks like a Makefile macro *)
	       (NOT (line[lineIndex+1] IN 
		    CharSet{'(', '{', '*', '@', '<', '?', '%'})) THEN
		Preprocess.Directive(line, topFileDesc^.lineNumber, info);
		IF info.includeName # NIL THEN
		    (* Trying to do include file *)
		    newFile := Open(info.includeName^, "r");
		    IF newFile = NIL THEN
			WriteF(terminal, 'Cannot open include file %s\n',
			    info.includeName^);
			Error(line, info.includePos);
		    ELSE
			NEW(fileDesc);
			WITH fileDesc^ DO
			    next       := topFileDesc;
			    name       := info.includeName;
			    file       := newFile;
			    lineNumber := 0;
			END;
			topFileDesc := fileDesc;
			Preprocess.StartFile();
		    END;
		END (* IF include file *)
	    ELSIF NOT info.skip THEN
		WriteS(output, line);
	    END;
	END (* WHILE *);
	Preprocess.EndFile();
	Close(topFileDesc^.file);
	DISPOSE(topFileDesc^.name);
	fileDesc := topFileDesc;
	topFileDesc := topFileDesc^.next;
	DISPOSE(fileDesc);
    UNTIL topFileDesc = NIL;
END prep.
