implementation module BuiltinUC;

(*****************************************************************************
 *									     *
 *             Copyright 1984-1992 Digital Equipment Corporation             *
 *                         All Rights Reserved				     *
 *								             *
 * Permission to use, copy, and modify this software and its documentation   *
 * is hereby granted only under the following terms and conditions.  Both    *
 * the above copyright notice and this permission notice must appear in all  *
 * copies of the software, derivative works or modified versions, and any    *
 * portions thereof, and both notices must appear in supporting              *
 * documentation.							     *
 *									     *
 * Users of this software agree to the terms and conditions set forth        *
 * herein, and hereby grant back to Digital a non-exclusive, unrestricted,   *
 * royalty-free right and license under any changes, enhancements or         *
 * extensions made to the core functions of the software, including but not  *
 * limited to those affording compatibility with other hardware or software  *
 * environments, but excluding applications which incorporate this software. *
 * Users further agree to use their best efforts to return to Digital any    *
 * such changes, enhancements or extensions that they make and inform        *
 * Digital of noteworthy uses of this software.  Correspondence should be    *
 * provided to Digital at:						     *
 * 									     *
 *                       Director of Licensing				     *
 *                       Western Research Laboratory			     *
 *                       Digital Equipment Corporation			     *
 *                       250 University Avenue				     *
 *                       Palo Alto, California  94301  			     *
 * 									     *
 * This software may be distributed (but not offered for sale or transferred *
 * for compensation) to third parties, provided such third parties agree to  *
 * abide by the terms and conditions of this notice.  			     *
 * 									     *
 * THE SOFTWARE IS PROVIDED "AS IS" AND DIGITAL EQUIPMENT CORP. DISCLAIMS    *
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED        *
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.   IN NO EVENT SHALL DIGITAL    *
 * EQUIPMENT CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR     *
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF    *
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR     *
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR    *
 * PERFORMANCE OF THIS SOFTWARE.				    	     *
 *									     *
 *****************************************************************************)

from Machine import
    WORDSIZE, BYTESIZE, UNITSPERWORD,BYTESPERWORD,BYTESPERADDR;

from Symbols import
    LabelNumber, EvalMode, PointerKind, PointerKindSet, GlobalSymKind,
    ProcNode, ExprNode, ExprList, DataType, BuiltinProcType,
    integerTypeNode, charTypeNode, addressTypeNode,  
    cardIntTypeNode, TypeNode, NULLLABEL, MemoryOffset, ArrayKind,
    MAXBUILTINSCOPES;

from TypeInfo import
    SizeOf, BaseType;

from Compatible import Compatible;

from UCode import
    MapT,NewLabel;

from GenUC import
    GenExpr, GenIndirectVar, GenConstInteger, GenCondition, 
    GenLibCall,RTlevel,UcodeTemp,curUcodeBlock,theCharArray,
    GenChangeType;

from Runtime import 
    RuntimeProc,NOPCODEBLOCK;

from Alloc import RoundUp;

from IO import SWriteF;

from Errors import
     Error;

from Mipudef import
     Uopcode, Datatype, Memtype;

import MipSym;

from MipUco import
     Uco1int,Ucomem,Uco2typint,Uco1type,Uco2int,Ucoldc,Ucolab,Uco2typtyp,
     Ucosym,Uco4int,Uco0,
     NOSTRING;

from SymbolDump import StabCheckProcRef;

$if modula2 then
from Symbols import fileTypeNode, ioStringTypeNode;
from GenUC import GenCall, GenVar;

$else

from Machine import LONGREALSIZE;
from Symbols import booleanTypeNode, DataTypeSet, longrealTypeNode;
from TypeInfo import LowerBoundOf, UpperBoundOf;

type
     mathLibProcRec = record
			name :	array [0..7] of char;
     	       	    	rt   :  RuntimeProc;
var
    mathLibProcNames	: array [BIPsin..BIParctan], boolean of mathLibProcRec;
$end
type
    DatatypeSet = set of Datatype;
var
    capBlockNumber : integer;


const
    EOFOFFSET = 132;	(* offset of EOF flag in IO buffer *)
    FLAGOFFSET = 16;
    RTERRORASSERT = 'runtime__errorassert';
    RTERRORADDR   = 'runtime__erroraddr';
    ILLEGAL_BLOCK = -1;
    RTCAPITALIZE  = 'runtime__CAPITALIZE';

procedure GenBuiltin(const proc : ProcNode; const params : ExprList);
var
    p, p1, p2, p3, p4, p5, sizeen : ExprNode;
    pt1, pt2, tn, atn : TypeNode;
    size : MemoryOffset;
    numDimensions : integer;
    ptrCheck : PointerKind;
    akind    : ArrayKind;
    dimensionsSize : MemoryOffset;
    nilLabel, lab1 (* ,lab2 *) : LabelNumber;
    maybeNil : boolean;
    procNode : ProcNode;
    numParams,parOffset,i,temp1,temp2,temp3 : integer;
    bip : BuiltinProcType;
    dt1,dt2,dt3 : Datatype;
    
$if pascal then
    p6 : ExprNode;
    numParamWords : integer;

    procedure GenWritef(      p		    : ExprNode; 
			      numParams : cardinal; 
			const name	    : array of char;
     	       	    	const rt            : RuntimeProc);
	var tn : TypeNode;
    begin (* GenWritef *)
	GenExpr(p, EVALGET);	    (* C file *)
	GenOp(PCPAR); I(numParamWords); EndLine;
	inc(numParamWords);
	p := p^.next;
	GenExpr(p, EVALPOINT);      (* Format string *)
	GenOp(PCPAR); I(numParamWords); EndLine;
	inc(numParamWords);
	p := p^.next;
	repeat
	    tn := BaseType(p^.exprType);
	    if tn^.kind in DataTypeSet{DTSTRING, DTARRAY} then
		GenExpr(p, EVALPOINT);
	    else
		GenExpr(p, EVALGET);
	    end;
	    GenOp(PCPAR); I(numParamWords); EndLine;
	    if tn^.kind = DTLONGREAL then
		inc(numParamWords, 2);
	    else
		inc(numParamWords);
	    end;
	    p := p^.next;
	until p = nil;
	GenLibCall(name, nil, 0, numParams, rt);
    end GenWritef;
$end

begin (* GenBuiltin *)
    p1 := nil;
    p2 := nil;
    pt1 := nil;
    pt2 := nil;
    if (params # nil) and (params^.first # nil) then
	p1 := params^.first;
	pt1 := p1^.exprType;
	if p1^.next # nil then
	    p2 := p1^.next;
	    pt2 := p2^.exprType
	end;
    end;

    case proc^.builtin of
    | BIPABS :
	GenExpr(p1,EVALGET);
        Uco1type(Uabs,MapT(pt1));
    
    | BIPASSERT :
	lab1 := NewLabel();
	GenCondition(p1,lab1,NULLLABEL);
     	Uco1int(Umst,RTlevel);
	GenExpr(p2,EVALPOINT);
        Ucomem(Upar,Adt,Pmt,0,0,BYTESPERADDR,0);
	GenLibCall(RTERRORASSERT,nil,0,1,rt__errorassert);
        Ucolab(lab1,0,0);

    | BIPCHR :
        GenChangeType(p1,charTypeNode,EVALGET);
 
    | BIPMIN :
	GenExpr(p1,EVALGET);
	GenExpr(p2,EVALGET);
	Uco1type(Umin,MapT(Compatible(pt1,p1,pt2,p2)));
	
$if modula2 then
    | BIPCAP :
        if capBlockNumber = ILLEGAL_BLOCK then
            capBlockNumber := MipSym.ExternalData(RTCAPITALIZE,NOPCODEBLOCK);
	    Ucosym(Uesym,capBlockNumber,0,Ord(Last(char))-Ord(First(char))+1);
        end;
        Uco4int(Ulda,Smt,capBlockNumber,0,Ord(Last(char))-Ord(First(char))+1,
     	        0);
	GenExpr(p1,EVALGET);
        Uco2typint(Uixa,Ldt,1);
        GenIndirectVar(charTypeNode,EVALGET,0);
    
    | BIPDEC, BIPINC:
	p3 := p2^.next;
(*
	pt1 := BaseType(p3^.exprType);
*)
	pt1 := p3^.exprType;
	GenExpr(p1,EVALPOINT);
     	Uco1type(Udup,Adt);
	GenIndirectVar(pt1,EVALGET,0);
	GenExpr(p2,EVALGET);
	if proc^.builtin = BIPINC then
     	    Uco1type(Uadd,MapT(Compatible(pt1,p1,pt2,p2)));
	else
     	    Uco1type(Usub,MapT(Compatible(pt1,p1,pt2,p2)));
	end;
      	GenIndirectVar(pt1,EVALPUT,0);

    | BIPINCL, BIPEXCL :
        size := RoundUp(SizeOf(p2^.next^.exprType),WORDSIZE);
	GenExpr(p1,EVALPOINT);
     	Uco1type(Udup,Adt);
     	GenIndirectVar(p2^.next^.exprType,EVALGET,0);
	GenExpr(p2,EVALGET);
     	Uco2typint(Usgs,MapT(p2^.exprType),size div BYTESIZE);
	if proc^.builtin = BIPINCL then
	    Uco2typint(Uuni,Sdt,size div BYTESIZE);
	else
	    Uco2typint(Udif,Sdt,size div BYTESIZE);
	end;
     	GenIndirectVar(p2^.next^.exprType,EVALPUT,0);

    | BIPFLOAT, BIPLONGFLOAT :
	GenExpr(p1,EVALGET);
        dt1 := MapT(pt1);
        if proc^.builtin = BIPLONGFLOAT then
            Uco2typtyp(Ucvt,Qdt,dt1);
        else
            Uco2typtyp(Ucvt,Rdt,dt1);
        end;
    
    | BIPHALT :
        Uco1int(Umst,RTlevel);
	GenExpr(p1,EVALGET);
        Ucomem(Upar,Ldt,Pmt,0,0,BYTESPERWORD,0);
	GenLibCall('runtime__term', nil, 0, 1, rt__term);
    
    | BIPMAX :
	GenExpr(p1,EVALGET);
	GenExpr(p2,EVALGET);
        Uco1type(Umax,MapT(Compatible(pt1,p1,pt2,p2)));
$end    
    
    | BIPNEW
$if modula2 then
	, BIPLOCAL
$end
	    :
	(* param list is address, check, proc, dimensions, size, sizes *)
	bip := proc^.builtin;
$if modula2 then
	p3 := p2^.next;
	p4 := p3^.next;
	maybeNil := (bip = BIPNEW) and
	    (p3^.exprConst^.procVal^.builtin # BIPALLOCATE);
$else
	p4 := p2^.next;
	maybeNil := false;
$end
	p5 := p4^.next;
	ptrCheck := VAL(PointerKind, trunc(p2^.exprConst^.cardVal));
	numDimensions := trunc(p4^.exprConst^.cardVal);
	size := trunc(p5^.exprConst^.cardVal);
	akind := ARRAYNOCOUNT;
        temp1 := 0; temp2 := 0; temp3 := 0;

	(* get address of pointer, save it if need be *)
	(* if dynarray, compute size, use address to store sizes *)
	(* pass address and size *)
	(* if Modula-2 pointer, use address to update pointer *)

	if (numDimensions > 0) then
	    (* Dynamic array computations *)
	    atn := p1^.exprType^.dynArrayType;
	    dimensionsSize := SizeOf(atn) - WORDSIZE;
	    akind := atn^.arrayKind;
	    p1^.exprType := addressTypeNode;
	    (* address of pointer variable *)
	    GenExpr(p1, EVALPOINT);
	    (* save variable address *)
     	    if temp1 = 0 then
                temp1 := UcodeTemp(Adt,BYTESPERADDR);
            end;
     	    Ucomem(Ustr,Adt,Mmt,curUcodeBlock,temp1,BYTESPERADDR,0);
	    sizeen := p5^.next;
	    for i := 1 to numDimensions do
		(* get value of expression *)
		GenExpr(sizeen, EVALGET);
		(* Store size in descriptor unless ARRAYNOCOUNT *)
		if atn^.arrayKind # ARRAYNOCOUNT then
		    (* save it *)
                    if temp2 = 0 then
	                temp2 := UcodeTemp(Ldt,BYTESPERWORD);
                    end;
     	            Ucomem(Ustr,Ldt,Mmt,curUcodeBlock,temp2,BYTESPERWORD,0);
		    (* get address of pointer variable *)
	            Ucomem(Ulod,Adt,Mmt,curUcodeBlock,temp1,BYTESPERADDR,0);
     	       	    Uco2typint(Uinc,Adt,i*BYTESPERADDR);
     	            Ucomem(Ulod,Ldt,Mmt,curUcodeBlock,temp2,BYTESPERWORD,0);
		    (* store size in descriptor *)
		    GenIndirectVar(cardIntTypeNode,EVALPUT,0);
		    (* get count *)
     	            Ucomem(Ulod,Ldt,Mmt,curUcodeBlock,temp2,BYTESPERADDR,0);
		end;
		if i > 1 then
		    (* multiply by previous values *)
                    Ucomem(Ulod,Ldt,Mmt,curUcodeBlock,temp3,BYTESPERWORD,0);
     	       	    Uco1type(Umpy,Ldt);
		end;
		(* save away for next time *)
     	        if temp3 = 0 then
	            temp3 := UcodeTemp(Ldt,BYTESPERWORD);
                end;
     	        Ucomem(Ustr,Ldt,Mmt,curUcodeBlock,temp3,BYTESPERWORD,0);
		atn := atn^.elementType;
		sizeen := sizeen^.next;
	    end;
	    (* generate size *)
	    GenConstInteger(size);
	    (* multiply by number of elements *)
            Ucomem(Ulod,Ldt,Mmt,curUcodeBlock,temp3,BYTESPERWORD,0);
     	    Uco1type(Umpy,Ldt);
	    if ptrCheck = PTRMODULA then
		(* add one word to size *)
     	        Uco2typint(Uinc,Ldt,BYTESPERADDR);
	    end;
	    if temp2 = 0 then
                temp2 := UcodeTemp(Ldt,BYTESPERWORD);
            end;
            Ucomem(Ustr,Ldt,Mmt,curUcodeBlock,temp2,BYTESPERWORD,0);
	    if bip = BIPNEW then
		(* start call *)
     	       	Uco1int(Umst,RTlevel);
	    end;
	    (* pass address *)
            Ucomem(Ulod,Adt,Mmt,curUcodeBlock,temp1,BYTESPERADDR,0);
	    if bip = BIPNEW then
     	        Ucomem(Upar,Adt,Pmt,0,0,BYTESPERADDR,0);
	    end;
	    (* pass size *)
            Ucomem(Ulod,Ldt,Mmt,curUcodeBlock,temp2,BYTESPERADDR,0);
	    if bip = BIPNEW then
     	        Ucomem(Upar,Ldt,Pmt,0,BYTESPERWORD,BYTESPERWORD,0);
	    end;
	elsif (ptrCheck = PTRMODULA) then
	    (* Normal pointer computations, save pointer address for later *)
	    GenExpr(p1,EVALPOINT);
     	    if temp1 = 0 then
                temp1 := UcodeTemp(Adt,BYTESPERADDR);
            end;
     	    Ucomem(Ustr,Adt,Mmt,curUcodeBlock,temp1,BYTESPERADDR,0);
	    if bip = BIPNEW then
                Uco1int(Umst,RTlevel);
                Ucomem(Ulod,Adt,Mmt,curUcodeBlock,temp1,BYTESPERADDR,0);
     	        Ucomem(Upar,Adt,Pmt,0,0,BYTESPERADDR,0);
		GenConstInteger(size + UNITSPERWORD);
     	        Ucomem(Upar,Ldt,Pmt,0,BYTESPERWORD,BYTESPERWORD,0);
	    end;
	else
	    (* Normal pointer computations, don't save pointer address *)
	    if bip = BIPNEW then
     	        Uco1int(Umst,RTlevel);
		GenExpr(p1,EVALPOINT);
     	        Ucomem(Upar,Adt,Pmt,0,0,BYTESPERADDR,0);
		GenConstInteger(size);
     	        Ucomem(Upar,Ldt,Pmt,0,BYTESPERWORD,BYTESPERWORD,0);
	    end;
	end;
$if modula2 then
	if bip = BIPNEW then
	    procNode := p3^.exprConst^.procVal;
	    if procNode^.builtin = BIPALLOCATE then
		(* builtin new *)
		if ptrCheck = PTRPASCAL then
		    GenLibCall('NEW', nil, 0, 2, rtNEW);
		elsif ptrCheck = PTRC then
		    GenLibCall('modmalloc', nil, 0, 2, rtmodmalloc);
		else
		    GenLibCall('Storage_ALLOCATE', nil, 0, 2,
     	       	    	      rtStorage_ALLOCATE);
		end;
	    else
		(* user defined ALLOCATE *)
     	        StabCheckProcRef(procNode);
		GenCall (procNode^.procType, 2,
     	       	    procNode^.sym_idn,procNode^.displayLevel,nil);
	    end;
	else (* BIPLOCAL *)
	    if ptrCheck = PTRMODULA then
		GenConstInteger(RoundUp(size + UNITSPERWORD,2*UNITSPERWORD));
	    else
		GenConstInteger(RoundUp(size,2*UNITSPERWORD));
            end;
     	    Uco0(Uaos);
            Ucomem(Ulod,Adt,Mmt,curUcodeBlock,temp1,BYTESPERADDR,0);
            Uco0(Uldsp);
            GenIndirectVar(addressTypeNode,EVALPUT,0);
	end;
$else (* pascal *)
	GenLibCall('NEW', nil, 0, 2, rtNEW);
$end
	if ptrCheck = PTRMODULA then
	    (* Modula-2 checking, store check value and increment address *)
	    if maybeNil then
		nilLabel := NewLabel();
		(* get returned pointer value *)
                Ucomem(Ulod,Adt,Mmt,curUcodeBlock,temp1,BYTESPERADDR,0);
		GenIndirectVar(addressTypeNode,EVALGET,0);
		(* Is it NIL ? *)
     	        Ucoldc(Adt,BYTESPERADDR,0,NOSTRING);
     	       	Uco1type(Uequ,Adt);
     	        Uco1int(Utjp,nilLabel);
	    end;
	    (* store address+wordsize at address *)
	    (* get returned pointer value *)
            Ucomem(Ulod,Adt,Mmt,curUcodeBlock,temp1,BYTESPERADDR,0);
	    GenIndirectVar(addressTypeNode,EVALGET,0); (* for EVALPUT *)
            Ucomem(Ulod,Adt,Mmt,curUcodeBlock,temp1,BYTESPERADDR,0);
	    GenIndirectVar(addressTypeNode,EVALGET,0);
     	    Uco2typint(Uinc,Adt,BYTESPERADDR);
	    (* save incremented address at original address *)
	    GenIndirectVar(addressTypeNode, EVALPUT,0);
	    (* load &pointer *)
            Ucomem(Ulod,Adt,Mmt,curUcodeBlock,temp1,BYTESPERADDR,0);
	    (* get incremented address *)
            Ucomem(Ulod,Adt,Mmt,curUcodeBlock,temp1,BYTESPERADDR,0);
	    GenIndirectVar(addressTypeNode,EVALGET,0); (* gets pointer *)
     	    Uco2typint(Uinc,Adt,BYTESPERADDR);
     	    (* set pointer *)
	    GenIndirectVar(addressTypeNode,EVALPUT,0);

	    if maybeNil then
		if akind # ARRAYNOCOUNT then
		    lab1 := NewLabel();
                    Uco1int(Uujp,lab1);
     	       	    Ucolab(nilLabel,0,0);
		    (* Zero out descriptor *)
                    for i := BYTESPERADDR to dimensionsSize+BYTESPERADDR by 
     	       	    	     BYTESPERWORD do
     	       	        Ucomem(Ulod,Adt,Mmt,curUcodeBlock,temp1,BYTESPERADDR,
     	       	    	       0);
     	       	    	Ucoldc(Ldt,BYTESPERWORD,0,NOSTRING);
     	       	        Uco2int(Uistr,Ldt,i,BYTESPERWORD);
                    end;
		    Ucolab(lab1,0,0);
		else
     	       	    Ucolab(nilLabel,0,0);
		end;
	    end;

	elsif maybeNil and (akind # ARRAYNOCOUNT) then
	    (* Store zeros into dimensions if NIL returned *)
	    nilLabel := NewLabel();
            (* get returned pointer value *)
            Ucomem(Ulod,Adt,Mmt,curUcodeBlock,temp1,BYTESPERADDR,0);
            GenIndirectVar(addressTypeNode,EVALGET,0);
	    (* Is it NIL ? *)
     	    Ucoldc(Adt,BYTESPERADDR,0,NOSTRING);
     	    Uco1type(Uequ,Adt);
     	    Uco1int(Ufjp,nilLabel);

	    (* Zero out descriptor *)
            for i := BYTESPERADDR to dimensionsSize+BYTESPERADDR by 
     	      	     BYTESPERWORD do
     	        Ucomem(Ulod,Adt,Mmt,curUcodeBlock,temp1,BYTESPERADDR,
     	       	    	       0);
     	       	Ucoldc(Ldt,BYTESPERWORD,0,NOSTRING);
     	       	Uco2int(Uistr,Ldt,i,BYTESPERWORD);
            end;
            Ucolab(nilLabel,0,0);
	end;
    
    | BIPDISPOSE :
	(* param list is address, check, proc, dimensions, size *)
	p3 := p2^.next;
$if modula2 then
	procNode := p3^.exprConst^.procVal;
$end
	p4 := p3^.next;
	p5 := p4^.next;
	ptrCheck := VAL(PointerKind, trunc(p2^.exprConst^.cardVal));
	numDimensions := trunc(p4^.exprConst^.cardVal);
	size := trunc(p5^.exprConst^.cardVal);
	(* get address of pointer, save it *)
	(* if dynarray, use address to compute size *)
	(* save size *)
	(* if Modula-2 pointer, use address to update pointer *)
	(* pass address and size *)
	(* address of pointer variable *)
	if (numDimensions > 0) then
	    atn := p1^.exprType^.dynArrayType;
	    p1^.exprType := addressTypeNode;
	end;
	GenExpr(p1,EVALPOINT);
        temp1 := UcodeTemp(Adt,BYTESPERADDR);
        Ucomem(Ustr,Adt,Mmt,curUcodeBlock,temp1,BYTESPERADDR,0);
	if p1^.doCheck and
	    (ptrCheck in PointerKindSet{PTRMODULA, PTRPASCAL, PTRNILCHECK})
	then
	    (* make sure pointer is valid before disposing it *)
                lab1 := NewLabel();
                Ucomem(Ulod,Adt,Mmt,curUcodeBlock,temp1,BYTESPERADDR,0);
     	        GenIndirectVar(addressTypeNode,EVALGET,0);
		if ptrCheck = PTRMODULA then
                    Uco1type(Udup,Adt);
	            Uco2int(Uilod,Adt,-BYTESPERADDR,BYTESPERADDR);
                    Uco1type(Uequ,Adt);
     	            Uco1int(Utjp,lab1);
		elsif ptrCheck = PTRPASCAL then
		    assert(false,"We don't do pascal pointer checks");
		else
		    Ucoldc(Adt,BYTESPERADDR,0,NOSTRING);
     	            Uco1type(Uneq,Adt);
     	       	    Uco1int(Utjp,lab1);
		end;
     	       	Uco1int(Umst,RTlevel);
                Ucomem(Ulod,Adt,Mmt,curUcodeBlock,temp1,BYTESPERADDR,0);
     	        GenIndirectVar(addressTypeNode,EVALGET,0);
     	       	Ucomem(Upar,Adt,Pmt,0,0,BYTESPERADDR,0);
                GenLibCall(RTERRORADDR,nil,0,1,rt__erroraddr);
     	        Ucolab(lab1,0,0);
	end;
	if ptrCheck = PTRMODULA then
	    (* get address *)
	    Ucomem(Ulod,Adt,Mmt,curUcodeBlock,temp1,BYTESPERADDR,0);
	    Ucomem(Ulod,Adt,Mmt,curUcodeBlock,temp1,BYTESPERADDR,0);	
            GenIndirectVar(addressTypeNode,EVALGET,0);
            (* decrement pointer to original beginning of area *)
     	    Uco2typint(Udec,Adt,BYTESPERADDR);
            GenIndirectVar(addressTypeNode,EVALPUT,0);
	end;
	(* call dispose routine *)
        Uco1int(Umst,RTlevel);
	(* pass address of pointer variable *)
	Ucomem(Ulod,Adt,Mmt,curUcodeBlock,temp1,BYTESPERADDR,0);
	Ucomem(Upar,Adt,Pmt,0,0,BYTESPERADDR,0);
	(* pass size *)
	sizeen := p5^.next;
	for i := 1 to numDimensions do
	    (* Get number of elements in this dimension *)
	    if atn^.arrayKind = ARRAYNOCOUNT then
		GenExpr(sizeen, EVALGET);
		sizeen := sizeen^.next;
	    else
		(* get address of pointer variable *)
	        Ucomem(Ulod,Adt,Mmt,curUcodeBlock,temp1,BYTESPERADDR,0);
     	        Uco2typint(Uinc,Adt,i*BYTESPERWORD);
		GenIndirectVar(cardIntTypeNode,EVALGET,0);
	    end;
	    if i > 1 then
		(* multiply by previous values *)
     	       	Uco1type(Umpy,Ldt);
	    end;
	    atn := atn^.elementType;
	end;
	(* generate size *)
	GenConstInteger(size);
	if numDimensions > 0 then
	    (* multiply by number of elements *)
            Uco1type(Umpy,Ldt);
	end;
	if ptrCheck = PTRMODULA then
	    (* add one word to size *)
            Uco2typint(Uinc,Adt,BYTESPERWORD);
	end;
        Ucomem(Upar,Ldt,Pmt,0,BYTESPERWORD,BYTESPERWORD,0);
$if modula2 then
	if procNode^.builtin = BIPDEALLOCATE then
	    (* builtin dispose *)
	    if ptrCheck = PTRPASCAL then
		GenLibCall('DISPOSE', nil, 0, 2, rtDISPOSE);
	    elsif ptrCheck = PTRC then
		GenLibCall('free', nil, 0, 2, rtfree);
	    else
		GenLibCall('Storage_DEALLOCATE', nil, 0, 2,
     	       	    	  rtStorage_DEALLOCATE);
	    end;
	else
	    (* user defined dispose *)
     	    StabCheckProcRef(procNode);
	    GenCall (procNode^.procType,2,procNode^.sym_idn,
     	       	     procNode^.displayLevel,nil);
	end;
$else (* pascal *)
	if p3^.exprConst^.cardVal = 1.0 then
	    (* Close any open files being disposed *)
	    GenLibCall('DFDISPOSE', nil, 0, 2, rtDFDISPOSE);
	else
	    GenLibCall('DISPOSE', nil, 0, 2, rtDISPOSE);
	end;
$end

$if modula2 then
    | BIPALLOCATE, BIPDEALLOCATE :
        Uco1int(Umst,RTlevel);
	GenExpr(p1,EVALPOINT);
	Ucomem(Upar,Adt,Pmt,0,0,BYTESPERADDR,0);
	GenExpr(p2,EVALGET);
        Ucomem(Upar,Ldt,Pmt,0,BYTESPERWORD,BYTESPERWORD,0);
	if proc^.builtin = BIPALLOCATE then
	    GenLibCall('MEMORY_ALLOCATE', nil, 0, 2, rtMEMORY_ALLOCATE);
	else
	    GenLibCall('MEMORY_DEALLOCATE', nil, 0, 2, rtMEMORY_DEALLOCATE);
	end;
$end (* modula2 *)
    
    | BIPODD :
	GenExpr(p1,EVALGET);
     	Uco1type(Uodd,MapT(pt1));
    
    | BIPORD :
	GenExpr(p1,EVALGET);
        Uco2typtyp(Ucvt,Ldt,MapT(pt1));
    
    | BIPTRUNC :
	GenExpr(p1,EVALGET);
     	dt1 := MapT(pt1);
     	assert (dt1 in DatatypeSet {Rdt,Qdt},'bad type in BIPTRUNC');
        Uco2typtyp(Ucvt,Jdt,dt1);

$if modula2 then
    | BIPVAL :
        GenChangeType(p2,pt1,EVALGET);
    
    | BIPADR :
	GenExpr(p1,EVALPOINT);
    
    | BIPWRITEF, BIPSWRITEF :
        Uco1int(Umst,RTlevel);
	if proc^.builtin = BIPWRITEF then
	    GenExpr(p1,EVALGET);
	else
	    GenExpr(p1, EVALPOINT);
	end;
        parOffset := 0;
        numParams := 0;
     	Ucomem(Upar,Adt,Pmt,0,parOffset,BYTESPERADDR,0);
        inc(parOffset,BYTESPERWORD);
        inc(numParams);
	GenExpr(p2,EVALPOINT);
     	Ucomem(Upar,Adt,Pmt,0,parOffset,BYTESPERADDR,0);
        inc(parOffset,BYTESPERWORD);
        inc(numParams);
	p := p2^.next;
	while p # nil do
	    tn := BaseType(p^.exprType);
	    case tn^.kind of
	    | DTARRAY,DTSTRING :
		p^.exprType := addressTypeNode;
		GenExpr(p,EVALPOINT);
     	        Ucomem(Upar,Adt,Pmt,0,parOffset,BYTESPERADDR,0);
	        inc(parOffset,BYTESPERWORD);
	        inc(numParams);
	    | DTBOOLEAN, DTENUMERATION :
     	        Uco1int(Umst,RTlevel);
		GenExpr(p, EVALGET);
     	        Ucomem(Upar,Ldt,Pmt,0,0,BYTESPERWORD,0);
		GenVar(tn^.nameTable, EVALPOINT);
     	        Ucomem(Upar,Adt,Pmt,0,BYTESPERWORD,BYTESPERADDR,0);
		GenLibCall('NAM', addressTypeNode, WORDSIZE, 2, rtNAM);
     	        Ucomem(Upar,Adt,Pmt,0,parOffset,BYTESPERADDR,0);
	        inc(parOffset,BYTESPERWORD);
	        inc(numParams);
	    | DTREAL,DTLONGREAL :
		(* make float be double *)
		GenExpr(p,EVALGET);
     	        if tn^.kind = DTREAL then
     	            Uco2typtyp(Ucvt,Qdt,Rdt);
                end;
     	        parOffset := RoundUp(parOffset,2*BYTESPERWORD);
     	        Ucomem(Upar,Qdt,Pmt,0,parOffset,2*BYTESPERWORD,0);
     	        inc(parOffset,2*BYTESPERWORD);
	        inc(numParams);
	    | else
		GenExpr(p,EVALGET);
     	        Ucomem(Upar,MapT(p^.exprType),Pmt,0,parOffset,
     	       	       (SizeOf(p^.exprType)+BYTESIZE-1) div BYTESIZE,0);
	        inc(parOffset,BYTESPERWORD);
     	        inc(numParams);
	    end (* case tn^.kind *);
	    p := p^.next;
	end;
	if proc^.builtin = BIPWRITEF then
	    GenLibCall('fprintf', nil, 0, numParams, rtfprintf);
	else
	    GenLibCall('sprintf', nil, 0, numParams, rtsprintf);
	end;
    
    | BIPREADF, BIPSREADF :
        Uco1int(Umst,RTlevel);
	if proc^.builtin = BIPREADF then
	    GenExpr(p1, EVALGET);
	else
	    GenExpr(p1, EVALPOINT);
	end;
	Ucomem(Upar,Adt,Pmt,0,0,BYTESPERADDR,0);
	GenExpr(p2,EVALPOINT);
	Ucomem(Upar,Adt,Pmt,0,BYTESPERWORD,BYTESPERADDR,0);
        numParams := 2;
	p := p2^.next;
	while p # nil do
	    if p^.exprType = ioStringTypeNode then
		p^.exprType := addressTypeNode;
		GenExpr(p, EVALPOINT);
		p^.exprType := ioStringTypeNode;
	    else
		GenExpr(p,EVALPOINT);
	    end;
	    Ucomem(Upar,Adt,Pmt,0,numParams*BYTESPERWORD,BYTESPERADDR,0);
	    inc(numParams);
	    p := p^.next;
	end;
	if proc^.builtin = BIPREADF then
	    GenLibCall('fscanf', integerTypeNode, WORDSIZE, numParams,
     	       	      rtfscanf);
	else
	    GenLibCall('sscanf', integerTypeNode, WORDSIZE, numParams,
     	       	      rtsscanf);
	end;
    
    | BIPWRITES :
        Uco1int(Umst,RTlevel);
	GenExpr(p1, EVALGET);
     	Ucomem(Upar,Adt,Pmt,0,BYTESPERWORD,BYTESPERADDR,0);
	GenExpr(p2, EVALPOINT);
     	Ucomem(Upar,Adt,Pmt,0,0,BYTESPERADDR,0);
	GenLibCall('fputs', nil, 0, 2, rtfputs);

    | BIPWRITEB :
	p3 := p2^.next;
        Uco1int(Umst,RTlevel);
	GenExpr(p1,EVALGET);
        Ucomem(Upar,Adt,Pmt,0,3*BYTESPERWORD,BYTESPERADDR,0);
	GenExpr(p2,EVALPOINT);
        Ucomem(Upar,Adt,Pmt,0,0,BYTESPERADDR,0);
	GenConstInteger(1);
        Ucomem(Upar,Ldt,Pmt,0,BYTESPERWORD,BYTESPERWORD,0);
	GenExpr(p3,EVALGET);
        Ucomem(Upar,Ldt,Pmt,0,2*BYTESPERWORD,BYTESPERWORD,0);
	GenLibCall('fwrite', nil, 0, 4, rtfwrite);

    | BIPREADB :
	p3 := p2^.next;
        Uco1int(Umst,RTlevel);
	GenExpr(p1,EVALGET);
        Ucomem(Upar,Adt,Pmt,0,3*BYTESPERWORD,BYTESPERADDR,0);
	GenExpr(p2,EVALPOINT);
        Ucomem(Upar,Adt,Pmt,0,0,BYTESPERADDR,0);
	GenConstInteger(1);
        Ucomem(Upar,Ldt,Pmt,0,BYTESPERWORD,BYTESPERWORD,0);
	GenExpr(p3,EVALGET);
        Ucomem(Upar,Ldt,Pmt,0,2*BYTESPERWORD,BYTESPERWORD,0);
	GenLibCall('fread', integerTypeNode, WORDSIZE, 4, rtfread);
    
    | BIPWRITEC :
        Uco1int(Umst,RTlevel);
	GenExpr(p1,EVALGET);
     	Ucomem(Upar,Adt,Pmt,0,BYTESPERWORD,BYTESPERADDR,0);
	GenExpr(p2,EVALGET);
        Ucomem(Upar,Ldt,Pmt,0,0,1,0);
	GenLibCall('fputc', nil, 0, 2, rtfputc);
    
    | BIPREADC :
        Uco1int(Umst,RTlevel);
	GenExpr(p1,EVALGET);
     	Ucomem(Upar,Adt,Pmt,0,0,BYTESPERADDR,0);
	GenLibCall('fgetc', charTypeNode, BYTESIZE, 1, rtfgetc);
        GenExpr(p2,EVALPOINT);
     	Uco2typtyp(Uswp,Adt,Adt);
        GenIndirectVar(charTypeNode,EVALPUT,0);
	GenExpr(p1,EVALGET);
        Uco2typint(Uinc,Adt,FLAGOFFSET);
        Uco2int(Uilod,Jdt,0,2);	 (* load half word *)
     	Ucoldc(Jdt,2,20b,NOSTRING);
     	Uco1type(Uand,Jdt);
        Uco1type(Uneg,Jdt);
    
    | BIPREADS :
        Uco1int(Umst,RTlevel);
	GenExpr(p1, EVALGET);
	Ucomem(Upar,Adt,Pmt,0,2*BYTESPERWORD,BYTESPERADDR,0);
	GenExpr(p2, EVALPOINT);
	Ucomem(Upar,Adt,Pmt,0,0,BYTESPERADDR,0);
	p3 := p2^.next;
	GenExpr(p3, EVALGET);
	Ucomem(Upar,Ldt,Pmt,0,BYTESPERWORD,BYTESPERWORD,0);
	GenLibCall('fgets', integerTypeNode, WORDSIZE, 3, rtfgets);
	(* Result is non-zero if read went okay *)
	GenConstInteger(0);
        Uco1type(Uneq,Jdt);

    | BIPOPENF :
	Uco1int(Umst,RTlevel);
	GenExpr(p1,EVALPOINT);
     	Ucomem(Upar,Adt,Pmt,0,0,BYTESPERADDR,0);
	GenExpr(p2,EVALPOINT);
     	Ucomem(Upar,Adt,Pmt,0,BYTESPERWORD,BYTESPERADDR,0);
	GenLibCall('fopen', fileTypeNode, WORDSIZE, 2, rtfopen);
    
    | BIPCLOSEF :
	Uco1int(Umst,RTlevel);
	GenExpr(p1,EVALGET);
     	Ucomem(Upar,Adt,Pmt,0,0,BYTESPERADDR,0);
	GenLibCall('fclose', nil, 0, 1, rtfclose);
    
    | BIPNEWPROCESS :
	p3 := p2^.next;
	p4 := p3^.next;
        Uco1int(Umst,RTlevel);
	GenExpr(p1,EVALGET);
        Ucomem(Upar,MapT(pt1),Pmt,0,0,BYTESPERWORD,0);
	GenExpr(p2,EVALGET);
        Ucomem(Upar,MapT(pt2),Pmt,0,BYTESPERWORD,BYTESPERWORD,0);
	GenExpr(p3,EVALGET);
        Ucomem(Upar,MapT(p3^.exprType),Pmt,0,2*BYTESPERWORD,BYTESPERWORD,0);
	GenExpr(p4,EVALPOINT);
        Ucomem(Upar,Adt,Pmt,0,3*BYTESPERWORD,BYTESPERADDR,0);
	GenLibCall('SYSTEM_newprocess', nil, 0, 4, rtSYSTEM_newprocess);
    
    | BIPTRANSFER :
        Uco1int(Umst,RTlevel);
	GenExpr(p1,EVALPOINT);
        Ucomem(Upar,Adt,Pmt,0,0,BYTESPERADDR,0);
	GenExpr(p2,EVALPOINT);
        Ucomem(Upar,Adt,Pmt,0,BYTESPERWORD,BYTESPERADDR,0);
	GenLibCall('SYSTEM_transfer', nil, 0, 2, rtSYSTEM_transfer);
    
    | BIPCPUTIME :
        Uco1int(Umst,RTlevel);
	GenLibCall('SYSTEM_cputime', integerTypeNode, WORDSIZE, 0,
     	          rtSYSTEM_cputime);
    
    | BIPBITNOT :
	GenExpr(p1,EVALGET);
        Uco1type(Unot,Ldt);
    
    | BIPBITAND :
	GenExpr(p1,EVALGET);
	GenExpr(p2,EVALGET);
        Uco1type(Uand,Ldt);
    
    | BIPBITOR :
	GenExpr(p1,EVALGET);
	GenExpr(p2,EVALGET);
	Uco1type(Uior,Ldt);
    
    | BIPBITXOR :
	GenExpr(p1,EVALGET);
	GenExpr(p2,EVALGET);
	Uco1type(Uxor,Ldt);
    
    | BIPBITSHIFTLEFT :
	GenExpr(p1,EVALGET);
	GenExpr(p2,EVALGET);
        Uco1type(Ushl,Ldt);
    
    | BIPBITSHIFTRIGHT :
	GenExpr(p1,EVALGET);
	GenExpr(p2,EVALGET);
	Uco1type(Ushr,Ldt);
    
    | BIPBITEXTRACT :
	p3 := p2^.next;
        (* end of prologue *)
	GenExpr(p1,EVALGET);
	GenExpr(p2,EVALGET);
        Ucoldc(Ldt,1,32, NOSTRING);
	GenExpr(p3,EVALGET);
        dt1 := MapT(p3^.exprType);
        temp1 := UcodeTemp(dt1,BYTESPERWORD);
        Ucomem(Ustr,dt1,Mmt,curUcodeBlock,temp1,BYTESPERWORD,0);
        Ucomem(Ulod,dt1,Mmt,curUcodeBlock,temp1,BYTESPERWORD,0);
        Uco1type(Usub,Ldt);
        Uco2typtyp(Uswp,Ldt,Ldt);
        Uco1type(Usub,Ldt);
        Uco1type(Ushl,Ldt);
        Ucoldc(Ldt,1,32, NOSTRING);
        Ucomem(Ulod,dt1,Mmt,curUcodeBlock,temp1,BYTESPERWORD,0);
        Uco1type(Usub,Ldt);
        Uco1type(Ushr,Ldt);		 (* leave at lsb *)

    | BIPBITINSERT :
        (* Create three temporaries *)
	p3 := p2^.next;
	p4 := p3^.next;
	GenExpr(p1,EVALGET);
        Ucoldc(Ldt,1,32, NOSTRING);
	GenExpr(p2,EVALGET);
        dt2 := MapT(pt2);
        temp2 := UcodeTemp(dt2,BYTESPERWORD);
        Ucomem(Ustr,dt2,Mmt,curUcodeBlock,temp2,BYTESPERWORD,0);
	GenExpr(p3,EVALGET);
        dt1 := MapT(p3^.exprType);
        temp1 := UcodeTemp(dt1,BYTESPERWORD);
        Ucomem(Ustr,dt1,Mmt,curUcodeBlock,temp1,BYTESPERWORD,0);
        Ucomem(Ulod,dt1,Mmt,curUcodeBlock,temp1,BYTESPERWORD,0);
        Uco1type(Usub,Ldt);
        Uco1type(Ushl,Ldt);
        Ucoldc(Ldt,1,32, NOSTRING);
        Ucomem(Ulod,dt1,Mmt,curUcodeBlock,temp1,BYTESPERWORD,0);
        Uco1type(Usub,Ldt);
        Uco1type(Ushr,Ldt);
        Ucomem(Ulod,dt2,Mmt,curUcodeBlock,temp2,BYTESPERWORD,0);
        Uco1type(Ushl,Ldt);
	GenExpr(p4,EVALGET);
        dt3 := MapT(p4^.exprType);
        temp3 := UcodeTemp(dt3,BYTESPERWORD);
        Ucomem(Ustr,dt3,Mmt,curUcodeBlock,temp3,BYTESPERWORD,0);
        Ucomem(Ulod,dt3,Mmt,curUcodeBlock,temp3,BYTESPERWORD,0);
        Ucoldc(Ldt,1,32, NOSTRING);
        Ucomem(Ulod,dt1,Mmt,curUcodeBlock,temp1,BYTESPERWORD,0);
        Uco1type(Usub,Ldt);
        Ucomem(Ulod,dt2,Mmt,curUcodeBlock,temp2,BYTESPERWORD,0);
        Uco1type(Usub,Ldt);
        Uco1type(Ushl,Ldt);
        Ucoldc(Ldt,1,32, NOSTRING);
        Ucomem(Ulod,dt1,Mmt,curUcodeBlock,temp1,BYTESPERWORD,0);
        Uco1type(Usub,Ldt);
        Uco1type(Ushr,Ldt);
        Ucomem(Ulod,dt2,Mmt,curUcodeBlock,temp2,BYTESPERWORD,0);
        Uco1type(Ushl,Ldt);
        Uco1type(Uxor,Ldt);
        Ucomem(Ulod,dt3,Mmt,curUcodeBlock,temp3,BYTESPERWORD,0);
        Uco1type(Uxor,Ldt);
    
$else (* pascal *)
    | BIPwritec :
	p3 := p2^.next;
	GenOp(PCMST); I(3);
	EndLine;
	GenExpr(p1, VAL(EvalMode, trunc(p2^.exprConst^.cardVal)));
	GenOp(PCPAR); I(0); EndLine;
	GenExpr(p3, EVALGET);
	GenOp(PCPAR); I(1); EndLine;
	GenExpr(p3^.next, EVALGET);
	GenOp(PCPAR); I(2); EndLine;
	GenLibCall('WRITEC', nil, 0, 3, rtWRITEC);

    | BIPfputc :
	GenOp(PCMST); I(2);
	EndLine;
	GenExpr(p1, EVALGET);
	GenOp(PCPAR); I(0); EndLine;
	GenExpr(p2, EVALGET);
	GenOp(PCPAR); I(1); EndLine;
	GenLibCall('fputc', nil, 0, 2, rtfputc);

    | BIPwritef :
	numParamWords := 3;
	p3 := p2^.next;
	p4 := p3^.next;
	p := p4^.next;
	repeat
	    if p^.exprType^.kind = DTLONGREAL then
		inc(numParamWords, 2);
	    else
		inc(numParamWords);
	    end;
	    p := p^.next;
	until p = nil;
	GenOp(PCMST); I(numParamWords);
	EndLine;
	GenExpr(p1, VAL(EvalMode, trunc(p2^.exprConst^.cardVal)));
	GenOp(PCPAR); I(0); EndLine;
	GenWritef(p2^.next, 1, 'WRITEF',rtWRITEF);

    | BIPfprintf :
	numParamWords := 2;
	p := p2^.next;
	repeat
	    if p^.exprType^.kind = DTLONGREAL then
		inc(numParamWords, 2);
	    else
		inc(numParamWords);
	    end;
	    p := p^.next;
	until p = nil;
	GenOp(PCMST); I(numParamWords);
	EndLine;
	GenWritef(p1, 0, 'fprintf',rtfprintf);

    | BIPwriteln :
	GenOp(PCMST); I(1);
	EndLine;
	GenExpr(p1, VAL(EvalMode, trunc(p2^.exprConst^.cardVal)));
	GenOp(PCPAR); I(0); EndLine;
	GenLibCall('WRITLN', nil, 0, 1, rtWRITLN);

    | BIPwrites :
	p3 := p2^.next;
	p4 := p3^.next;
	p5 := p4^.next;
	GenOp(PCMST); I(5);
	EndLine;
	GenExpr(p1, VAL(EvalMode, trunc(p2^.exprConst^.cardVal)));
	GenOp(PCPAR); I(0); EndLine;
	GenExpr(p3, EVALPOINT);		(* Address of string *)
	GenOp(PCPAR); I(1); EndLine;
	GenExpr(p4, EVALGET);		(* Length of string *)
	GenOp(PCPAR); I(2); EndLine;
	GenExpr(p5, EVALGET);		(* Size of data (1 byte) *)
	GenOp(PCPAR); I(3); EndLine;
	GenExpr(p5^.next, EVALGET);     (* Unix file *)
	GenOp(PCPAR); I(4); EndLine;
	GenLibCall('WRITES', nil, 0, 5, rtWRITES);

    | BIPfwrite :
	p3 := p2^.next;
	GenOp(PCMST); I(4);
	EndLine;
	GenExpr(p1, EVALPOINT);		(* Address of string *)
	GenOp(PCPAR); I(0); EndLine;
	GenExpr(p2, EVALGET);		(* Length of string *)
	GenOp(PCPAR); I(1); EndLine;
	GenExpr(p3, EVALGET);		(* Size of data (1 byte) *)
	GenOp(PCPAR); I(2); EndLine;
	GenExpr(p3^.next, EVALGET);     (* Unix file *)
	GenOp(PCPAR); I(3); EndLine;
	GenLibCall('fwrite', nil, 0, 4, rtfwrite);

    | BIPmax :
	GenOp(PCMST); I(3);
	EndLine;
	GenExpr(p1, EVALGET);
	GenOp(PCPAR); I(0); EndLine;
	GenExpr(p2, EVALGET);
	GenOp(PCPAR); I(1); EndLine;
	GenExpr(p2^.next, EVALGET);
	GenOp(PCPAR); I(2); EndLine;
	GenLibCall('MAX', integerTypeNode, WORDSIZE, 3, rtMAX);

    | BIPnam :
	GenOp(PCMST); I(2);
	EndLine;
	GenExpr(p1, EVALGET);
	GenOp(PCPAR); I(0); EndLine;
	GenExpr(p2, EVALPOINT);
	GenOp(PCPAR); I(1); EndLine;
	GenLibCall('NAM', addressTypeNode, WORDSIZE, 2, rtNAM);

    | BIPreadln :
	GenOp(PCMST); I(1);
	EndLine;
	GenExpr(p1, VAL(EvalMode, trunc(p2^.exprConst^.cardVal)));
	GenOp(PCPAR); I(0); EndLine;
	GenLibCall('READLN', nil, 0, 1, rtREADLN);

    | BIPfnil :
	GenOp(PCMST); I(1);
	EndLine;
	GenExpr(p1, VAL(EvalMode, trunc(p2^.exprConst^.cardVal)));
	GenOp(PCPAR); I(0); EndLine;
	GenLibCall('FNIL', addressTypeNode, WORDSIZE, 1, rtFNIL);

    | BIPread4 :
	GenOp(PCMST); I(1);
	EndLine;
	GenExpr(p1, VAL(EvalMode, trunc(p2^.exprConst^.cardVal)));
	GenOp(PCPAR); I(0); EndLine;
	GenLibCall('READ4', integerTypeNode, WORDSIZE, 1, rtREAD4);

    | BIPread8 :
	GenOp(PCMST); I(1);
	EndLine;
	GenExpr(p1, VAL(EvalMode, trunc(p2^.exprConst^.cardVal)));
	GenOp(PCPAR); I(0); EndLine;
	GenLibCall('READ8', longrealTypeNode, LONGREALSIZE, 1, rtREAD8);

    | BIPreade :
	GenOp(PCMST); I(2);
	EndLine;
	GenExpr(p1, VAL(EvalMode, trunc(p2^.exprConst^.cardVal)));
	GenOp(PCPAR); I(0); EndLine;
	GenExpr(p2^.next, EVALPOINT);
	GenOp(PCPAR); I(1); EndLine;
	GenLibCall('READE', integerTypeNode, WORDSIZE, 2, rtREADE);

    | BIPreadc :
	GenOp(PCMST); I(1);
	EndLine;
	GenExpr(p1, VAL(EvalMode, trunc(p2^.exprConst^.cardVal)));
	GenOp(PCPAR); I(0); EndLine;
	GenLibCall('READC', charTypeNode, BYTESIZE, 1, rtREADC);

    | BIPget :
	GenOp(PCMST); I(1);
	EndLine;
	GenExpr(p1, VAL(EvalMode, trunc(p2^.exprConst^.cardVal)));
	GenOp(PCPAR); I(0); EndLine;
	GenLibCall('GET', nil, 0, 1, rtGET);
	
    | BIPput :
	GenOp(PCMST); I(1);
	Endline;
	GenExpr(p1, VAL(EvalMode, trunc(p2^.exprConst^.cardVal)));
	GenOp(PCPAR); I(0); EndLine;
	GenLibCall('PUT', nil, 0, 1, rtPUT);
	
    | BIPunit :
	GenOp(PCMST); I(1);
	Endline;
	GenExpr(p1, VAL(EvalMode, trunc(p2^.exprConst^.cardVal)));
	GenOp(PCPAR); I(0); EndLine;
        GenLibCall('UNIT', addressTypeNode, WORDSIZE, 1, rtUNIT);

    | BIPpage :
	GenOp(PCMST); I(1);
	Endline;  (* for PAGE *)
	GenOp(PCMST); I(1);
	Endline;  (* for UNIT *)
	GenExpr(p1, EVALPOINT);
	GenOp(PCPAR); I(0); EndLine;
	GenLibCall('UNIT', addressTypeNode, WORDSIZE, 1, rtUNIT);
	GenOp(PCPAR); I(0); EndLine;
	GenLibCall('PAGE', nil, 0, 1, rtPAGE);
	
    | BIPflush :
	if p1 = nil then
	    GenOp(PCMST); I(0);
	    Endline;
	    GenLibCall('PFLUSH', nil, 0, 0, rtPFLUSH);
	else
	    GenOp(PCMST); I(1);
	    Endline;
	    GenExpr(p1, EVALPOINT);
	    GenOp(PCPAR); I(0); EndLine;
	    GenLibCall('FLUSH', nil, 0, 1, rtFLUSH);
	end;

    | BIPeof :
	GenOp(PCMST); I(1);
	Endline;
	GenExpr(p1, EVALPOINT);
	GenOp(PCPAR); I(0); EndLine;
	GenLibCall('TEOF', booleanTypeNode, BYTESIZE, 1, rtTEOF);

    | BIPeoln :
	GenOp(PCMST); I(1);
	Endline;
	GenExpr(p1, EVALPOINT);
	GenOp(PCPAR); I(0); EndLine;
	GenLibCall('TEOLN', booleanTypeNode, BYTESIZE, 1, rtTEOLN);

    | BIPlinelimit :
	GenOp(PCMST); I(2);
	Endline;
	GenExpr(p1, EVALPOINT);
	GenOp(PCPAR); I(0); EndLine;
	GenExpr(p2, EVALGET);
	GenOp(PCPAR); I(1); EndLine;
	GenLibCall('LLIMIT', nil, 0, 2, rtLLIMIT);

    | BIPstlimit :
	GenOp(PCMST); I(1);
	Endline;
        GenExpr(p1, EVALGET);
	GenOp(PCPAR); I(0); EndLine;
        GenLibCall('STLIM', nil, 0, 1, rtSTLIM);

    | BIPremove :
	GenOp(PCMST); I(2);
	Endline;
	GenExpr(p1, EVALPOINT);
	GenOp(PCPAR); I(0); EndLine;
	GenExpr(p2, EVALGET);
	GenOp(PCPAR); I(1); EndLine;
	GenLibCall('REMOVE', nil, 0, 2, rtREMOVE);
	
    | BIPreset, BIPrewrite :
	p3 := p2^.next;
	GenOp(PCMST); I(4);
	Endline;
	GenExpr(p1, EVALPOINT);
	GenOp(PCPAR); I(0); EndLine;
	if pt2^.kind = DTINTEGER then (* reset(f) case *)
	    GenConstInteger(0);
	else
	    GenExpr(p2, EVALPOINT);
	end;
	GenOp(PCPAR); I(1); EndLine;
	GenExpr(p3, EVALGET);
	GenOp(PCPAR); I(2); EndLine;
	GenExpr(p3^.next, EVALGET);
	GenOp(PCPAR); I(3); EndLine;
	if proc^.builtin = BIPreset then
	    GenLibCall('RESET', nil, 0, 4, rtRESET);
	else
	    GenLibCall('REWRITE', nil, 0, 4, rtREWRITE);
	end;

    | BIPpack,
      BIPunpack :
	p3 := p2^.next;
	p4 := p3^.next;
	p5 := p4^.next;
	p6 := p5^.next;
	GenOp(PCMST); I(7);
	Endline;
	GenExpr(p1, EVALGET);
	GenOp(PCPAR); I(0); EndLine;
	GenExpr(p2, EVALPOINT);
	GenOp(PCPAR); I(1); EndLine;
	GenExpr(p3, EVALPOINT);
	GenOp(PCPAR); I(2); EndLine;
	GenExpr(p4, EVALGET);
	GenOp(PCPAR); I(3); EndLine;
	GenExpr(p5, EVALGET);
	GenOp(PCPAR); I(4); EndLine;
	GenExpr(p6, EVALGET);
	GenOp(PCPAR); I(5); EndLine;
	GenExpr(p6^.next, EVALGET);
	GenOp(PCPAR); I(6); EndLine;
	if proc^.builtin = BIPpack then
	    GenLibCall('PACK', nil, 0, 7, rtPACK);
	else
	    GenLibCall('UNPACK', nil, 0, 7, rtUNPACK);
	end;
	
    | BIPargc :
	GenExpr(p1, EVALGET);
	
    | BIPargv :
	GenOp(PCMST); I(3);
	Endline;
	GenExpr(p1, EVALGET);
	GenOp(PCPAR); I(0); EndLine;
	GenExpr(p2, EVALPOINT);
	GenOp(PCPAR); I(1); EndLine;
	GenExpr(p2^.next, EVALGET);
	GenOp(PCPAR); I(2); EndLine;
	GenLibCall('ARGV', nil, 0, 3, rtARGV);

    | BIPsqr :
	GenExpr(p1, EVALGET);
	(* Duplicate top of stack *)
	GenOp(PCSAV); I(0); X; C('c'); EndLine;
	GenOp(PCUSE); I(0); X; C('m'); EndLine;
	GenOpT(PCMUP, pt1); X; I(SizeOf(pt1)); EndLine;

    | BIPsqrt, BIPsin, BIPcos, BIPexp, BIPln, BIParctan :
	GenOp(PCMST); I(2);
	Endline;
	GenExpr(p1,EVALGET);
	GenOp(PCPAR); I(0); EndLine;
	GenLibCall(mathLibProc[proc^.builtin, p1^.doCheck].name, 
	    longrealTypeNode, LONGREALSIZE, 2,
     	  mathLibProc[proc^.builtin,p1^.doCheck].rt);

    | BIPlongfloat :
	GenExpr(p1,EVALGET);
	GenOpTL(PCFLT,longrealTypeNode);
    
    | BIPround :
	GenExpr(p1, EVALGET);
	if pt1^.kind = DTLONGREAL then
	    GenOpTL(PCRND, pt1);
	(* else DTINTEGER, no need to round *)
	end;

    | BIPexpo :
	GenOp(PCMST); I(2);
	Endline;
	GenExpr(p1,EVALGET);
	GenOp(PCPAR); I(0); EndLine;
	GenLibCall('EXPO', integerTypeNode, WORDSIZE, 2, rtEXPO);

    | BIPsucc, BIPpred :
	if p1^.doCheck then
	    GenOp(PCMST); I(3);
	    Endline;
	    GenExpr(p1, EVALGET);
	    GenOp(PCPAR); I(0); EndLine;
	    GenConstInteger(trunc(LowerBoundOf(pt1)));
	    GenOp(PCPAR); I(1); EndLine;
	    GenConstInteger(trunc(UpperBoundOf(pt1)));
	    GenOp(PCPAR); I(2); EndLine;
	    if proc^.builtin = BIPsucc then
		GenLibCall('SUCC', pt1, SizeOf(pt1), 3, rtSUCC);
	    else
		GenLibCall('PRED', pt1, SizeOf(pt1), 3, rtPRED);
	    end;
	else
	    GenExpr(p1, EVALGET);
	    GenConstInteger(1);
	    if proc^.builtin = BIPsucc then
		GenOpT(PCADD, pt1); 
	    else
		GenOpT(PCSUB, pt1);
	    end;
	    X; I(SizeOf(pt1)); EndLine;
	end;

    | BIPcard :
	GenOp(PCMST); I(2);
	Endline;
	GenExpr(p1, EVALPOINT);
	GenOp(PCPAR); I(0); EndLine;
	GenExpr(p2, EVALGET);
	GenOp(PCPAR); I(1); EndLine;
	GenLibCall('CARD', integerTypeNode, WORDSIZE, 2, rtCARD);

    | BIPseed :
	(* Get current value of _seed and set aside *)
	p3 := p2^.next;
	GenExpr(p3, EVALGET);
	GenOp(PCSAV); I(0); X; C('m'); EndLine;
	(* Store new value *);
	GenExpr(p1, EVALGET);
	GenStore(p2, integerTypeNode);
	(* Leave old value on stack *)
	GenOp(PCUSE); I(0); X; C('m'); EndLine;

    | BIPrandom :
	GenExpr(p1,EVALGET);
	(* Throw away value *)
	GenOp(PCSAV); I(0); X; C('d'); EndLine;
	GenOp(PCMST); I(0);
	GenLibCall('RANDOM', longrealTypeNode, LONGREALSIZE, 0, rtRANDOM);
	
    | BIPundefined :
	GenExpr(p1,EVALGET);
	(* Throw away value, and push FALSE *)
	GenOp(PCSAV); I(0); X; C('d'); EndLine;
	GenConstBoolean(false);

    | BIPdate :
	GenOp(PCMST); I(1);
	Endline;
	GenExpr(p1, EVALPOINT);
	GenOp(PCPAR); I(0); EndLine;
	GenLibCall('DATE', nil, 0, 1, rtDATE);

    | BIPtime :
	GenOp(PCMST); I(1);
	Endline;
	GenExpr(p1, EVALPOINT);
	GenOp(PCPAR); I(0); EndLine;
	GenLibCall('TIME', nil, 0, 1, rtTIME);

    | BIPclock :
	GenOp(PCMST); I(0);
	Endline;
	GenLibCall('CLCK', integerTypeNode, WORDSIZE, 0, rtCLCK);

    | BIPsysclock :
	GenOp(PCMST); I(0);
	Endline;
	GenLibCall('SCLCK', integerTypeNode, WORDSIZE, 0, rtSCLCK);

    | BIPwallclock :
	GenOp(PCMST); I(1);
	Endline;
	GenConstInteger(0);
	GenOp(PCPAR); I(0); EndLine;
	GenLibCall('time', integerTypeNode, WORDSIZE, 1, rttime);

    | BIPhalt :
	GenOp(PCMST); I(0);
	Endline;
	GenLibCall('HALT', nil, 0, 0, rtHALT);
	
    | BIPnull :
	(* nothing at all *);

$end

    end (* case *);
end GenBuiltin;

begin (* BuiltinPC *)
    assert(true,'@(#)$Header: BuiltinUC.mod,v 1.6 90/05/23 00:30:27 lattanzi Locked $');
$if pascal then
(* Note that sin, cos, and atan never return errors *)
    mathLibProc[BIPsin,    false].name := 'sin';
    mathLibProc[BIPsin,    false].rt   := rtsin;
    mathLibProc[BIPsin,    true ].name := 'sin';
    mathLibProc[BIPsin,    true ].rt   := rtsin;
    mathLibProc[BIPcos,    false].name := 'cos';
    mathLibProc[BIPcos,    false].rt   := rtcos;
    mathLibProc[BIPcos,    true ].name := 'cos';
    mathLibProc[BIPcos,    true ].rt   := rtcos;
    mathLibProc[BIPexp,    false].name := 'exp';
    mathLibProc[BIPexp,    false].rt   := rtexp;
    mathLibProc[BIPexp,    true ].name := 'EXP';
    mathLibProc[BIPexp,    true ].rt   := rtEXP;
    mathLibProc[BIPln,     false].name := 'log';
    mathLibProc[BIPln,     false].rt   := rtlog;
    mathLibProc[BIPln,     true ].name := 'LN';
    mathLibProc[BIPln,     true ].rt   := rtLN;
    mathLibProc[BIPsqrt,   false].name := 'sqrt';
    mathLibProc[BIPsqrt,   false].rt   := rtsqrt;
    mathLibProc[BIPsqrt,   true ].name := 'SQRT';
    mathLibProc[BIPsqrt,   true ].rt   := rtSQRT;
    mathLibProc[BIParctan, false].name := 'atan';
    mathLibProc[BIParctan, false].rt   := rtatan;
    mathLibProc[BIParctan, true ].name := 'atan';
    mathLibProc[BIParctan, true ].rt   := rtatan;
$end
    if ORD(Last(RuntimeProc)) > MAXBUILTINSCOPES then
	  SWriteF(theCharArray, 'Too many runtimes (%d) for %d scopes\n',
     	       ORD(Last(RuntimeProc)), MAXBUILTINSCOPES);
     	  Error(theCharArray);
	  HALT(1);
    end;
    capBlockNumber := ILLEGAL_BLOCK;
end BuiltinUC.
