implementation module MipUco;
(****************************************************************************
 * Binary Ucode writing module. All sizes are in bytes.
 * $Header: MipUco.mod,v 1.31 90/05/23 00:30:49 lattanzi Locked $
 ****************************************************************************)
import Mipbwri;

import Mipuini;

from Mipudef import
    Filename, Uopcode, Maxinstlength, Bcrec,
    MS_STAMP, LS_STAMP, Datatype,
    Strglgth, UCO_VARARGS,Stringtextptr;

from IO import
    WriteF,WriteC,output,File,WriteB;

from MemLib import
    ALLOCATE;

from Globals import
    TraceGenuc, TraceOpt, DEBUG;

from unix import
    lseek,fseek,fflush,time;

from hack import
    FileNumber;

from stsupport import
    cbHDRR;

from system import
    ByteSize;

const
    MAXUSTACK = 32;			 (* xlate's stack is 32 *)
    MAXPROCSTACK = 20;
    OLDWAY = false;
    opt = true;
    MIPSELUMAGIC = 0182h;
    STYP_UCODE = 0800h;
    FROMBEGINNING = 0;
    FROMHERE = 1;
    FROMEND = 2;

type 
    UopcodeSet = set of Uopcode;
    DataTypeSet = set of Datatype;
    UcoTree = pointer to UcoTreeRec;

    UcoList = record
        first,last : UcoTree;
        nitems : cardinal;
    end;

    UcoTreeRec = record
        u : Bcrec;
        line : integer;
     	op1,op2,next : UcoTree;
        refcount : integer;
        string : Stringtextptr;
    end;

    UcoProcRec = record
        mst, call : UcoTree;
        params : UcoList;
    end;
       
    UcoStackRange = [1..MAXUSTACK];
    ProcStackRange = [1..MAXPROCSTACK];
    UcoStack = array UcoStackRange of UcoTree;
    ProcStack = array ProcStackRange of UcoProcRec;
    ushort = @size 16 @align 16 cardinal;
    long = cardinal;

    FileHdr = record
      f_magic : ushort; 		(* magic number 		     *)
      f_nscns : ushort; 		(* number of sections		     *)
      f_timdat : long;			(* time & date stamp		     *)
      f_symptr : long;			(* file pointer to symbolic header   *)
      f_nsyms : long;			(* sizeof(symbolic hdr) 	     *)
      f_opthdr : ushort;		(* sizeof(optional hdr) 	     *)
      f_flags : ushort; 		(* flags			     *)
    end;

    ScnHdr = record
      s_name : array[1..8] of char;     (* section name		     *)
      s_paddr : long;			(* physical address		     *)
      s_vaddr : long;			(* virtual address		     *)
      s_size : long;			(* section size 		     *)
      s_scnptr : long;			(* file ptr to raw data for section  *)
      s_relptr : long;			(* file ptr to relocation	     *)
      s_lnnoptr : long; 		(* file ptr to gp histogram	     *)
      s_nreloc : ushort;		(* number of relocation entries      *)
      s_nlnno : ushort; 		(* number of gp histogram entries    *)
      s_flags : long;			(* flags			     *)
    end;

var
    uFileName : Filename;
    theString,nullString : Stringtextptr;
    tempchar : char;
    uStack : UcoStack;
    procStack : ProcStack;
    uTop,procTop : Cardinal;
    uList, freeList, nullList : UcoList;
    varargs : UcoTree;
    curLine, i, parambytes, curUcodeBlock : integer;
    numIlodOpt, numIstrOpt, numAddOpt : integer;
    fh : FileHdr;
    sh : ScnHdr;
    codeFile : File;
    clearU : Bcrec;

procedure Uprocess(const u : Bcrec);
var
    t,t1,t2 : UcoTree;
    u1,u2 : Bcrec;
    us : Cardinal;

    procedure DupTree(const t : UcoTree) : UcoTree;
    var dummy : UcoTree;
    begin
        if t = nil then return t; end;
     	inc(t^.refcount);
        dummy := DupTree(t^.op1);
     	dummy := DupTree(t^.op2);
     	dummy := DupTree(t^.next);	 (* what about prior? *)
     	return t;
    end DupTree;

    procedure PrintTree(t : UcoTree);
        procedure @inline PrintOp(const op : Uopcode; 
     	       	    	      	  const level,line : integer);
        var i : integer;
        begin 
            for i := 1 to level do
     	        WriteC(output,'=');
            end;
            WriteF(output,'=%n (Line %d)\n',op,line);
        end PrintOp;
        procedure Print(const t : UcoTree; const level : integer);
	begin
     	    if t = nil then return; end;
            Print(t^.op1,level+1);
     	    Print(t^.op2,level+1);
            PrintOp(t^.u.Opc,level,t^.line);
            if (level # 0) and (t^.next # nil) then
     	        Print(t^.next,level);
            end;
        end Print;
    begin
        while t <> nil do
            Print(t,0);
     	    t := t^.next;
        end;
    end PrintTree;

    procedure EmitTree(t : UcoTree);
        procedure @inline EmitOp(const U : Bcrec; const level : integer);
        var i : integer;
	begin
            Mipbwri.uwrite(U);
            if (U.Opc = Ucomm) and 
               ((DEBUG and TraceGenuc) or 
                (U.Constval.Chars^.ss[Low(U.Constval.Chars^.ss)] = '%'))
              then WriteF(output,'%s\n',U.Constval.Chars^.ss); end;
            if DEBUG and TraceGenuc then
                for i := 1 to level do
     	            WriteC(output,'+');
                end;
                WriteF(output,'+%n\n',U.Opc);
            end;
        end EmitOp;      
        procedure Emit(const t : UcoTree; const level : integer);
        begin
    	    if t = nil then return; end;
            Emit(t^.op1,level+1);
     	    Emit(t^.op2,level+1);
            EmitOp(t^.u,level);
            if (level # 0) and (t^.next # nil) then
     	        Emit(t^.next,level);
            end;
     	end Emit;
    begin
        while t <> nil do
            Emit(t,0);
     	    t := t^.next;
        end;
    end EmitTree;
    
    procedure FreeTree(var t : UcoTree);
    var next : UcoTree;
        procedure @inline FreeOp(var t : UcoTree; const level : integer);
        var i : integer;
        begin
            if DEBUG and TraceGenuc then
                for i := 1 to level do
     	            WriteC(output,'-');
                end;
                WriteF(output,'-%n\n',t^.u.Opc);
            end;
     	    dec(t^.refcount);
     	    if t^.refcount = 0 then 
     	        t^.next := nil;
     	        PrependTree(freeList,t);
     	        t := nil;
            end;
        end FreeOp;
        procedure Free(var t : UcoTree; const level : integer);
        begin
            if t = nil then return; end;
            Free(t^.op1,level+1);
     	    Free(t^.op2,level+1);
            if (level # 0) and (t^.next # nil) then
     	        Free(t^.next,level);
            end;
            FreeOp(t,level);
     	end Free;
    begin
        while t <> nil do
            next := t^.next;
            Free(t,0);
            t := next;
        end;
    end FreeTree;

    procedure @inline Pop() : UcoTree;
    var t : UcoTree;
    begin
        t := uStack[uTop];
        uStack[uTop] := nil;
        dec(uTop);
    	return t;
    end Pop;

    procedure @inline Push(const t : UcoTree);
    begin
        inc(uTop);
        uStack[uTop] := t;
    end Push;

    procedure NewTree() : UcoTree;
    var t : UcoTree;
    begin
        if freeList.first = nil then
 	    new(t);
     	    t^.string := nil;
        else
            t := freeList.first;
     	    freeList.first := t^.next;
     	    dec(freeList.nitems);
        end;
        with t^ do
     	    Uclear(u);
            line := curLine;
    	    op1 := nil;
    	    op2 := nil;
     	    next := nil;
     	    refcount := 1;
        end;
     	return t;
    end NewTree;

    procedure BuildU(const u : Bcrec) : UcoTree;
    var t : UcoTree;
    begin
    	t := NewTree();
     	t^.u := u;
        if (u.Opc = Ucomm) or (u.Opc = Ulca) or 
           ((u.Opc = Uldc) and (u.Constval.Chars # nil)) then
     	    if t^.string = nil then
                new(t^.string);
            end;
            t^.string^ := u.Constval.Chars^;
     	    t^.u.Constval.Chars := t^.string;
        end;
        return t;
    end BuildU;

    procedure BuildU1(const u : Bcrec; const op1 : UcoTree) : UcoTree;
    var t : UcoTree;
    begin
        t := NewTree();
     	t^.u := u;
     	t^.op1 := op1;
        if (u.Opc = Ulca) or (u.Opc = Uldc) then
            new(t^.u.Constval.Chars);
            t^.u.Constval.Chars^ := u.Constval.Chars^;
        end;
        return t;
    end BuildU1;

    procedure BuildU2(const u : Bcrec; const op1,op2 : UcoTree) : UcoTree;
    var t : UcoTree;
    begin
     	t := NewTree();
     	t^.u := u;
     	t^.op1 := op1;
     	t^.op2 := op2;
        if (u.Opc = Ulca) or (u.Opc = Uldc) then
            new(t^.u.Constval.Chars);
            t^.u.Constval.Chars^ := u.Constval.Chars^;
        end;
    	return t;
    end BuildU2;
(*
    procedure SearchSortedList(const list : UcoTree;
     	       	    	       offset : integer) : UcoTree;
    begin
        if list = nil then
            return nil;
        elsif (list^.u.Offset <= offset) and 
              (list^.u.Offset + list^.u.Length > offset) then 
     	    return list;
        elsif list^.u.Offset > offset then 
     	    return nil;
        else
     	    return SearchSortedList(list^.next, offset);
        end;
    end SearchSortedList;
*)
    procedure InsertSortedList(var list : UcoList; const t : UcoTree);
    var
        cur,last : UcoTree;
        inserted : boolean;
    begin
        inc(list.nitems);
        if list.first = nil then		 (* Empty list *)
            list.first := t;
     	    list.last := t;
        elsif t^.u.Offset < list.first^.u.Offset then	(*  < Head *)
            t^.next := list.first;
            list.first := t;
        else
            inserted := false;
     	    last := list.first;
            while not inserted and (last^.next # nil) do
                cur := last;
                last := last^.next;
                if t^.u.Offset < last^.u.Offset then
                    cur^.next := t;
                    t^.next := last;
                    inserted := true;
                end;
            end;
            if not inserted then	 (* > Tail *)
                list.last^.next := t;
     	        list.last := t;
            end;
        end;
    end InsertSortedList;

    procedure PrependTree(var list : UcoList; const t : UcoTree);
    begin
        assert(t^.next = nil,'PrependTree');
     	inc(list.nitems);
    	if list.first = nil then
            list.last := t;
        else
            t^.next := list.first;
        end;
        list.first := t;
    end PrependTree;

    procedure AppendTree(var list : UcoList; const t : UcoTree);
    begin
        assert(t^.next = nil,'AppendTree');
     	inc(list.nitems);
    	if list.first = nil then
     	    list.first := t;
        else
     	    list.last^.next := t;
        end;
        list.last := t;
    end AppendTree;

    procedure AppendList(var list : UcoList; list2 : UcoList);
    begin	 (* really nconc *)
        inc(list.nitems,list2.nitems);
        if list.first = nil then
            list.first := list2.first;
        else
            list.last^.next := list2.first;
        end;
        list.last := list2.last;
    end AppendList;

    procedure PopProc() : UcoList;
    var
        level : integer;
        mst, call : UcoTree;
        list : UcoList;
    begin
        mst := procStack[procTop].mst;
        procStack[procTop].mst := nil;
        list := procStack[procTop].params;
        procStack[procTop].params := nullList;
        call := procStack[procTop].call;
        procStack[procTop].call := nil;
        dec(procTop);
     	if call^.u.Opc = Uicuf then
            level := 0;
        else
     	    level := call^.u.Lexlev;
        end;
     	assert(mst^.u.Lexlev = level,'Bad level in PopProc');
     	assert(call^.u.Pop = list.nitems,'Bad pop value in PopProc');
        AppendTree(list,call);
        PrependTree(list,mst);
     	return list;
    end PopProc;

    procedure AppendProc(const t : UcoTree);
    begin
    	if t^.u.Opc = Umst then	 (* Push procedure *)
     	    inc(procTop);
            procStack[procTop].mst := t;
     	elsif t^.u.Opc = Upar then		 (* sort the parameters *)
     	    InsertSortedList(procStack[procTop].params,t);
        elsif t^.u.Dtype = Pdt then
            procStack[procTop].call := t;
     	    AppendList(uList,PopProc()); (* emit void proc's *)
        else
            procStack[procTop].call := t;
        end;
    end AppendProc;

begin
    if DEBUG and TraceGenuc then
        WriteF(output,'<%n\n',u.Opc);
    end;
    case u.Opc of
    (* Straight through ops *)
    | Uesym, Ugsym, Ulsym, Ufsym, Ucsym, Uasym, Uinit, Usdef, Ubgn, Ustp:
        Mipbwri.uwrite(u);
        if (u.Opc = Ubgn) or (u.Opc = Ustp) then
            assert(uTop = 0,'Non-empty ustack');
        end;
    (* Can appear either outside or inside procs *)
    | Uoptn, Uloc, Ucomm:
        if (u.Opc = Ucomm) and 
           ((DEBUG and TraceGenuc) or 
            (u.Constval.Chars^.ss[Low(u.Constval.Chars^.ss)] = '%')) then
     	    WriteF(output,'%s\n',u.Constval.Chars^.ss); 
        end;
        if (u.Opc = Uoptn) and (u.I1 = UCO_VARARGS) then
            varargs := BuildU(u);	 (* should never happen in ph2 *)
        elsif uList.first # nil then
            AppendTree(uList,BuildU(u));
        else
            Mipbwri.uwrite(u);
        end;
    (* 0-ary ops *)
    | Uvreg, Uclab, Udef, Ulex, Ubgnb, Uendb, Uaent, Uunal, Uret:
(*
        if (u.Opc = Udef) and (u.Mtype = Pmt) then
            parambytes := u.Length;
        end;
*)
        AppendTree(uList,BuildU(u));
    (* Spool pdefs until Uend: But we must spit them out before any
       params are used *)
    | Updef:
        AppendTree(uList,BuildU(u));
    (* some basic blocks. Stack *MUST* be empty for all *)
    | Uent, Uend, Ulab, Uujp:
        if u.Opc = Uend then
     	    assert(uList.first = nil,'non-nil uList at Uend');
            Mipbwri.uwrite(u);
        elsif u.Opc = Uent then
     	    assert(uList.first = nil,'non-nil uList at Uent');
            Mipbwri.uwrite(u);	 (* flush it after Uloc *)
        else
     	    AppendTree(uList,BuildU(u));
        end;
	(* Allow runtime checks/inlines to have non-empty stack *)
     	if (uTop # 0) and (u.Opc # Ulab) and (u.Opc # Uujp) then
            WriteF(output,'non-empty stack for uop(%n) from line %d\n',
     	           u.Opc,curLine);
            for us := 1 to uTop do
    	        WriteF(output,'UStack[%d]\n',us);
                PrintTree(uStack[us]);
            end;
     	    halt(1);
        end;
    (* unary operators *)
    | Uabs, Unot, Usqr, Usqrt, Uodd, Ucvtl, Urnd, Uadj, Usgs, Ulnot,
      Uchkh, Uchkl, Ucvt, Uilda, Uneg, Uinc, Udec, Uisld:
        (* Uopt work around for singleton sets > WORDSIZE*)
        if (u.Opc = Usgs) and (u.Length > 4) then
     	    t := Pop();
     	    if t^.u.Opc = Ulod then
                t^.u.Lexlev := VOLATILE_ATTR;
            elsif DEBUG and TraceGenuc then
                WriteF(output,
     	       	       '%n singleton set > WORDSIZE could trigger uopt bug\n',
     	       	       t^.u.Opc);
            end;
            Push(BuildU1(u,t));
        else
            Push(BuildU1(u,Pop()));
        end;
    (* unary void operators *)
    | Uchkt, Uchkn:
        AppendTree(uList,BuildU1(u,Pop()));
    (* binary operators *)
    | Umod:
        t1 := Pop(); 
     	t2 := Pop();
        if u.Dtype = Ldt then		 (* unsigned mod is bust wrt >MAXINT *)
     	    u1 := u;
     	    u1.Opc := Urem;
     	    Push(BuildU2(u1,t2,t1));
        else
            Push(BuildU2(u,t2,t1));
        end;
    | Uand, Udif, Udiv, Uequ, Ugeq, Ugrt, Uior, Uleq, Ules, Umax,
      Umin, Umpy, Umus, Uneq, Ushl, Ushr, Usub, Urem, Uxor, Uixa,
      Uint, Uuni, Uinn, Uiequ, Uigrt, Uileq, Uiles, Uineq:
        t1 := Pop(); 
     	t2 := Pop();
        Push(BuildU2(u,t2,t1));
    (* binary void operators  *)
    (* Utpxx are poison to uopt1.31. 
       Here we remap to compare and Uchkt *)
    | Utpeq, Utpne, Utplt, Utpgt, Utple, Utpge:
        Uclear(u1);
     	u1.Opc := Uchkt;
        u1.Lexlev := 0;
     	t1 := Pop(); 
     	t2 := Pop();
     	u2 := u;
        u2.I1 := 0;
     	case u.Opc of
        | Utpeq: u2.Opc := Uneq;
        | Utpne: u2.Opc := Uequ;
        | Utplt: u2.Opc := Ugeq;
        | Utpgt: u2.Opc := Uleq;
        | Utple: u2.Opc := Ugrt;
        | Utpge: u2.Opc := Ules;
        end;
        AppendTree(uList,BuildU1(u1,BuildU2(u2,t2,t1)));
    (* stack Push ops *)
    | Uldc, Ulda, Ulca, Uldsp: 
        Push(BuildU(u));
    (* unary ops which must have empty stacks *)
    | Utjp, Ufjp:
        AppendTree(uList,BuildU1(u, Pop()));
    | Uxjp:
        t := Pop();
        if (t^.u.Opc in UopcodeSet {Ulod, Uilod}) and
           (t^.u.Length # 4) then	 (* uopt workaround *)
            Uclear(u1);
            u1.Opc := Ucvtl;
            u1.Dtype := t^.u.Dtype;
            u1.I1 := 8*t^.u.Length;
     	    t := BuildU1(u1,t);
        end;
        AppendTree(uList,BuildU1(u, t));
    | Uaos, Ustr:
        AppendTree(uList,BuildU1(u, Pop()));
    (* binary ops which must have empty stacks *)
    | Uisst:				 (* Can be corrupted by uopt *)
        t1 := Pop();			 (* See CheckExpr/EndMultiple *)
     	t2 := Pop();	 (* currMult := MakeExprConst(cardIntTypeNode,1.0); *)
        			 (* the isst becomes isld/str *)
        (*if t2^.u.Opc # Uilda then
     	    u1 := u;
     	    u1.Opc := Uilda;
     	    u1.Offset := 0;
     	    u1.Offset2 := 0;
     	    t2 := BuildU1(u1,t2);
        end;*)
        AppendTree(uList,BuildU2(u,t2,t1));
    | Umov:
        t1 := Pop();
        t2 := Pop(); 
        AppendTree(uList,BuildU2(u,t2,t1));
    | Uadd:				 (* provide more window for 
     	       	    	      	            subsequent optimizations *)
        t1 := Pop();
     	t2 := Pop();
        if opt then
            if (t1^.u.Opc = Uldc) and (t1^.u.Dtype = Adt) then
     	        if t2^.u.Opc = Ulda then
                    inc(t2^.u.Offset,t1^.u.Constval.Ival);
     	            inc(t2^.u.Offset2,t1^.u.Constval.Ival);
	            Push(t2);
                else
     	       	    Uclear(u1);
     	       	    u1.Opc := Uinc;
     	            u1.Dtype := Adt;
                    u1.Lexlev := 0;
                    u1.I1 := t1^.u.Constval.Ival;
     	       	    Push(BuildU1(u1,t2));
                end;
                FreeTree(t1);        
     	        inc(numAddOpt);
     	    elsif (t2^.u.Opc = Uldc) and (t2^.u.Dtype = Adt) then
                if t1^.u.Opc = Ulda then
                    inc(t1^.u.Offset,t2^.u.Constval.Ival);
     	            inc(t1^.u.Offset2,t2^.u.Constval.Ival);
	            Push(t1);
                else
     	       	    Uclear(u1);
     	       	    u1.Opc := Uinc;
     	            u1.Dtype := Adt;
                    u1.Lexlev := 0;
                    u1.I1 := t2^.u.Constval.Ival;
     	       	    Push(BuildU1(u1,t1));
                end;
                FreeTree(t2);        
     	        inc(numAddOpt);
     	    else
                Push(BuildU2(u,t2,t1));
     	    end;
        else
            Push(BuildU2(u,t2,t1));
        end;
    | Uilod:				 (* optimize *)
        t := Pop();
     	if opt then
            if t^.u.Opc = Ulda then
                Uclear(u1);
                u1.Opc := Ulod;
                u1.Dtype := u.Dtype;
     	        u1.I1 := t^.u.I1;
     	        u1.Offset := u.I1 + t^.u.Offset;
     	        u1.Mtype := t^.u.Mtype;
     	        u1.Length := u.Length;
                u1.Lexlev := 0;
(*
 Ulod 3 don't work so don't worry about it.
     	    if u1.Length > t1^.u.Length then 
 	        writef(output,'ILOD optimization improper lengths %d,%d\n!',
     	       	       u1.Length,t1^.u.Length);
     	        PrintTree(t1);
            end;
*)
     	        inc(numIlodOpt);
     	        Push(BuildU(u1));
                FreeTree(t);
     	    elsif t^.u.Opc = Uinc then
                u1 := u;
     	        inc(u1.I1,t^.u.I1);
     	        inc(numAddOpt);
     	        Push(BuildU1(u1,t^.op1));
     	    else
                Push(BuildU1(u,t));
            end;
        else
     	    Push(BuildU1(u,t));
        end;
    | Uistr:				 (* optimize *)
        t1 := Pop();
        t2 := Pop();
     	if opt then
            if t2^.u.Opc = Ulda then
                Uclear(u1);
     	        u1.Opc := Ustr;
                u1.Dtype := u.Dtype;
     	        u1.I1 := t2^.u.I1;
     	        u1.Offset := u.I1 + t2^.u.Offset;
     	        u1.Mtype := t2^.u.Mtype;
     	        u1.Length := u.Length;
                u1.Lexlev := 0;
     	        inc(numIstrOpt);

		assert(u1.Length <= t2^.u.Length,
                       'ISTR optimization improper lengths!');
		AppendTree(uList,BuildU1(u1,t1));
		FreeTree(t2);
	    elsif t2^.u.Opc = Uinc then
                u1 := u;
     	        inc(u1.I1,t2^.u.I1);
     	        inc(numAddOpt);
     	        AppendTree(uList,BuildU2(u1,t2^.op1,t1));
     	    else
     	        AppendTree(uList,BuildU2(u,t2,t1));
            end;
     	else
     	    AppendTree(uList,BuildU2(u,t2,t1));
     	end;
    (* procedure hacking *)
    | Ulod: 
        (* loading procedure retval? *)
        if (u.Mtype = Rmt) and (procTop # 0) and
           (procStack[procTop].call^.u.Opc in UopcodeSet {Ucup,Uicuf}) then
            Push(BuildU1(u,PopProc().first));
        else
     	    Push(BuildU(u));
     	end;
    (* unary proc ops *)
    | Upar, Upmov, Uicuf:
        AppendProc(BuildU1(u,Pop()));
    (* 0-ary proc ops *)
    | Umst, Ucup:
        AppendProc(BuildU(u));
    (* stack manipulation ops *)
    | Uswp:
        t1 := Pop();
        t2 := Pop(); 
     	Push(t1);
        Push(t2);
    | Udup:
        Push(DupTree(uStack[uTop-0]));
    | Upop:
        t := Pop(); FreeTree(t);    (* side-effects thrown away? *)
    | Unop:;
    (* implementation of non-empty stack store *)
    | Unstr:
        u1 := u;
    	u1.Opc := Ustr;
        AppendTree(uList,BuildU1(u1, Pop()));
        u1.Opc := Ulod;
        Push(BuildU(u1));
    else
        (* Ugoob, Uijp, Uldef, Ustsp, *)
        WriteF(output,'Unsupported uop (%n) in Uprocess\n', u.Opc);
        Mipbwri.uwrite(u);
    end;
    if DEBUG and TraceGenuc then
        for us := 1 to uTop do
    	    WriteF(output,'UStack[%d]\n',us);
            PrintTree(uStack[us]);
        end;
    end;
    if uList.first # nil then
        EmitTree(uList.first);
        FreeTree(uList.first);
     	uList := nullList;
    end;
end Uprocess;

procedure Ucoloc(Fnumber : integer; Fline : integer);
var
    U : Bcrec;
begin
    if Fline = 0 then Fline := curLine+1; end; (* __init are given line 0! *)
    Uclear(U);
    U.Opc := Uloc;
    U.I1 := Fnumber;
    U.Length := Fline;
    curLine := Fline;
    Uprocess(U);
end Ucoloc;

procedure Ucooptn(Fname : integer; Fint : integer);
var
    U : Bcrec;
begin
    Uclear(U);
    U.Opc := Uoptn;
    U.I1 := Fname;
    U.Length := Fint;
    Uprocess(U);
end Ucooptn;

procedure Uco0(op : Uopcode);
var
    U : Bcrec;
begin
    assert(op in UopcodeSet {Uaos,Uchkt,Uchkn,Uldsp,Uret},
     	   'Uco0: bogus ucode');
    Uclear(U);
    U.Opc := op;
    U.Lexlev := 0;
    Uprocess(U);
end Uco0;

procedure Uco1int(Fop : Uopcode; Fint : integer);
var
    U : Bcrec;
begin
    assert(Fop in UopcodeSet {Umst,Ubgn,Ubgnb,Uend,Uendb,Ufjp,Ustp,Utjp,Uujp},
           'Uco1int: bogus ucode');
    Uclear(U);
    U.Opc := Fop;
    if Fop = Umst then
	U.Lexlev := Fint;
    else
	U.I1 := Fint;
	if Fop = Ubgn then
	    U.Length := MS_STAMP;
	    U.Offset := LS_STAMP;
	end;
    end;
    Uprocess(U);
end Uco1int;

procedure Uco1type(Fop : Uopcode; Fdty : Datatype);
var
    U : Bcrec;
begin
    assert(Fop in UopcodeSet {Uabs,Uadd,Uand,Udiv,Udup,Uequ,Ugeq,Ugrt,Uior,
     	       	    	      Uleq,Ules,Umin,Umax,Umod,Urem,Umpy,Uneg,Uneq,
     	       	    	      Unot,Uodd,Upop,Usub,Uxor,Ushl,Ushr,Ulnot},
           'Uco1type: bogus ucode');
    if not (Fop in UopcodeSet {Udup,Upop}) then
        assert(Fdty # Zdt, 'Uco1type: bogus datatype');
    end;
    Uclear(U);
    U.Opc := Fop;
    U.Dtype := Fdty;
    U.Lexlev := 0;      (* no overflow check *)
    Uprocess(U);
end Uco1type;

procedure Uco2typtyp(const Fop : Uopcode; const Fdty1, Fdty2 : Datatype);
var
    U : Bcrec;
begin
    assert(Fop in UopcodeSet{Ucvt,Ucvt2,Uswp},'Uco2typtyp: bogus ucode');
    if Fop # Uswp then
        assert(Fdty1 # Zdt, 'Uco2typtyp: bogus first datatype');
        assert(Fdty2 # Zdt, 'Uco2typtyp: bogus second datatype');
    end;
    Uclear(U);
    U.Opc := Fop;
    U.Dtype := Fdty1;
    U.Dtype2 := Fdty2;
    U.Lexlev := 0;      (* no overflow check *)
    Uprocess(U);
end Uco2typtyp;

procedure Uco2int (const Fop : Uopcode; const dataType : Datatype; 
     const offset, length : integer);
var
    U : Bcrec;
begin
    assert(Fop in UopcodeSet {Uadj,Uinn,Uistr,Uilod},
     	   'Uco2int: bogus ucode');
    assert(dataType # Zdt, 'Uco2int: bogus datatype');
    if Fop in UopcodeSet {Uistr,Uilod} then
	assert((length<=4) or (dataType=Qdt) or (dataType=Sdt),'Uco2int: bad size');
    end;
    Uclear(U);
    with U do 
        Opc := Fop;
     	Dtype := dataType;
     	I1 := offset;
     	Length := length;
    end;
    Uprocess(U);
end Uco2int;

procedure Uco2intint (const Fop : Uopcode; const Fint1, Fint2 : integer);
    var U : Bcrec;
begin
    assert(Fop in UopcodeSet {Uclab,Uiequ,Uigeq,Uigrt,Uileq,Uiles,Uineq,Umov,
     	       	    	      Ulex},
     	   'Uco2intint: bogus ucode');
    Uclear(U);
    U.Opc := Fop;
    with U do
        case Fop of
        | Uclab, Usdef:
            I1 := Fint1;
            Length := Fint2;
        | Umov, Uiequ, Uigrt, Uigeq, Uileq, Uiles, Uineq : 
            Dtype := Mdt;
            I1 := Fint1;
            Length := Fint2;
            Lexlev := 0;
        | Ugoob : 
            I1 := Fint1;
            Lexlev := Fint2;
        | Ulex : 
            Lexlev := Fint1;
            I1 := Fint2;
        end;
    end;
    Uprocess(U);
end Uco2intint;

procedure Uco2typint (const Fop : Uopcode; const dataType : Datatype; 
     const Fint : integer);
var
    U : Bcrec;
begin
    assert(Fop in UopcodeSet {Uchkh,Uchkl,Ucvtl,Udec,Udif,Uinc,Uint,Uixa,Usgs,
     	       	    	      Uuni,Utpeq,Utpne,Utplt,Utpgt,Utpge,Utple,Umus},
     	   'Uco2typint: bogus ucode');
    assert(dataType # Zdt, 'Uco2typint: bogus datatype');
    Uclear(U);
    with U do 
     	Opc := Fop;
     	Dtype := dataType;
     	Lexlev := 0;
     	if Fop in UopcodeSet {Uixa, Uchkl, Uchkh, Uinc, Udec, Ucvtl,
     	       	    	      	Utpeq, Utpne, Utplt, Utpgt, Utpge, Utple} then
     	    I1 := Fint;
     	else
     	    Length := Fint;
     	end;
    end;
    Uprocess(U);
end Uco2typint;

procedure Uco4int (const Fop : Uopcode; const memType : Memtype; 
     const block, offset, length, offset2 : integer);
var
    U : Bcrec;
begin
    assert(Fop in UopcodeSet {Uilda,Ulda},
     	   'Uco4int: bogus ucode');
    assert(memType # Zmt, 'Uco4int: bogus memtype');
    assert(block > 0,'Uco4int: bogus block');
    Uclear(U);
    with U do 
     	Opc := Fop;
     	I1 := block;
     	Offset := offset;
     	Mtype := memType;
     	Length := length;
     	Offset2 := offset2;
    end;
    Uprocess(U);
end Uco4int;

procedure UcoProc(const Fop : Uopcode; const dataType : Datatype;
     	          const lev, blockNumber : integer;
     	       	  const pop, push, flag : integer);
var U : Bcrec;
begin
    assert(Fop in UopcodeSet {Ucup,Uent,Uicuf},'UcoProc: bogus ucode');
    assert(dataType # Zdt, 'UcoProc: bogus datatype');
    Uclear(U);
    with U do
        Opc := Fop;
        Dtype := dataType;
        Lexlev := lev;
        I1 := blockNumber;
        Pop := pop;
        Push := push;
        Extrnal := flag;
    end;
    Uprocess(U);     
end UcoProc;

procedure Ucolab(Fname, flag1, flag2 : integer);
var
    U : Bcrec;
begin
    Uclear(U);
    with U do
        Opc := Ulab;
        I1 := Fname;
        Lexlev := flag1;
        Length := flag2;
    end;
    Uprocess(U);
end Ucolab;

procedure Ucomment(const str : array of char);
var
    I : integer;
    U : Bcrec;
begin
    Uclear(U);
    with U do
        Opc := Ucomm;
        Dtype := Mdt;
        with Constval do
     	    Chars := theString;
            for I := Low(Chars^.ss) to High(Chars^.ss) do
                Chars^.ss[I] := 0C;
            end;
            I := MIN(NUMBER(str), Strglgth);
            Ival := 0;
            while (Ival < I) and (str[Ival] # 0C) do
     	        inc(Ival);
     	       Chars^.ss[Ival] := str[Ival-1];
            end;
        end;
    end;
    Uprocess(U);
end Ucomment;

procedure Ucomment2(const str1, str2 : array of char);
var
    I : integer;
    U : Bcrec;
begin
    Uclear(U);
    U.Opc := Ucomm;
    U.Dtype := Mdt;
    with U.Constval do
        Chars := theString;
        for I := Low(Chars^.ss) to High(Chars^.ss) do
            Chars^.ss[I] := 0C;
        end;
        for I := Low(str1) to High(str1)-1 do	 (* assume won't overflow *)
           Chars^.ss[I+Low(Chars^.ss)-Low(str1)] := str1[I];
        end;
        I := Low(str2);
        while (I < MIN(High(str2),Strglgth-Number(str1))) and
              (str2[I] # 0C) do
           Chars^.ss[Low(Chars^.ss)+Number(str1)-1+I-Low(str2)] := str2[I];
           inc(I);
        end;
        Chars^.ss[Low(Chars^.ss)+Number(str1)-1+I-Low(str2)] := 0C; (* term *)
        Ival := Min(Number(str1)-1 + I,Strglgth);
        Uprocess(U);
    end;
end Ucomment2;

procedure Ucoldc(const dataType : Datatype; const length, value : integer;
     	         const realString : array of char);
var
     U : Bcrec;
     I : integer;
begin
     assert(dataType # Zdt, 'Ucoldc: bogus datatype');
     Uclear(U);
     U.Opc := Uldc;
     U.Dtype := dataType;
     U.Length := length;
     with U.Constval do
     	  case dataType of
     	  | Adt, Jdt, Ldt, Fdt : Ival := value; Chars := nil;
     	  | Rdt, Qdt, Sdt :
     	       Chars := theString;
     	       Chars^ := nullString^;
      	       I := MIN(NUMBER(realString), Strglgth);
      	       Ival := Low(Chars^.ss) - 1;
      	       while (Ival < I) and (realString[Ival] # 0C) do
     	       	    inc(Ival);
     	       	    Chars^.ss[Ival] := realString[Ival-1];
      	       end;
     	       (* set strings are not null-term *)
               if dataType = Sdt then
     	           Ival := 2*length;
               end;
          else
     	       Ucomment('TRACE Ucoldc unsupported data type');
     	  end;
     end;
     Uprocess(U);
end Ucoldc; 

procedure Ucoinit(const dataType : Datatype; const memType : Memtype; 
     	          const block,offset,offset2,length,arrayOffset,value :integer;
     	       	  const realString : array of char);
var
     U : Bcrec;
     I : integer;
begin
    assert(dataType # Zdt,'Ucoinit: bogus datatype');
    Uclear(U);
    with U do
        Opc := Uinit;
        Dtype := dataType;
        Mtype := memType;
        I1 := block;
    	Length := min(length,Strglgth);
        Offset := offset;
        Offset2 := offset2;
        aryoff := arrayOffset;
        with Initval do
     	    case dataType of
     	    | Adt, Jdt, Ldt, Fdt : Ival := value;
     	    | Rdt, Qdt, Sdt, Mdt:
     	        Chars := theString;
     	        Chars^ := nullString^;
(*
     	        bzero(adr(Chars^.ss[Low(Chars^.ss)]),Number(Chars^.ss));
*)
     	        (* If we truncate init should gen another? *)
      	        I := MIN(NUMBER(realString), Strglgth);
      	        Ival := Low(Chars^.ss) - 1;
      	        while (Ival < I) and (realString[Ival] # 0C) do
     	       	    inc(Ival);
     	       	    Chars^.ss[Ival] := realString[Ival-1];
      	        end;
                if dataType = Sdt then 
     	            Ival := 2*length;
     	        elsif dataType = Mdt then 
                    if Ival < min(length,Strglgth) then 
                        Ival := min(length,Strglgth);
                    else
                        inc(Ival);
                    end; (* null-term *)
                end;
            else
     	        Ucomment('%TRACE Ucoinit unsupported data type');
     	    end;
        end;
    end;
    Uprocess(U);
    if length > Strglgth then
        Ucoinit(dataType,memType,block,offset+Strglgth,offset2+Strglgth,
    	 	length-Strglgth,arrayOffset,value,
     	       	realString[Strglgth:High(realString)-Strglgth]);
    end;
end Ucoinit; 

procedure Ucolca(const length : integer; const str : array of char);
var
    I : integer;
    U : Bcrec;
begin
    Uclear(U);
    with U do
        Opc := Ulca;
        Dtype := Mdt;
        Length := length;
        I1 := 0;
        with Constval do
            Ival := min(length,Strglgth); (* don't go overboard with 5000! *)
            Chars := theString;
            for I := Low(Chars^.ss) to High(Chars^.ss) do
    	        Chars^.ss[I] := 0C;
            end;
            I := Low(Chars^.ss) - 1;
            while (I < min(number(str),Strglgth)) and (str[I] # 0C) do
                inc(I);
     	        Chars^.ss[I] := str[I-1];
            end;
        end;
    end;
    Uprocess(U);
end Ucolca;

procedure Ucosym(const Fop : Uopcode; const blockNumber,align,size : integer);
    var U : Bcrec;
begin
    assert(Fop in UopcodeSet {Ucsym,Uesym,Ugsym,Ulsym},'Ucosym: bogus ucode');
    Uclear(U);
    with U do
        Opc := Fop;
        I1 := blockNumber;
        Lexlev := align;
        Length := size;
    end;
    Uprocess(U);
end Ucosym;

procedure Ucomem (const Fop : Uopcode;
     	       	  const dataType : Datatype;
     	          const memType : Memtype;
     	       	  const blockNumber, offset, length, mode : integer);

    var U : Bcrec;
        l : integer;
begin
    assert(Fop in UopcodeSet {Ulod,Unstr,Upar,Updef,Ustr,Uisld,Uisst,Uvreg},
    	   'Ucomem: bogus ucode');
    assert(dataType # Zdt, 'Ucomem: bogus datatype');
    assert(memType # Zmt, 'Ucomem: bogus memtype');
    if (Fop in UopcodeSet {Upar,Updef}) and (length = 3) then 
        l := 4;				 (* don't force 3 byte objects *)
    else				 (* to be aligned on 3 byte boundary *)
        l := length;
    end;
    if dataType in DataTypeSet {Mdt,Sdt} then (* pdef could use mdt *)
        assert(offset mod 4 = 0,'Ucomem: bogus offset');
    else
        assert(offset mod l = 0,'Ucomem: bogus offset');
    end;
    if Fop in UopcodeSet {Upar,Updef} then
        assert(offset mod 4 = 0,'Ucomem: bogus offset');
    else
	assert((length <= 4) or (dataType in DataTypeSet {Qdt,Sdt}),'Ucomem: bogus size');
    end;
    Uclear(U);
    with U do
        Opc := Fop;
        Dtype := dataType;
     	I1 := blockNumber;
     	Offset := offset;
     	Mtype := memType;
     	Length := l;
     	if Fop in UopcodeSet {Updef,Uvreg} then
     	    Lexlev := mode;
     	else
	    Lexlev := 0;
     	end;
    end;
    Uprocess(U);
end Ucomem;

procedure Ucodef (const memType : Memtype; const size : integer);
    var U : Bcrec;
begin
    assert(memType # Zmt, 'Ucodef: bogus memtype');
    Uclear(U);
    with U do
        Opc := Udef;
        Mtype := memType;
        Length := size;
    end;
    Uprocess(U);
end Ucodef;

procedure Ucoicuf(const dataType : Datatype; 
     	       	  const pop,push,flag : integer);
    var U : Bcrec;
begin
    Uclear(U);
    with U do
        Opc := Uicuf;
        Dtype := dataType;
        Pop := pop;
        Push := push;
        Extrnal := flag;
    end;
    Uprocess(U);
end Ucoicuf;

procedure Ucoxjp(const Fdty : Datatype; 
     	         const Ffirstlabel, Fotherslabel : integer;
                 const Flowbound, Fhighbound : integer);
    var U : Bcrec;
begin
    Uclear(U);
    with U do
        Opc := Uxjp;
        Dtype := Fdty;
        I1 := Ffirstlabel;
        Label2 := Fotherslabel;
        Offset := Flowbound;
        Length := Fhighbound;
    end;
    Uprocess(U);
end Ucoxjp;

procedure @inline Uclear(var U : Bcrec);
    var I : integer;
begin
     U := clearU;
(*
     bzero(adr(U),ByteSize(U));
*)
end Uclear;

procedure EndUcode;
begin
    Mipbwri.uputflush;
    sh.s_size := lseek(FileNumber(codeFile),0,FROMEND) - fh.f_symptr;
    inc(fh.f_symptr,sh.s_size);
    assert(lseek(FileNumber(codeFile),0,FROMBEGINNING)=0,
     	   'bogus seek return in EndUcode');
    assert(fseek(codeFile,0,FROMBEGINNING) = 0);
    WriteB(codeFile,fh,ByteSize(fh));
    WriteB(codeFile,sh,ByteSize(sh));
    fflush(codeFile);
    assert(lseek(FileNumber(codeFile),0,FROMEND) = fh.f_symptr,
     	   'bogus seek return in EndUcode');
    if DEBUG and TraceOpt then
        writef(output,'numAddOpt = %d\n',numAddOpt);
        writef(output,'numIlodOpt = %d\n',numIlodOpt);
        writef(output,'numIstrOpt = %d\n',numIstrOpt);
    end;
end EndUcode;

procedure SetUCodeFile(const uFile : File);
var ignore : integer;
begin
    codeFile := uFile;
    with fh do
        f_magic := MIPSELUMAGIC;
        f_nscns := 1;
     	f_timdat := time(ignore);
     	f_symptr := ByteSize(fh) + ByteSize(sh); (* partially set *)
     	f_nsyms := cbHDRR;		 (* not set yet *)
     	f_opthdr := 0;
     	f_flags := 0;
    end;
    WriteB(codeFile,fh,ByteSize(fh));
    with sh do
        s_name := '_UCODE';
        s_paddr := 0;
     	s_vaddr := 0;
     	s_size := 0;		 (* not set yet *) 
     	s_scnptr := ByteSize(fh) + ByteSize(sh);
     	s_relptr := 0;
     	s_lnnoptr := 0;
     	s_nreloc := 0;
     	s_nlnno := 0;
     	s_flags := STYP_UCODE;
    end;
    WriteB(codeFile,sh,ByteSize(sh));
    fflush(codeFile);
    Mipbwri.inituwrite('/dev/null');
    Mipbwri.uputinitfd(FileNumber(codeFile));
end SetUCodeFile;

procedure StartUcode(const codeFileName : FileName);
begin
    Mipbwri.inituwrite(codeFileName);
end StartUcode;

begin
    assert(true,'@(#)$Header: MipUco.mod,v 1.31 90/05/23 00:30:49 lattanzi Locked $');
    Lastuclabel := 0;
    Mipuini.uini;
    for uTop := Low(uStack) to High(uStack) do
        uStack[uTop] := nil;
    end;
    uTop := 0;
    nullList.first := nil;
    nullList.last := nil;
    nullList.nitems := 0;
    for procTop := Low(procStack) to High(procStack) do
        procStack[procTop].mst := nil;
        procStack[procTop].params := nullList;
        procStack[procTop].call := nil;
    end;
    procTop := 0;
    uList := nullList;
    varargs := nil;
    curLine := -1;
    numIlodOpt := 0;
    numIstrOpt := 0;
    numAddOpt := 0;
    freeList := nullList;
    new(theString);
    new(nullString);
    for i := 1 to Maxinstlength do
        clearU.Intarray[i] := 0;
    end;
    for i := Low(nullString^.ss) to High(nullString^.ss) do
        nullString^.ss[i] := 0C;
    end;
end MipUco.
