implementation module Mipbwri;
$if vax then
import Mipuini;

from stinfc import FileName;

from Mipudef import 
	Identlength, Strglgth, HostCharsPerWord,
	Bytesize, Identname, Filename, Maxinstlength, Datatype,
	Memtype, Stringtextptr, Uopcode, Bcrec, Uoperand, Utabrec;

type
	DatatypeSet = set of Datatype;
	UopcodeSet = set of Uopcode;
var
  Dtyname :  array Datatype of char; (* printable image of the ucode  *)
					(* data types			     *)
  Mtyname :  array Memtype of char; (* printable image ff the ucode   *)
					(* memory types 		     *)
  NoErrorsYet : boolean;

(*InitUwrite*)

procedure inituwrite (const ObjectName : FileName);
begin
    NoErrorsYet := true;
    uputinit(ObjectName);
    Dtyname[Zdt] := 'Z';
    Dtyname[Adt] := 'A';
    Dtyname[Edt] := 'E';
    Dtyname[Fdt] := 'F';                (* redbob                            *)
    Dtyname[Gdt] := 'G';                (* !04                               *)
    Dtyname[Hdt] := 'H';
    Dtyname[Jdt] := 'J';
    Dtyname[Ldt] := 'L';
    Dtyname[Mdt] := 'M';
    Dtyname[Ndt] := 'N';
    Dtyname[Pdt] := 'P';
    Dtyname[Qdt] := 'Q';
    Dtyname[Rdt] := 'R';
    Dtyname[Sdt] := 'S';
    Dtyname[Xdt] := 'X';                (* !02                               *)

    Mtyname[Zmt] := 'Z';
    Mtyname[Mmt] := 'M';
    Mtyname[Rmt] := 'R';
    Mtyname[Smt] := 'S';
    Mtyname[Pmt] := 'P';
    Mtyname[Tmt] := 'T';
    Mtyname[Amt] := 'A';
   (*procedure InitUwrite*)end inituwrite;

procedure idlen(var Id : Identname) : integer;
var
    I : integer;
  begin
(*  Modula-2 character arrays are null terminated *)
    return(strlen(Id));
(*  MIPS PASCAL code. *)
(*  I := Identlength;
    Idlen := 0;
    repeat
      if (Id[I] <> ' ') then Idlen := I
      else I := I - 1; 
    until (I = 1) or (Id[I+1] <> ' ');
*)
   (*function Idlen*)end idlen;

procedure fnamelen(var Fn : Filename): integer;
var i : integer;
  begin
(*  Modula-2 character arrays are null terminated *)
    return(strlen(Fn));
(*  MIPS PASCAL code. *)
(*  i := 0;
    fnamelen := Filenamelen;
    repeat
      if Fn[i+1] = ' ' then fnamelen := i
      else i := i + 1; 
    until (i = Filenamelen) or (Fn[i-1] = ' ');
*)
   (*function Fnamelen*)end fnamelen;

procedure uwrite(const U:Bcrec);
var
    Llen : integer;
    Index : [1..8];
    Utabr : Utabrec;
    Strptr : Stringtextptr;
  begin
    if NoErrorsYet then
      with U do
	Mipuini.getutabrec(Opc, Utabr);
	for Index := 1 to Utabr.Instlength do
	  uputint(U.Intarray[Index]);
	end;(*for*)
	if Utabr.Hasconst then
	  (* write out the integer value or length (in bytes) of string      *)
	  uputint(U.Intarray[Utabr.Instlength+1]);
	  if (Dtype in DatatypeSet{Rdt, Qdt, Sdt, Mdt, Edt, Xdt}) or (Opc = Ucomm) then
	    (* redbob !01, !02						     *)
	    if Opc = Uinit then
	      Llen := (Initval.Ival+HostCharsPerWord-1) div HostCharsPerWord;
	    else
	      Llen := (Constval.Ival+HostCharsPerWord-1) div HostCharsPerWord;
	    end;
	    (* write out length (in words) of string			     *)
	    uputint(Llen);
	    (* write out string in string record			     *)
	    if Opc = Uinit then
              Strptr := Initval.Chars
	    else Strptr := Constval.Chars;end;
	    for Index := 1 to Llen do
	      uputint(Strptr^.ssarray[Index]);
	    end;(*for*)
	  end;
	end;
      end;(*with*)
    end;
   (*procedure Uwrite*)end uwrite;
(* getdtyname,getmtyname,writebuf,ucoid *)

procedure ucoid(var Tag : Identname);
var
    I : integer;
    U : Bcrec;
  begin
    for I := 1 to Maxinstlength do U.Intarray[I] := 0;end;
    with U.Constval do
      new(Chars);
      for I := 1 to Identlength do Chars^.ss[I] := Tag[I];end;
      Ival := Identlength;
      U.Opc := Ucomm;
      U.Dtype := Mdt;
      uwrite(U);
      dispose(Chars);
    end;(*with*)
   (*procedure Ucoid*)end ucoid;

procedure ucofname(var Fnam : Filename);
var
    I : integer;
    U : Bcrec;
  begin
    for I := 1 to Maxinstlength do U.Intarray[I] := 0;end;
    with U.Constval do
      new(Chars);
      Ival := MIN(fnamelen(Fnam), Strglgth);
      for I := 1 to Ival do Chars^.ss[I] := Fnam[I];end;
      U.Opc := Ucomm;
      U.Dtype := Mdt;
      uwrite(U);
      dispose(Chars);
    end;(*with*)
   (*procedure Ucofname*)end ucofname;

procedure stopucode;
begin
    uputkill;
    NoErrorsYet := false;
   (*procedure Stopucode*)end stopucode;

procedure ubittobyte(var U: Bcrec);
begin
  with U do
    if Opc in UopcodeSet{Ulod, Ustr, Unstr, Uisld, Uisst, 
    	       Upar, Upmov, Updef, Urpar, Umpmv,
	       Uadj,
	       Uveqv, Uvreg,
	       Uregs,
	       Urlda} then
      Offset := Offset div Bytesize;
      Length := Length div Bytesize;
      
    elsif Opc in UopcodeSet{Uilod, Uistr, Uildv, Uistv,
		    Urldc} then
      I1 := I1 div Bytesize;
      Length := Length div Bytesize;
      
    elsif Opc in UopcodeSet{Urlod, Urstr,
		    Ulda, Uilda} then
      Offset := Offset div Bytesize;
      Length := Length div Bytesize;
      Offset2 := Offset2 div Bytesize;
      
    elsif Opc = Uixa then
      I1 := I1 div Bytesize
    elsif Opc in UopcodeSet{Udef, Usdef,
		    Ulca, Uldc,
		    Umov,
		    Uiequ, Uineq, Uigeq, Uigrt, Uiles, Uileq,
		    Udif, Uinn, Uint, Umus, Uuni, Usgs} then
      Length := Length div Bytesize
    elsif Opc = Uinit then
      Offset := Offset div Bytesize;
      Length := Length div Bytesize;
      Offset2 := Offset2 div Bytesize;
      aryoff := aryoff div Bytesize;
      
    elsif Opc = Uoptn then
      if I1 = 1 (* UCO_VARARGS *) then
        Length := Length div Bytesize;end;
      end;end;
   (*Ubittobyte*)end ubittobyte;
$end
end Mipbwri.
