(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)

INTERFACE Code;

TYPE
  OpClass =
    {OpCrashCase, OpMoveCase, OpFrameCase, OpApplyCase, OpReturnCase,
     OpArgumentsCase, OpResultsCase, OpClosureCase, OpDumClosureCase,
     OpRecClosureCase, OpJumpCase, OpJumpWhenCase, OpStartCase, OpStopCase,
     OpEndCase, OpTupleCase, OpCaseCheckCase, OpCaseCase, OpCaseFaultCase,
     OpArrayCase, OpTrapCase, OpUntrapCase, OpRaiseCase, OpUnwindCase, OpNoOp,
     OpDataCompareCase, OpDataBoolCase, OpDataAsciiCase, OpDataIntCase, 
     OpDataRealCase, OpDataStringCase, OpDataArrayCase, OpDataReaderCase, 
     OpDataWriterCase, OpDataDynamicCase, OpDataTimeCase, OpDataValueCase, 
     OpDataMachineCase, OpDataStoreCase, OpDataOsCase,
     (* optimizations *)
     OpApplyArguments0Results1Case, OpApplyArguments1Results1Case,
     OpApplyArguments2Results1Case, OpApplyArgumentsResults1Case,
     OpResults1Case,
     (* -- obsolete; remove next cycle *)
     OpReturnObsoleteCase
     (* RPC:, OpDataRPCCase *)};

  OpJumpClass =
    {OpJumpAlwaysCase, OpJumpEqCase, OpJumpNotEqCase, OpJumpLessCase,
     OpJumpLessEqCase, OpJumpMoreCase, OpJumpMoreEqCase};

  OpAddrClass =
    {OpAddrImmedOkCase, OpAddrImmedBoolCase, OpAddrImmedCharCase,
     OpAddrImmedIntSmallCase, OpAddrImmedIntFullCase,
     OpAddrImmedRealCase, OpAddrLiteralSmallCase,
     OpAddrFrameSmallCase,
     OpAddrFrameLocativeSmallCase,
     OpAddrGlobalSmallCase, OpAddrIndexedSmallCase,
     OpAddrStackDisplCase, OpAddrSpecialCase};

  OpAddrSpecialClass =
    {OpAddrSpecialHomeCase, OpAddrSpecialStackCase,
     OpAddrSpecialPacketExcCase, OpAddrSpecialPacketValCase};
     
  OpDataCompareClass =
     {OpSameCase, OpOtherCase};
     
  OpDataBoolClass =
     {OpBoolNotCase, OpBoolAndCase, OpBoolOrCase};
     
  OpDataAsciiClass =
     {OpAsciiCharCase, OpAsciiValCase};
     
  OpDataIntClass =
     {OpIntPlusCase, OpIntDiffCase,
     OpIntMulCase, OpIntDivCase, OpIntModCase, OpIntLessCase, OpIntMoreCase,
     OpIntLessEqCase, OpIntMoreEqCase};
  
  OpDataRealClass =
     {OpRealIntCase, OpRealFloorCase,
     OpRealRoundCase, OpRealPlusCase, OpRealDiffCase, OpRealMulCase,
     OpRealDivCase, OpRealExpCase, OpRealLogCase, OpRealLessCase,
     OpRealMoreCase, OpRealLessEqCase, OpRealMoreEqCase};
     
  OpDataStringClass =
     {OpStringErrorCase,
     OpStringNewCase, OpStringIsEmptyCase, OpStringLengthCase,
     OpStringEqualCase, OpStringEqualSubCase, OpStringPrecedesCase,
     OpStringPrecedesSubCase, OpStringGetCharCase, OpStringSetCharCase,
     OpStringGetSubCase, OpStringSetSubCase, OpStringCatCase,
     OpStringCatSubCase, OpStringConcatCase};
     
  OpDataArrayClass =
     {OpArrayErrorCase, OpArrayNewCase,
     OpArraySizeCase, OpArrayGetCase, OpArraySetCase};
     
  OpDataReaderClass =
     {OpReaderErrorCase,
     OpReaderInputCase, OpReaderFileCase, OpReaderMoreCase, OpReaderReadyCase,
     OpReaderGetCharCase, OpReaderGetStringCase, OpReaderGetSubStringCase,
     OpReaderCloseCase};
     
  OpDataWriterClass =
     {OpWriterErrorCase, OpWriterOutputCase,
     OpWriterFileCase, OpWriterFlushCase, OpWriterPutCharCase,
     OpWriterPutStringCase, OpWriterPutSubStringCase, OpWriterCloseCase};
     
  OpDataDynamicClass =
     {OpDynamicErrorCase, OpDynamicNewCase, OpDynamicBeCase, OpDynamicCopyCase,
     OpDynamicInternCase, OpDynamicExternCase, OpDynamicInternPortableCase, 
     OpDynamicExternPortableCase};
     
  OpDataTimeClass =
     {OpTimeZeroCase, OpTimeNowCase,
     OpTimeSecondsCase, OpTimeMicrosecondsCase, OpTimeEqualCase,
     OpTimeBeforeCase, OpTimeAfterCase};
     
  OpDataValueClass =
     {OpValueNewCase (* -- replace by loophole *), 
      OpValueBeCase (* -- replace by loophole *), 
     OpValueFetchCase, OpValueStoreCase};
     
   OpDataMachineClass =
     {OpMachineExecCase,
     OpMachineResumeCase, OpMachineGotoCase, OpMachinePopFrameCase,
     OpMachineTraceCase, OpMachineTraceExcCase, OpMachineBreakCase,
     OpMachineBreakExcCase};
     
  OpDataStoreClass =
    {OpStoreErrorCase, OpStoreLoopholeCase,
     OpStoreAddressCase, OpStoreAtCase,
     OpStoreClearCase, OpStoreCopyCase,
     OpStoreGetByteCase, OpStoreSetByteCase,
     OpStoreGetShortCase, OpStoreSetShortCase,
     OpStoreGetLongCase, OpStoreSetLongCase,
     OpStoreGetRealCase, OpStoreSetRealCase};

(* --
    {OpStoreReadByteCase, OpStoreWriteByteCase, 
     OpStoreReadShortCase, OpStoreWriteShortCase,
     OpStoreReadLongCase, OpStoreWriteLongCase,
     OpStoreShortHiCase, OpStoreShortLoCase,
     OpStoreMakeShortCase, OpStoreLongHiCase,
     OpStoreLongLoCase, OpStoreMakeLongCase,
     OpStoreShortPlusCase, OpStoreShortMinusCase,
     OpStoreShortMultCase, OpStoreLongPlusCase,
     OpStoreLongMinusCase, OpStoreLongMultCase,
     OpStoreShortLessCase, OpStoreShortMoreCase,
     OpStoreShortLessEqCase, OpStoreShortMoreEqCase,
     OpStoreLongLessCase, OpStoreLongMoreCase,
     OpStoreLongLessEqCase, OpStoreLongMoreEqCase,
     OpStoreShortBitAndCase, OpStoreShortBitOrCase,
     OpStoreShortBitXorCase, OpStoreShortBitNotCase,
     OpStoreLongBitAndCase, OpStoreLongBitOrCase,
     OpStoreLongBitXorCase, OpStoreLongBitNotCase,
     OpStoreShortBitTestCase, OpStoreShortBitSetCase,
     OpStoreShortBitClearCase, OpStoreLongBitTestCase,
     OpStoreLongBitSetCase, OpStoreLongBitClearCase,
     OpStoreShortShiftCase, OpStoreShortRotateCase,
     OpStoreShortExtractCase, OpStoreShortInsertCase,
     OpStoreLongShiftCase, OpStoreLongRotateCase,
     OpStoreLongExtractCase, OpStoreLongInsertCase,
     OpStoreLoopholeCase, OpStoreZeroCase, OpStoreCopyCase};
*)

  OpDataOsClass =
     {OpOsErrorCase, OpOsChdirCase, OpOsWhereCase};

(* RPC:     
  OpDataRPCClass =
     {OpRPCErrorCase, OpRPCImportCase, OpRPCCloseCase, OpRPCInitCallCase,
     OpRPCSendCallCase, OpRPCEndCallCase, OpRPCExportCase,
     OpRPCGetRequestCase, OpRPCStartResponseCase, OpRPCEndResponseCase,
     OpRPCPutIntCase, OpRPCPutBoolCase, OpRPCPutCharCase, OpRPCPutStringCase,
     OpRPCPutDynamicCase, OpRPCPutLocalSpaceIdCase, OpRPCGetIntCase,
     OpRPCGetBoolCase, OpRPCGetCharCase, OpRPCGetStringCase,
     OpRPCGetDynamicCase};
*)

VAR
  (* arity is the number of addresses following an opcode, 
     i.e. number of inputs plus number of outputs *)
  dataCompareArity: ARRAY OpDataCompareClass OF INTEGER;
  dataBoolArity: ARRAY OpDataBoolClass OF INTEGER;
  dataAsciiArity: ARRAY OpDataAsciiClass OF INTEGER;
  dataIntArity: ARRAY OpDataIntClass OF INTEGER;
  dataRealArity: ARRAY OpDataRealClass OF INTEGER;
  dataStringArity: ARRAY OpDataStringClass OF INTEGER;
  dataArrayArity: ARRAY OpDataArrayClass OF INTEGER;
  dataReaderArity: ARRAY OpDataReaderClass OF INTEGER;
  dataWriterArity: ARRAY OpDataWriterClass OF INTEGER;
  dataDynamicArity: ARRAY OpDataDynamicClass OF INTEGER;
  dataTimeArity: ARRAY OpDataTimeClass OF INTEGER;
  dataValueArity: ARRAY OpDataValueClass OF INTEGER;
  dataMachineArity: ARRAY OpDataMachineClass OF INTEGER;
  dataStoreArity: ARRAY OpDataStoreClass OF INTEGER;
  dataOsArity: ARRAY OpDataOsClass OF INTEGER;
(* RPC:  dataRPCArity: ARRAY OpDataRPCClass OF INTEGER; *)

PROCEDURE Setup();

END Code.
