(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)

UNSAFE MODULE Data;
IMPORT Word;

PROCEDURE Setup() = BEGIN END Setup;

PROCEDURE Fault(msg: TEXT) =
  VAR i:INTEGER;
  BEGIN
    (* Cause a crash. *)
    i := i DIV (i-i);
  END Fault;

PROCEDURE IsRepresentableInt(l: Long): Bool =
  VAR i: Int;
  BEGIN
    i := LOOPHOLE(l, Int);
    RETURN (i >= FirstInt) AND (i <= LastInt); 
  END IsRepresentableInt;

PROCEDURE IsRepresentableFloat(l: Long): Bool =
  VAR r: Float;
  BEGIN
    r := LOOPHOLE(l, Float);
    RETURN (r >= FirstFloat) AND (r <= LastFloat); 
  END IsRepresentableFloat;

PROCEDURE IsSmallInt(i: Int): Bool =
  BEGIN 
    RETURN (i >= FirstSmallInt) AND (i <= LastSmallInt); 
  END IsSmallInt;

PROCEDURE IsImmediate(val: Polymorph): Bool =
  BEGIN RETURN Word.Mod(val,2)=1 END IsImmediate;

PROCEDURE IsPointer(val: Polymorph): Bool =
  BEGIN RETURN Word.Mod(val,2)=0 END IsPointer;

PROCEDURE ImmediateOfBool(bool: Bool): Immediate =
  BEGIN
    IF bool THEN
      RETURN TrueImmediate;
    ELSE
      RETURN FalseImmediate;
    END;
  END ImmediateOfBool;

PROCEDURE BoolOfImmediate(imm: Immediate): Bool =
  BEGIN
    IF imm = TrueImmediate THEN
      RETURN TRUE
    ELSIF imm = FalseImmediate THEN
      RETURN FALSE
    ELSE
      Fault("");
    END
  END BoolOfImmediate;

PROCEDURE ImmediateOfChar(char: Char): Immediate =
  BEGIN 
    RETURN 2*LOOPHOLE(ORD(char),Immediate)+1; 
  END ImmediateOfChar;

PROCEDURE CharOfImmediate(imm: Immediate): Char =
  BEGIN RETURN VAL(imm DIV 2, CHAR); END CharOfImmediate;

PROCEDURE ImmediateOfInt(int: Int): Immediate =
  BEGIN RETURN LOOPHOLE(2*int+1, Immediate); END ImmediateOfInt;

PROCEDURE IntOfImmediate(imm: Immediate): Int =
  BEGIN RETURN LOOPHOLE(imm-1, Int) DIV 2; END IntOfImmediate;

PROCEDURE ImmediateOfFloat(float: Float): Immediate =
  VAR i:Int; imm: Immediate;
  BEGIN
    i := LOOPHOLE(float, Int);
    i := 2*i+1;
    imm := LOOPHOLE(i, Immediate);
    RETURN imm;
(*    RETURN LOOPHOLE(2*LOOPHOLE(float, Int)+1, Immediate); *)
  END ImmediateOfFloat;

PROCEDURE FloatOfImmediate(imm: Immediate): Float =
  BEGIN 
    RETURN LOOPHOLE(LOOPHOLE(imm-1, Int) DIV 2, Float); 
  END FloatOfImmediate;

PROCEDURE AlignUp(pointer: Pointer; alignment: Card): Pointer =
  (* -- use a Word operation *)
  BEGIN
    RETURN ((pointer + (alignment - 1)) DIV alignment) * alignment;
  END AlignUp;

PROCEDURE AlignDown(pointer: Pointer; alignment: Card): Pointer =
  (* -- use a Word operation *)
  BEGIN RETURN (pointer DIV alignment) * alignment; END AlignDown;

(* 

PROCEDURE GetPointee(ptr: Pointer): Pointee =
  VAR addr: PointeePtr;
  BEGIN 
    addr := LOOPHOLE(ptr, PointeePtr);
    RETURN addr^; 
  END GetPointee;

PROCEDURE SetPointee(ptr: Pointer; pointee: Pointee) =
  VAR addr: PointeePtr;
  BEGIN 
    addr := LOOPHOLE(ptr, PointeePtr);
    addr^ := pointee;
  END SetPointee;

PROCEDURE GetPolymorph(ptr: Pointer): Polymorph =
  VAR addr: PolymorphPtr;
  BEGIN 
    addr := LOOPHOLE(ptr, PolymorphPtr); 
    RETURN addr^; 
  END GetPolymorph;

PROCEDURE SetPolymorph(ptr: Pointer; polymorph: Polymorph) =
  VAR addr: PolymorphPtr;
  BEGIN
    addr := LOOPHOLE(ptr, PolymorphPtr);
    addr^ := polymorph;
  END SetPolymorph;

PROCEDURE GetPointer(ptr: Pointer): Pointer =
  VAR addr: PointerPtr;
  BEGIN 
    addr := LOOPHOLE(ptr, PointerPtr); 
    RETURN addr^; 
  END GetPointer;

PROCEDURE SetPointer(ptr: Pointer; pointer: Pointer) =
  VAR addr: PointerPtr;
  BEGIN
    addr := LOOPHOLE(ptr, PointerPtr);
    addr^ := pointer;
  END SetPointer;

PROCEDURE GetImmediate(ptr: Pointer): Immediate =
  VAR addr: ImmediatePtr;
  BEGIN 
    addr := LOOPHOLE(ptr, ImmediatePtr); 
    RETURN addr^; 
  END GetImmediate;

PROCEDURE SetImmediate(ptr: Pointer; immediate: Immediate) =
  VAR addr: ImmediatePtr;
  BEGIN
    addr := LOOPHOLE(ptr, ImmediatePtr);
    addr^ := immediate;
  END SetImmediate;

PROCEDURE GetSmallCard(ptr: Pointer): SmallCard =
  VAR addr: SmallCardPtr;
  BEGIN 
    addr := LOOPHOLE(ptr, SmallCardPtr); 
    RETURN addr^; 
  END GetSmallCard;

PROCEDURE SetSmallCard(ptr: Pointer; smallCard: SmallCard) =
  VAR addr: SmallCardPtr;
  BEGIN
    addr := LOOPHOLE(ptr, SmallCardPtr);
    addr^ := smallCard;
  END SetSmallCard;

PROCEDURE GetSmallInt(ptr: Pointer): SmallInt =
  VAR addr: SmallIntPtr;
  BEGIN 
    addr := LOOPHOLE(ptr, SmallIntPtr); 
    RETURN addr^; 
  END GetSmallInt;

PROCEDURE SetSmallInt(ptr: Pointer; smallInt: SmallInt) =
  VAR addr: SmallIntPtr;
  BEGIN
    addr := LOOPHOLE(ptr, SmallIntPtr);
    addr^ := smallInt;
  END SetSmallInt;

PROCEDURE GetInt(ptr: Pointer): Int =
  VAR addr: IntPtr;
  BEGIN 
    addr := LOOPHOLE(ptr, IntPtr); 
    RETURN addr^; 
  END GetInt;

PROCEDURE SetInt(ptr: Pointer; int: Int) =
  VAR addr: IntPtr;
  BEGIN 
    addr := LOOPHOLE(ptr, IntPtr); 
    addr^ := int; 
  END SetInt;

PROCEDURE GetFloat(ptr: Pointer): Float =
  VAR addr: FloatPtr;
  BEGIN 
    addr := LOOPHOLE(ptr, FloatPtr); 
    RETURN addr^; 
  END GetFloat;

PROCEDURE SetFloat(ptr: Pointer; float: Float) =
  VAR addr: FloatPtr;
  BEGIN 
    addr := LOOPHOLE(ptr, FloatPtr); 
    addr^ := float; 
  END SetFloat;

PROCEDURE GetRelJump(ptr: Pointer): Int =
  BEGIN
    RETURN GetSmallInt(ptr);
  END GetRelJump;

PROCEDURE SetRelJump(ptr: Pointer; int: Int) =
  BEGIN
    IF (int < FirstSmallInt) OR (int > LastSmallInt) THEN
      Fault("SetRelJump");
    END;
    SetSmallInt(ptr, int);
  END SetRelJump;

*)

BEGIN
 IF (BITSIZE(Byte)#8)
 OR (BITSIZE(Short)#16)
 OR (BITSIZE(Long)#32)
 OR (BITSIZE(Float)#32)
 OR (BITSIZE(SmallInteger)#16)
 OR (BITSIZE(SmallCardinal)#16)
 OR (BITSIZE(Integer)#32)
 OR (BITSIZE(Cardinal)#32)
 THEN Fault("") END;
END Data.
