(* DIGITAL EQUIPMENT CORPORATION  CONFIDENTIAL AND PROPRIETARY *)
(* Last modified on Tue May 15 14:17:28 1990 by luca           *)
(* QOS implementation for Unix. *)

MODULE QOS;
IMPORT IO, unix, parameters;

TYPE
  ReaderRecord =
    RECORD
      file: IO.File;
      lookAheadReady: BOOLEAN;
      lookAheadByte: System.BYTE
    END;

  Reader = POINTER TO ReaderRecord;
  Writer = IO.File;

PROCEDURE TimeNow(VAR (*out*) seconds, microseconds: INTEGER);
  VAR time: INTEGER;
  BEGIN
    time := unix.time((*out*)seconds);
    microseconds := 0; (* -- *)
  END TimeNow;

PROCEDURE Id(VAR (*out*) cpu, process: INTEGER);
  BEGIN
    (* -- *)
    cpu := 0;
    process := 0;
  END Id;

PROCEDURE ChDir(
    VAR (*in*) name: ARRAY OF CHAR;
    start, length: INTEGER)
    : BOOLEAN;
  BEGIN
    (* -- not available
    TRY
      OSFriends.SetMyWD(NIL, Text.FromSub(name, start, length));
      RETURN TRUE;
    EXCEPT
    ELSE RETURN FALSE;
    END;
    *)
    RETURN FALSE;
  END ChDir;

PROCEDURE OpenRead(
    VAR (*in*) fileName: ARRAY OF CHAR;
    start, length: INTEGER;
    VAR (*out*) rd: Reader)
    : BOOLEAN;
  VAR cFileName: ARRAY [0..255] OF CHAR; i:INTEGER; file :IO.File;
  BEGIN
    FOR i := 0 TO length-1 DO
      cFileName[i] := fileName[start+i];
    END;
    cFileName[length] := CHR(0);
    file := IO.Open(cFileName,"r");
    IF file = NIL THEN RETURN FALSE
    ELSE
      NEW(rd);
      rd^.file := file;
      rd^.lookAheadReady := FALSE;
      RETURN TRUE;
   END;
  END OpenRead;

PROCEDURE OpenWrite(
    VAR (*in*) fileName: ARRAY OF CHAR;
    start, length: INTEGER;
    VAR (*out*) wr: Writer)
    : BOOLEAN;
  VAR cFileName: ARRAY [0..255] OF CHAR; i:INTEGER;
  BEGIN
    FOR i := 0 TO length-1 DO
      cFileName[i] := fileName[start+i];
    END;
    cFileName[length] := CHR(0);
    wr := IO.Open(cFileName,"w");
    RETURN wr#NIL;
  END OpenWrite;

PROCEDURE FileExists(
    VAR (*in*) fileName: ARRAY OF CHAR;
    start, length: INTEGER)
    : BOOLEAN;
  VAR cFileName: ARRAY [0..255] OF CHAR; i:INTEGER;
  VAR file: IO.file;
  BEGIN
    FOR i := 0 TO length-1 DO
      cFileName[i] := fileName[start+i];
    END;
    cFileName[length] := CHR(0);
    file := IO.Open(cFileName,"r");
    IF file=NIL THEN RETURN FALSE
    ELSE
      IO.Close(file);
      RETURN TRUE;
    END;
  END FileExists;

PROCEDURE FindAlongPath(
    VAR (*in*) path: ARRAY OF CHAR;
    pathStart, pathLength: INTEGER;
    dirSeparator, pathSeparator: CHAR;
    VAR (*in*) fileName: ARRAY OF CHAR;
    fileNameStart, fileNameLength: INTEGER;
    VAR (*out*) dirNameStart, dirNameLength: INTEGER)
    : BOOLEAN;
  VAR ch: CHAR; i: INTEGER;
    buff:ARRAY [0..255] OF CHAR;
  BEGIN
    IF pathLength = 0 THEN
      IF FileExists(fileName, fileNameStart, fileNameLength) THEN
        dirNameStart := 0;
        dirNameLength := 0;
        RETURN TRUE;
      ELSE
        RETURN FALSE;
      END;
    ELSE
      dirNameStart := pathStart;
      LOOP
        IF dirNameStart >= pathStart + pathLength THEN RETURN FALSE END;
        dirNameLength := 0;
        LOOP
          IF dirNameStart + dirNameLength >= pathStart + pathLength THEN
            EXIT
          END;
          IF path[dirNameStart + dirNameLength] = pathSeparator THEN EXIT END;
          INC(dirNameLength);
        END;
	FOR i := 0 TO dirNameLength-1 DO
	  buff[i] := path[i+dirNameStart];
	END;
	buff[dirNameLength] := dirSeparator;
	FOR i := 0 TO fileNameLength-1 DO
	  buff[i+dirNameLength+1] := fileName[i+fileNameStart]
	END;
	IF FileExists(buff, 0, dirNameLength+1+fileNameLength) THEN
	  RETURN TRUE;
	END;
        dirNameStart := dirNameStart + dirNameLength + 1;
      END;
    END;
  END FindAlongPath;

PROCEDURE Lookup(
    VAR (*in*) inBuff: ARRAY OF CHAR;
    inStart, inLength: INTEGER;
    VAR (*out*) outBuff: ARRAY OF CHAR;
    outStart, outMaxLength: INTEGER;
    VAR (*out*) outLength: INTEGER)
    : BOOLEAN;
  VAR name, buff: ARRAY [0..255] OF CHAR; i:INTEGER; ch:CHAR;
  BEGIN
    IF (inLength > 0) AND (inBuff[inStart] = '$') THEN
      ch := inBuff[inStart + 1];
      IF (inLength > 1) AND (ch>='0') AND (ch<='9') THEN
        parameters.GetParameter(
	  ORD(inBuff[inStart + 1]) - ORD('0'),
	  (*out*)buff, (*out*)outLength);
      ELSE
	FOR i:=0 TO inLength-2 DO
	  name[i] := inBuff[inStart+1+i];
	END;
	name[inLength-1] := CHR(0);
        parameters.GetEnvironment(name, (*out*)buff, (*out*)outLength);
      END;
    ELSE
      FOR i := 0 TO inLength-1 DO
        buff[i] := inBuff[inStart+i]
      END;
      outLength := inLength;
    END;
    IF outLength > outMaxLength THEN RETURN FALSE END;
    FOR i := 0 TO outLength-1 DO
      outBuff[outStart+i] := buff[i];
    END;
    RETURN TRUE;
  END Lookup;

PROCEDURE OutChar(wr: Writer; ch: CHAR);
  BEGIN IO.Writec(wr,ch); END OutChar;

PROCEDURE OutString(wr: Writer; string: ARRAY OF CHAR);
  VAR i:INTEGER;
  BEGIN
    FOR i:=0 TO HIGH(string) DO
      IO.Writec(wr,string[i]);
    END;
  END OutString;

PROCEDURE OutInt(wr: Writer; int: INTEGER);
  BEGIN
    IF int >= 0 THEN
      IO.Writef(wr, "%d", int);
    ELSE
      IO.Writef(wr, "~%d", -int);
    END;
  END OutInt;

PROCEDURE GetChar(rd: Reader; VAR (*out*) ch: CHAR): BOOLEAN;
  VAR buff: ARRAY [0..0] OF System.BYTE; num: INTEGER;
  BEGIN
    IF rd^.lookAheadReady THEN
      ch := CHAR(rd^.lookAheadByte);
      rd^.lookAheadReady := FALSE;
      RETURN TRUE;
    ELSE
      num := IO.Readb(rd^.file, buff, 1);
      ch := CHAR(buff[0]);
      RETURN num = 1;
    END;
  END GetChar;

PROCEDURE GetSub(
    rd: Reader;
    VAR (*out*) string: ARRAY OF CHAR;
    start, length: INTEGER;
    VAR (*out*) read: INTEGER)
    : BOOLEAN;
  VAR buff: ADDRESS; extra: INTEGER;
  BEGIN
    extra := 0;
    IF rd^.lookAheadReady AND (length>0) THEN
      string[start] := CHAR(rd^.lookAheadByte);
      rd^.lookAheadReady := FALSE;
      extra := 1;
    END;
    buff := ADR(string[0]);
    INC(buff, CARDINAL(start+extra));
    read := IO.Readb(rd^.file, buff^, length-extra) + extra;
    RETURN read = length;
  END GetSub;

PROCEDURE ReaderClose(rd: Reader): BOOLEAN;
  BEGIN
    IO.Close(rd^.file);
    RETURN TRUE;
  END ReaderClose;

PROCEDURE ReaderMore(rd: Reader; VAR (*out*) more: BOOLEAN): BOOLEAN;
  VAR buff: ARRAY [0..0] OF System.BYTE; num: INTEGER;
  BEGIN
    IF rd^.lookAheadReady THEN RETURN TRUE
    ELSE
      IF IO.Readb(rd^.file, buff, 1) = 1 THEN
	rd^.lookAheadReady := TRUE;
	rd^.lookAheadByte := buff[0];
	more := TRUE;
      ELSE
        more := FALSE;
      END;
      RETURN TRUE;
    END;
  END ReaderMore;

PROCEDURE ReaderReady(rd: Reader; VAR (*out*) ready: INTEGER): BOOLEAN;
  BEGIN
    IF rd^.lookAheadReady THEN ready := 1 ELSE ready := 0 END;
    RETURN TRUE;
  END ReaderReady;

PROCEDURE PutChar(wr: Writer; ch: CHAR): BOOLEAN;
  BEGIN
    IO.Writec(wr,ch);
    RETURN TRUE;
  END PutChar;

PROCEDURE PutSub(
    wr: Writer;
    VAR (*in*) string: ARRAY OF CHAR;
    start, length: INTEGER)
    : BOOLEAN;
  TYPE ArrayOfBytePtr = POINTER TO ARRAY [0..System.MaxInt] OF System.BYTE;
  VAR buff: ArrayOfBytePtr;
  BEGIN
    buff := ArrayOfBytePtr(system.Adr(string[0])+start);
    IO.Writeb(wr, buff^, length);
    RETURN TRUE;
  END PutSub;

PROCEDURE WriterClose(wr: Writer): BOOLEAN;
  BEGIN
    IO.Close(wr);
    RETURN TRUE;
  END WriterClose;

PROCEDURE WriterFlush(wr: Writer): BOOLEAN;
  BEGIN
    unix.fflush(wr);
    RETURN TRUE;
  END WriterFlush;

PROCEDURE Setup();
  BEGIN
    NEW(stdin);
    stdin^.file := io.input;
    stdin^.lookAheadReady := FALSE;
    stdout := io.output;
    newLine := '\n';
  END Setup;

END QOS.
