(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Mon Jun  4 01:32:11 1990 by luca           *)

interface Conv
export

  okay(): String
  (* Return the string "ok" *)

  bool(b: Bool): String
  (* Return "true" if b is true, "false" otherwise. *)

  int(n: Int): String
  (* Return a string representation of the integer n 
     (preceded by '~' if negative) *)

  real(r: Real):String
  (* Return a string representation of the real r
     (preceded by '~' if negative) *)

  char(c: Char): String
  (* Return a string containing the character c in single quotes,
     with backslash encoding for \n \b \t \f \\ \' \". *)

  string(s: String): String
  (* Return a string containing the string s in double quotes,
     with backslash encoding for \n \b \t \f \\ \' \". *)

end;


