(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Mon Jun  4 01:51:23 1990 by luca           *)

interface Exp
import :Msg ident:Ident :Op :Term
export

  (* Abstract syntax trees for program values, and their 
    allocation routines. *)

  Def AssessOpClass =
    Option optionIsCase optionAsCase optionOrdinalCase end

  Def Rec ValExp =
    Option
      with var where:Msg_Where end
      valExpNoneCase
      valExpIdeCase with var ide:ident.T end
      valExpAssignCase with assignee,assignand:ValExp end
      valExpOpCase with 
	  majOp:Op_MajOpClass minOp:Op_MinOpClass var opArgs:DefExp 
	end
      valExpBoolCase with bool:Bool end
      valExpIfCase with ifBranch,thenBranch,elseBranch:DefExp end
      valExpLoopCase with loopBlock:DefExp end
      valExpExitCase
      valExpCharCase with char:Char end
      valExpStringCase with string:String end
      valExpIntCase with int:Int end
      valExpRealCase with real:Real end
      valExpFunCase with
          funSpec:Term_SpecExp funRange:Term_TypExp funBody:ValExp
        end
      valExpApplCase with fn:ValExp var args:DefExp end
      valExpTupleCase with tup:DefExp end
      valExpProjectCase with
          projectVal:ValExp projectSel:String var projectIndex:Int
        end
      valExpOptionCase with
          optionSel:String optionDom:Term_TypExp 
	  optionDef:DefExp var optionIndex:Int
        end
      valExpAssessCase with
          assessOption:ValExp 
          assessOp:AssessOpClass
          assessSel:String 
          var assessIndex:Int
        end
      valExpCaseCase with
          caseVal:DefExp caseBranches:ValExpCaseBranch
          var casesNo:Int caseHasElse:Bool caseElse:DefExp 
        end
      valExpArrayCase with var items:DefExp end
      valExpBlockCase with block:DefExp end
      valExpExceptionCase with excIde:String excType:Term_TypExp end
      valExpRaiseCase
        with raiseExc:ValExp raiseVal:ValExp raiseAs:Term_TypExp end
      valExpTryCase with
          tryVal:DefExp tryBranches:ValExpTryBranch
          tryHasElse:Bool tryElse:DefExp tryElseRaiseAgain:Bool
        end
    end

  and SelList =
    Option
      nil
      cons with
	sel:String
	var index:Int
	rest:SelList
      end
    end

  and ValExpCaseBranch =
    Option
      nil
      cons with
        selList:SelList
        ide:ident.T
        body:DefExp
	var rest:ValExpCaseBranch
      end
    end

  and ValExpTryBranch =
    Option
      nil
      cons with
        exc:DefExp
        ide:ident.T
        type:Term_TypExp
        body:DefExp
	raiseAgain:Bool
	rest:ValExpTryBranch
      end
    end

  and DefExpVal =
    Option
      nil
      cons with
        ide:ident.T
        varIde:Bool
	  (* Whether this ide has Var type, i.e. produced by
	     either 'let var x = e' or 'var(e)'. *)
	locIde:Bool
	  (* Whether this ide has Loc type, i.e. produced by
	     either 'f(@e)', 'f(let var x = e)', or 'f(var(e))'. *)
        type:Term_TypExp
	var inferredType:Term_TypExp
        valueDef:ValExp
        hand:Op_Hand
	  (* How to evaluate this ValExp. LValue for '@e' ides. *)
	var where:Msg_Where
	rest:DefExpVal
      end
    end
(*
|    varIde  locIde  hand
|	F	F	R	"let a=3"
|	T	F	R	"var(3)"  "let var a=3"  "for i=3"
|	F	T	R	"f(var(3))"  "f(let var a=3)"
|	F	T	L	"f(@3)"
*)

  and DefExp =
    Option
      nil
      cons with first:DefExpItem var rest:DefExp end
    end

  and DefExpItem =
    Option
      defExpAbbrKndCase
	with kndAbbrDef:Term_DefExpKnd end
      defExpAbbrTypCase
	with recDefAbbr:Bool typAbbrDef:Term_DefExpTyp end
      defExpTypCase
	with recDef:Bool typLet:Term_DefExpTyp end
      defExpValCase
	with recVal:Bool valLet:DefExpVal end
    end

  optionIsCase, optionAsCase, optionOrdinalCase:AssessOpClass

  emptyValExp:ValExp
  newValExpIde(ide:ident.T where:Msg_Where):ValExp
  newValExpAssign(assignee,assignand:ValExp where:Msg_Where):ValExp
  newValExpOp(majOp:Op_MajOpClass minOp:Op_MinOpClass opArgs:DefExp 
    where:Msg_Where):ValExp
  newValExpBool(bool:Bool where:Msg_Where):ValExp
  newValExpIf(ifBranch,thenBranch,elseBranch:DefExp where:Msg_Where) 
    :ValExp
  newValExpLoop(loopBlock:DefExp where:Msg_Where):ValExp
  newValExpExit(where:Msg_Where):ValExp
  newValExpChar(char:Char where:Msg_Where):ValExp
  newValExpString(string:String where:Msg_Where):ValExp
  newValExpInt(int:Int where:Msg_Where):ValExp
  newValExpReal(real:Real where:Msg_Where):ValExp
  newValExpFun(funSpec:Term_SpecExp funRange:Term_TypExp
    funBody:ValExp where:Msg_Where):ValExp
  newValExpAppl(fn:ValExp args:DefExp where:Msg_Where):ValExp
  newValExpTuple(tup:DefExp where:Msg_Where):ValExp
  newValExpProject(projectVal:ValExp projectSel:String
    projectIndex:Int where:Msg_Where):ValExp
  newValExpOption(optionSel:String optionDom:Term_TypExp 
    optionDef:DefExp optionIndex:Int where:Msg_Where):ValExp
  newValExpAssess(assessOption:ValExp assessOp:AssessOpClass
    assessSel:String assessIndex:Int where:Msg_Where):ValExp 
  newValExpCase(caseVal:DefExp caseBranches:ValExpCaseBranch
    caseHasElse:Bool caseElse:DefExp where:Msg_Where):ValExp
  newValExpArray(items:DefExp where:Msg_Where):ValExp
  newValExpBlock(block:DefExp where:Msg_Where):ValExp
  newValExpException(excIde:String excType:Term_TypExp 
    where:Msg_Where):ValExp
  newValExpRaise(raiseExc,raiseVal:ValExp raiseAs:Term_TypExp 
    where:Msg_Where):ValExp
  newValExpTry(tryVal:DefExp tryBranches:ValExpTryBranch
    tryHasElse:Bool tryElse:DefExp tryElseRaiseAgain:Bool
    where:Msg_Where):ValExp

  okValExp, trueValExp, falseValExp:ValExp

  emptySelList:SelList
  newSelList(sel:String rest:SelList):SelList

  emptyValExpCaseBranch:ValExpCaseBranch
  newValExpCaseBranch(selList:SelList ide:ident.T
    body:DefExp rest:ValExpCaseBranch):ValExpCaseBranch

  emptyValExpTryBranch:ValExpTryBranch
  newValExpTryBranch(exc:DefExp ide:ident.T type:Term_TypExp
    body:DefExp raiseAgain:Bool rest:ValExpTryBranch):ValExpTryBranch

  emptyDefExpVal:DefExpVal
  newDefExpVal(ide:ident.T varIde, locIde:Bool type:Term_TypExp
    valueDef:ValExp hand:Op_Hand where:Msg_Where rest:DefExpVal) 
   :DefExpVal

  emptyDefExpList:DefExp
  newDefExpAbbrKndList(kndAbbrDef:Term_DefExpKnd
    rest:DefExp):DefExp
  newDefExpAbbrTypList(recDefAbbr:Bool typAbbrDef:Term_DefExpTyp 
    rest:DefExp):DefExp
  newDefExpTypList(recDef:Bool typLet:Term_DefExpTyp
    rest:DefExp):DefExp
  newDefExpValList(recVal:Bool valLet:DefExpVal
    rest:DefExp):DefExp

  anonDefExpKnd(kndExp:Term_KndExp where:Msg_Where):DefExp
  anonDefExpTyp(typExp:Term_TypExp kndExp:Term_KndExp where:Msg_Where)
   :DefExp
  anonDefExpVal(valExp:ValExp where:Msg_Where):DefExp
  anonDefExpKndList(kndExp:Term_KndExp where:Msg_Where 
    rest:DefExp):DefExp
  anonDefExpTypList(typExp:Term_TypExp kndExp:Term_KndExp where:Msg_Where 
    rest:DefExp):DefExp
  anonDefExpValList(valExp:ValExp where:Msg_Where rest:DefExp):DefExp

end;
