(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Mon Jun  4 06:52:43 1990 by luca           *)

interface Ext
import time :Time reader :Reader ident :Ident :Term :Top :Literal :Comp :ByteCode
export

  (* Read/write compiled modules and interfaces from/to files. *)

  Def ExtInterface = 
    Tuple
      ide :ident.T
      imports :Top_ImportList
      spec :Term_SpecExp
      isUnsound :Bool
      var version :Top_Version
    end
  (* The file structure of an interface (for ".spec.x" files). *)

  Def ExtModuleClass =
    Option
      symbolicCase with symbolicProg :Literal_Prog end
      executableCase with executableProg :ByteCode_Prog end
    end
  Def ExtModule =
    Tuple
      ide, interfaceName :ident.T
      imports :Top_ImportList
      class :ExtModuleClass
      isUnsound :Bool
      var version, interfaceVersion :Top_Version
    end
  (* The file structure of a module (for ".impl.x" files). 
     A symbolic module stores an instruction list (before assembly); 
     an executable module store a bytecode sequence (after assembly). 
     The normal situation is the latter. *)

  Def ModuleFormatClass =
    Option symbolicCase executableCase end

  Def Rec LoadedExtInterfaces =
    Option
      nil
      cons with
        extInterface :ExtInterface
        var flushed :Bool
        var rest :LoadedExtInterfaces
      end
    end
  (* A list of loaded interfaces. *)

  Def Rec LoadedExtModules =
    Option
      nil
      cons with
        extModule :ExtModule
	var info :Comp_ProgInfo
        var flushed :Bool
        var rest :LoadedExtModules
      end
    end
  (* A list of loaded modules and their info. *)

  state :
    Tuple 
       var searchPath :String
       var moduleFormatFlag :ModuleFormatClass
       var moduleSaveInfo :Bool
     end
  (* searchPath is the seach path for files.
     moduleFormatFlag is the flag to produce symbolic/executable modules.
     moduleSaveInfo determines whether ".info.x" files are created. *)

  moduleFormatSymbolic, moduleFormatExecutable :ModuleFormatClass

  newExtInterface(
    ide :ident.T
    imports :Top_ImportList
    spec :Term_SpecExp
    isUnsound :Bool)
    :ExtInterface
  (* Create an ExtInterface. *)

  newExtSymbolicModule(
    ide, interfaceName :ident.T
    imports :Top_ImportList
    symbolicProg :Literal_Prog
    isUnsound :Bool)
    :ExtModule
  (* Create a symbolic ExtModule. *)

  newExtExecutableModule(
    ide, interfaceName :ident.T
    imports :Top_ImportList
    executableProg :ByteCode_Prog
    isUnsound :Bool)
    :ExtModule
  (* Create an executable ExtModule. *)

  saveExtInterface(
    ide :ident.T
    imports :Top_ImportList
    spec :Term_SpecExp
    isUnsound :Bool) :Ok
  (* Collects and stores the version stamps of the imported 
     interfaces. Generates a version stamp for this interface. 
     Saves it to a ".spec.x" file. *)

  saveExtModule(
    ide, interfaceName :ident.T
    imports :Top_ImportList
    symbolicProg :Literal_Prog
    isUnsound :Bool
    moduleInfo :Comp_ProgInfo
    format :ModuleFormatClass) :Ok
  (* If format is ExecutableCase, invokes the assembler to obtain
     an executable module. Collects and stores the version stamps 
     of the imported interfaces. Generates a version stamp for
     this module. Saves the module code to a ".impl.x" file. Saves 
     the module info to a ".info.x" file ,if state.moduleSaveInfo. *)

  loaded :
    Tuple 
      var extInterfaces :LoadedExtInterfaces
      var extModules :LoadedExtModules
    end
  (* The pool of loaded interfaces and modules. *)

  openFile(fileName :String out outDirName :String) :reader.T
  (* Opens fileName, if found along state.searchPath, and returns
     the directory where it was found and a reader for it.
     Raises error if not found. *)

  loadExtInterface(ide :ident.T) :ExtInterface
  (* Loads an interface of given name from a file along state.searchPath.
     Raises error if not found. Checks the version stamps. *)

  fetchLoadedExtInterface(
    name :String
    scan :LoadedExtInterfaces
    out extInterface :ExtInterface)
    :Bool
  (* Fetches an interface by name from the loaded pool. Returns true if found. *)

  loadExtModule(
    ide :ident.T 
    out moduleInfo :Comp_ProgInfo) 
    :ExtModule
  (* Loads a module of given name from a file along state.searchPath. 
     Raises error if not found. Checks the version stamps and soundness.
     If the format of the loaded module is SymbolicCase, invokes the 
     assembler, so that in any case it produces an executable module. *)

  fetchLoadedExtModule( 
    name :String 
    scan :LoadedExtModules
    out extModule :ExtModule)
    :Bool
  (* Fetches a module by name from the loaded pool. Returns true if found. *)

  getExtInterface(ide :ident.T) :ExtInterface
  (* First tries fetchLoadedExtInterface from the loaded pool. 
     If not found, tries loadExtInterface. If found, adds it to the
     loaded pool and returns it. *)

  getExtModule(ide, interfaceName :ident.T) :ExtModule
  (* First tries fetchLoadedExtModule from the loaded pool. 
     If not found, tries loadExtModule. If found, adds it to the
     loaded pool and returns it. Checks it has the interface it claims *)

  getExtModuleInfo(
    name :String 
    scan :LoadedExtModules
    out info :Comp_ProgInfo)
    :Bool
  (* Searches a module in the loaded pool. If the associated module info is 
     present, it returns it, otherwise it loads it from file, stores it in 
     the pool and returns it. If something goes wrong returns false. *)

  checkExtModuleInterface(ide,interfaceName,claimedInterfaceName :ident.T) :Ok
  (* Gives an error if interfaceName is not the same as
     claimedInterfaceName for module ide. *)

  (* -- buildModules(imports :Top_ImportList) :Ok *)

end;


