(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Mon Jun  4 05:12:29 1990 by luca           *)

interface Fetch
import nester :Nester value :Value :Term :Exp subst :Subst envir :Envir
  :Comp :Literal :Machine :Code :ByteCode
export

  state :Tuple var printLimit:Int var hardListBreak:Bool end
  (* Print flags. *)

  uninitialized :value.T
  (* A value representing uninitialized locations. *)

  localFetch(addr :Code_OpAddr literals :Literal_TList stack :Machine_Stack
    fp :Int) :value.T
  (* Run a little program to fetch addr, which is either a literal address
     or a local stack address. *)

  machineFetch(addr :Code_OpAddr state :Machine_State) :value.T
  (* Run a little program to fetch addr in the given machine state.
     addr may be a global (i.e. closure) address. *)

  closureFetch(addr :Code_OpAddr clos :Machine_Closure) :value.T
  (* Run a little program to fetch a global addr from a closure. *)

  localIdeFetch(name:String locals :Comp_CompAddrList stack :Machine_Stack
      fp :Int out val :value.T out modif :Bool out typ:Term_TypExp) :Bool
  (* Run a little program to fetch a value by its identifier name in the 
     top stack frame. Obtain and return its info form locals. 
     Return true if found. *)

  globalIdeFetch(name :String globals :Comp_CompAddrList func :value.T
      out val :value.T out modif :Bool out typ :Term_TypExp) :Bool
  (* Run a little program to fetch a value by its identifier name in the 
     given closure. Obtain and return its info form globals.
     Return true if found. *)

  getProgInfo(badge: ByteCode_Badge) :Comp_ProgInfo
  (* Get the program info given a program badge. *)

  getCurrentProgBadge(machineState :Machine_State) :ByteCode_Badge
  (* Get the badge of the current closure in a machine state. *)

  getCurrentProgInfo(machineState :Machine_State) :Comp_ProgInfo
  (* getProgInfo(getCurrentProgBadge(machineState)). *)

  getClosureBadge(clos :value.T) :ByteCode_Badge
  (* Get the badge of a closure (its literal 0). *)

  getClosureProgInfo(clos :value.T) :Comp_ProgInfo
  (* getProgInfo(getClosureBadge(clos)). *)

  fetchFrameLocal(name :String machineState :Machine_State out val :value.T
      out modif :Bool out typ :Term_TypExp) :Bool
  (* Do a localIdeFetch on the first frame of the given machine state.
     Return true if found. *)

  fetchFramesLocal(name :String machineState :Machine_State out val :value.T
    out modif :Bool out typ :Term_TypExp) :Bool
  (* Do a localIdeFetch on all the frames of the given machine state,
     until name is found or the frames are exhausted. Return true if found. *)

  printVal(wr: nester.T val: value.T typ: Term_TypExp env: envir.T limit: Int): Ok
  (* Print a value according to its type. *)

  printStack(wr :nester.T def :Exp_DefExp defSub :subst.T 
      env :envir.T local :Comp_CompLocal literals :Literal_TList 
      stack :Machine_Stack fp :Int) :Ok
  (* Print the values defined in def and found on the given
     literals or stack, according to their types. 
     This is the main top-level print routine. *)

end;
