(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Mon Jun  4 01:51:24 1990 by luca           *)

interface Include
import
  :Term :Exp envir:Envir subst:Subst
export

  Def Variance = 
    Option varianceRigid varianceCo varianceContra end
  (* Rigid = same items matching; Co = covariant matching;
     Contra = contravariant matching. *)

  state:Tuple var traceOn:Bool end
  (* Enable trace (for debugging) *)

  varianceRigid,varianceCo,varianceContra:Variance
  (* The three variances. *)

  resetTrail():Ok
  (* Clear the memory trails used for (recursive) matching. 
     Current heuristic: done once per module. *)

  kndExp(knd1,knd2:Term_KndExp env:envir.T eq:Bool):Ok
  (* Check inclusion of two kinds. *)

  typExp(typ1,typ2:Term_TypExp env:envir.T eq:Bool):Ok
  (* Check inclusion of two types. *)

  specExp(spec1,spec2:Term_SpecExp variance:Variance env:envir.T eq:Bool):Ok
  (* Check inclusion of two specs with given variance. 
     If eq is true check for double inclusion (forces variance=Rigid) *)

  defSpecExp(defSub:subst.T defSpec,spec:Term_SpecExp env:envir.T):subst.T
  (* Check inclusion of two specs knowing that the first one
   was derived from a def. The result substitution contains the
   type identifiers introduced by spec bound to the types associated to the
   corresponding type identifiers of defSub (not defSpec!). *)

  fetchTypPathKnd(path:Term_TypExpPath env:envir.T):Term_KndExp
  (* Fetch a kind following an identifier path. *)

end;


