(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Mon Jun  4 02:02:38 1990 by luca           *)

interface InferTerm
import :Term envir:Envir subst:Subst
export

  kndExp(knd:Term_KndExp sub:subst.T env:envir.T 
    out redKnd:Term_KndExp):Ok
  (* Given a KndExp, check that it is well formed, and compute its 
     normal form. *)

  typExp(
    typ:Term_TypExp
    sub:subst.T
    env:envir.T
    out redTyp:Term_TypExp)
    :Term_KndExp
  (* Given a TypExp, infer its KndExp and the compute its normal form. *)

  specExp(spec:Term_SpecExp sub:subst.T env:envir.T
    out redSpec:Term_SpecExp):Ok
  (* Given a SpecExp, check that it is well formed and return its
     normal form. *)

  specExtend(
    spec:Term_SpecExp
    sub:subst.T out outSub:subst.T
    env:envir.T out outEnv:envir.T
    out redSpec:Term_SpecExp)
    :Ok
  (* As above, but also produce the extended subst and envir. *)

  defExpKndAbbr(
    kndDef:Term_DefExpKnd
    inSpec:Bool
    defSub:subst.T out outDefSub:subst.T
    defKndSub:subst.T
    extSub:subst.T out outExtSub:subst.T
    env:envir.T)
    :Term_SpecExp
(*
| (... ... ... (DEF X=K, ... , Y=L) ... ... ...)
| ^defSub      ^defKndSub      ...^extSub
|
| - defSub is the substitution of the total outside signature or
| binding; it is enriched by abbreviations because these must
| always expand.
| - defKndSub is the substitution outside this kndDef (=defSub if inSpec);
| it is maintained because a kndDef is a parallel definition
| - extSub is the final substitution of the total outside
| signature or binding; it is enriched by all the abbreviations.
|
| It flattens the kndDef for uniformity with DefTyp.
*)
 
  defExpTyp(
    recTyp,abbr:Bool
    defTyp:Term_DefExpTyp
    defSub,defTypSub:subst.T
    extSub:subst.T out outExtSub:subst.T
    extEnv:envir.T out outExtEnv:envir.T
    out resDefTyp:Term_DefExpTyp
    skipFunSpec:Term_SpecExp out outSkipFunSpec:Term_SpecExp)
    :Term_SpecExp
(*
| (... ... ... (Let/Def X=K, ... , Y=L) ... ... ...)
| ^defSub      ^defTypSub          ...^extSub
|
| - defSub is the substitution of the total outside signature or
| binding; it is enriched by abbreviations (only) because these must
| always expand.
| - defTypSub (initially =extSub) (also, =defSub if inSpec) is the
| substitution outside this typDef; it is maintained because a typDef
| is a parallel definition.
| - extSub is the final substitution of the total outside
| signature or binding; it is enriched by all the variables.
|
| Unlike the similar code in Reduce.mod, this procedure needs
| both defSub and defTypSub because it is used both in signatures
| (where defSub=defTypSub) and bindings.
| then it must return a flattened out spec.
*)

  state:Tuple var traceOn:Bool end

end;
