(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Mon Jun  4 02:17:40 1990 by luca           *)

interface List
export

  T::ALL(::TYPE)TYPE
  (* Polymorphic list operator. *)

  error:Exception(Ok)
  (* Raised when an operation cannot be carried out. *)

  nil(A::TYPE):T(A)
  (* Polymorphic nil. *)

  cons(A::TYPE :A :T(A)):T(A)
  (* Polymorphic cons. *)

  null(A::TYPE :T(A)):Bool
  (* Whether a polymorphic list is empty. *)

  head(A::TYPE :T(A)):A
  (* Head of a polymorphic list. *)

  tail(A::TYPE :T(A)):T(A)
  (* Tail of a polymorphic list. *)

  length(A::TYPE :T(A)):Int
  (* Length of a polymorphic list. *)

  enum(A::TYPE a:Array(A)):T(A)
  (* Convert a polymorphic array into a polymorphic list. 
     Usage: "list.enum of 1 2 3 4 end" or "list.enum of(5 true)" *)

end;
