(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Sun Aug 20 18:47:01 1989 by luca           *)

interface Msg
import nester:Nester
export

  Def Where = Tuple fileName:String begPos,endPos:Int end
  (* A program source location. fileName="" means the top-level. *)

  output:nester.T
  (* The output stream. *)

  fail:Exception(Ok)
  (* A generic error exception, caused by an incorrect input program. *)

  bomb:Exception(Ok)
  (* An internal error. *)

  say(m:String):Ok
  (* Print a warning message. *)

  fault(T::TYPE m:String):T
  (* Print a message and raise fail. *)

  newWhere(fileName:String begPos,endPos:Int):Where
  (* Make a new location. *)

  setWhere(where:Where fileName:String begPos,endPos:Int):Where
  (* If where is noWhere, return a new location with begPos and endPos,
     else return where. *)

  globalWhere:Where
  (* A location for global entities. *)

  noWhere:Where
  (* No location (negative begPos and endPos). *)

  isNoWhere(where:Where):Bool
  (* Whether this location is no location. *)

  printWhere(where:Where):Ok
  (* Print a location. *)

  setContext(where:Where):Ok
  (* Set a context for error messages. *)

  printContext():Ok
  (* Print an error context. *)

end;
