(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Mon Jun  4 03:16:46 1990 by luca           *)
interface Op
export

  (* Quest Machine opcodes. *)

  (* Must match Code.i3. *)

  Def Hand = 
    Option rValue lValue end

  rValue, lValue: Hand

  Def MajOpClass = Int
  and MinOpClass = Int
  Def OpAddrClass = Int
  and OpAddrSpecialClass = Int
  Def OpJumpClass = Int

  (* opClass *)
     opCrashCase, opMoveCase, opFrameCase, opApplyCase, opReturnCase,
     opArgumentsCase, opResultsCase, opClosureCase, opDumClosureCase,
     opRecClosureCase, opJumpCase, opJumpWhenCase, opStartCase, opStopCase,
     opEndCase, opTupleCase, opCaseCheckCase, opCaseCase, opCaseFaultCase,
     opArrayCase, opTrapCase, opUntrapCase, opRaiseCase, opUnwindCase, opNoOp,
     opDataCompareCase, opDataBoolCase, opDataAsciiCase, opDataIntCase, 
     opDataRealCase, opDataStringCase, opDataArrayCase, opDataReaderCase, 
     opDataWriterCase, opDataDynamicCase, opDataTimeCase, opDataValueCase, 
     opDataMachineCase, opDataStoreCase, opDataOsCase,
     (* optimizations *)
     opApplyArguments0Results1Case, opApplyArguments1Results1Case,
     opApplyArguments2Results1Case, opApplyArgumentsResults1Case,
     opResults1Case
     (* RPC: opDataRPCCase *)
     : MajOpClass

  (* opDataCompareClass *)
      opSameCase, opOtherCase: MinOpClass
     
  (* opDataBoolClass *)
      opBoolNotCase, opBoolAndCase, opBoolOrCase: MinOpClass
     
  (* opDataAsciiClass *)
      opAsciiCharCase, opAsciiValCase: MinOpClass
     
  (* opDataIntClass *)
     opIntPlusCase, opIntDiffCase, opIntMulCase, opIntDivCase, opIntModCase, 
     opIntLessCase, opIntMoreCase, opIntLessEqCase, opIntMoreEqCase
     : MinOpClass
  
  (* opDataRealClass *)
     opRealIntCase, opRealFloorCase,
     opRealRoundCase, opRealPlusCase, opRealDiffCase, opRealMulCase,
     opRealDivCase, opRealExpCase, opRealLogCase, opRealLessCase,
     opRealMoreCase, opRealLessEqCase, opRealMoreEqCase
     : MinOpClass
     
  (* opDataStringClass *)
     opStringErrorCase, opStringNewCase, opStringIsEmptyCase, 
     opStringLengthCase, opStringEqualCase, opStringEqualSubCase, 
     opStringPrecedesCase, opStringPrecedesSubCase, opStringGetCharCase, 
     opStringSetCharCase, opStringGetSubCase, opStringSetSubCase, 
     opStringCatCase, opStringCatSubCase, opStringConcatCase
     : MinOpClass
     
  (* opDataArrayClass *)
     opArrayErrorCase, opArrayNewCase, opArrayExtentCase, opArrayGetCase, 
     opArraySetCase: MinOpClass
     
  (* opDataReaderClass *)
     opReaderErrorCase, opReaderInputCase, opReaderFileCase, opReaderMoreCase, 
     opReaderReadyCase, opReaderGetCharCase, opReaderGetStringCase, 
     opReaderGetSubStringCase, opReaderCloseCase: MinOpClass
     
  (* opDataWriterClass *)
     opWriterErrorCase, opWriterOutputCase, opWriterFileCase, 
     opWriterFlushCase, opWriterPutCharCase, opWriterPutStringCase, 
     opWriterPutSubStringCase, opWriterCloseCase: MinOpClass
     
  (* opDataDynamicClass *)
     opDynamicErrorCase, opDynamicNewCase, opDynamicBeCase, opDynamicCopyCase,
     opDynamicInternCase, opDynamicExternCase, opDynamicInternPortableCase, 
     opDynamicExternPortableCase: MinOpClass
     
  (* opDataTimeClass *)
     opTimeZeroCase, opTimeNowCase, opTimeSecondsCase, opTimeMicrosecondsCase, 
     opTimeEqualCase, opTimeBeforeCase, opTimeAfterCase: MinOpClass
     
  (* opDataValueClass *)
     opValueNewCase, opValueBeCase,
     opValueFetchCase, opValueStoreCase
     : MinOpClass
     
  (* opDataMachineClass *)
     opMachineExecCase, opMachineResumeCase, opMachineGotoCase, 
     opMachinePopFrameCase, opMachineTraceCase, opMachineTraceExcCase, 
     opMachineBreakCase, opMachineBreakExcCase
     : MinOpClass

  (* opDataStoreClass *)
     opStoreErrorCase, opStoreLoopholeCase,
     opStoreAddressCase, opStoreAtCase,
     opStoreClearCase, opStoreCopyCase,
     opStoreGetByteCase, opStoreSetByteCase,
     opStoreGetShortCase, opStoreSetShortCase,
     opStoreGetLongCase, opStoreSetLongCase,
     opStoreGetRealCase, opStoreSetRealCase
     : MinOpClass

  (* --  opStoreReadByteCase, opStoreWriteByteCase, 
     opStoreReadShortCase, opStoreWriteShortCase,
     opStoreReadLongCase, opStoreWriteLongCase,
     opStoreShortHiCase, opStoreShortLoCase,
     opStoreMakeShortCase, opStoreLongHiCase,
     opStoreLongLoCase, opStoreMakeLongCase,
     opStoreShortPlusCase, opStoreShortDiffCase,
     opStoreShortMultCase, opStoreLongPlusCase,
     opStoreLongDiffCase, opStoreLongMultCase,
     opStoreShortLessCase, opStoreShortMoreCase,
     opStoreShortLessEqCase, opStoreShortMoreEqCase,
     opStoreLongLessCase, opStoreLongMoreCase,
     opStoreLongLessEqCase, opStoreLongMoreEqCase,
     opStoreShortBitAndCase, opStoreShortBitOrCase,
     opStoreShortBitXorCase, opStoreShortBitNotCase,
     opStoreLongBitAndCase, opStoreLongBitOrCase,
     opStoreLongBitXorCase, opStoreLongBitNotCase,
     opStoreShortBitTestCase, opStoreShortBitSetCase,
     opStoreShortBitClearCase, opStoreLongBitTestCase,
     opStoreLongBitSetCase, opStoreLongBitClearCase,
     opStoreShortShiftCase, opStoreShortRotateCase,
     opStoreShortExtractCase, opStoreShortInsertCase,
     opStoreLongShiftCase, opStoreLongRotateCase,
     opStoreLongExtractCase, opStoreLongInsertCase
     opStoreLoopholeCase, opStoreZeroCase, opStoreCopyCase
     : MinOpClass
  *)
         
  (* opDataOsClass *)
     opOsErrorCase, opOsChdirCase, opOsWhereCase: MinOpClass

  (* RPC: 
  (* opDataRPCClass *)
     opRPCErrorCase, opRPCImportCase, opRPCCloseCase, opRPCInitCallCase,
     opRPCSendCallCase, opRPCEndCallCase, opRPCExportCase,
     opRPCGetRequestCase, opRPCStartResponseCase, opRPCEndResponseCase,
     opRPCPutIntCase, opRPCPutBoolCase, opRPCPutCharCase, opRPCPutStringCase,
     opRPCPutDynamicCase, opRPCPutLocalSpaceIdCase, opRPCGetIntCase,
     opRPCGetBoolCase, opRPCGetCharCase, opRPCGetStringCase,
     opRPCGetDynamicCase: MinOpClass
  *)

  (* opAddrClass *)
  opAddrImmedOkCase, opAddrImmedBoolCase, opAddrImmedCharCase,
  opAddrImmedIntSmallCase, opAddrImmedIntFullCase, 
  opAddrImmedRealCase, opAddrLiteralSmallCase,
  opAddrFrameSmallCase, opAddrFrameLocativeSmallCase,
  opAddrGlobalSmallCase, opAddrIndexedSmallCase,
  opAddrStackDisplCase, opAddrSpecialCase :OpAddrClass

  (* opAddrSpecialClass *)
  opAddrSpecialHomeCase, opAddrSpecialStackCase,
  opAddrSpecialPacketExcCase, opAddrSpecialPacketValCase
  : OpAddrSpecialClass

  (* opJumpClass *)
  opJumpAlwaysCase, opJumpEqCase, opJumpNotEqCase,
  opJumpLessCase, opJumpLessEqCase, opJumpMoreCase,
  opJumpMoreEqCase :OpJumpClass

end;

