(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Mon Jun  4 04:35:30 1990 by luca           *)

interface PrintTerm
import nester:Nester ident:Ident :Term
export

  kndExp(wr:nester.T knd:Term_KndExp depth:Int):Ok
  (* Print a KndExp. *)

  typExp(wr:nester.T typ:Term_TypExp depth:Int):Ok
  (* Print a TypExp. *)

  specExp(wr:nester.T spec:Term_SpecExp indent,depth:Int):Ok
  (* Print a SpecExp. *)

  defKndExp(wr:nester.T defKnd:Term_DefExpKnd depth:Int):Ok
  (* Print a DefExpKnd. *)

  defTypExp(wr:nester.T defTyp:Term_DefExpTyp depth:Int):Ok
  (* Print a DefExpTyp. *)

  (* Depth is how many levels of non-anonimous named entities
     are expanded; normally 0 or 1 when called from the top level.
     In a declaration "Let X::K=A", the depth of K is
     one less than the depth of A; in "let x:A=a" the depth of
     A is one less than the current value. *)

end;
