(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Mon Jun  4 04:48:14 1990 by luca           *)

interface RealOp
export

  (* Operations on reals. *)

  zero,one,ten,hundred,thousand,million: Real
  (* 0.0, 1.0, 10.0, 100.0, 1000.0, 1000000.0; 
     make the compiler easier to port *)

  minReal,maxReal: Real
  (* The most negative and most positive representable reals. *)

  negEpsilon,posEpsilon: Real
  (* The most positive representable negative real, and the most negative
     representable positive real. *)

  e: Real
  (* e. *)

  int(n: Int): Real
  (* Make n into a real. *)

  floor,round(r: Real): Int
  (* Floor and round. *)

  plus,diff,mul,div,exp(r,s: Real): Real
  (* Basic arith. *)

  abs,log(r: Real): Real
  (* Abs and log base e. *)

  min,max(r,s: Real): Real
  (* Min and max. *)

  smaller,greater,smallerEq,greaterEq(r,s: Real): Bool
  (* Basic comparisons. *)

end;
