(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Sun Aug 20 18:47:05 1989 by luca           *)

interface Reduce
import 
  ident:Ident :Term subst:Subst envir:Envir :Op
export

  kndExp(knd:Term_KndExp sub:subst.T):Term_KndExp
  (* Reduce a KndExp to normal form. 
     (But external manifests are left unexpanded.) *)

  typExp(typ:Term_TypExp sub:subst.T):Term_TypExp
  (* Reduce a TypExp to betanormal form. 
     (But exteral manifests are left unexpanded. *)

  typExpPath(path:Term_TypExpPath sub:subst.T):Term_TypExpPath
  (* -- *)

  specExp(spec:Term_SpecExp sub:subst.T out outSub:subst.T):Term_SpecExp
  (* -- *)

  defExpKnd(defKnd:Term_DefExpKnd sub:subst.T
    extSub:subst.T out outExtSub:subst.T):Term_DefExpKnd
  (* -- *)

  defExpTyp(recDef:Bool defTyp:Term_DefExpTyp
    sub:subst.T out outSub:subst.T):Term_DefExpTyp
  (* -- *)

  bind(spec:Term_SpecExp args:Term_TypExpList):subst.T
  (* -- *)

  testPowerKind(
    knd:Term_KndExp
    out baseTyp:Term_TypExp)
    :Bool
  (* Return true if the kind is a power kind, in which case baseTyp 
     is its base type. *)

  testOutType(
    typ:Term_TypExp
    out argTyp:Term_TypExp)
   :Bool
  (* Return true if typ rec-reduces to an Out type, in which case argTyp
   is the modif type argument. *)

  testVarType(
    typ:Term_TypExp
    out argTyp:Term_TypExp)
   :Bool
  (* Return true if typ rec-reduces to a Var type, in which case argTyp
   is the modif type argument. *)

  testModifType(
    typ:Term_TypExp
    out argTyp:Term_TypExp)
   :Bool
  (* Return true if typ rec-reduces to a Var or Loc type, in which case argTyp
   is the modif type argument. *)

  testArrayType(
    typ:Term_TypExp
    out argTyp:Term_TypExp)
   :Bool
  (* Return true if typ rec-reduces to an array type, in which case argTyp is
     the array type argument. *)

  testExceptionType(
    typ:Term_TypExp
    out argTyp:Term_TypExp)
   :Bool
  (* Return true if typ rec-reduces to an exception type, in which case argTyp
     is the exception type argument. *)

  scrapeKnd(knd:Term_KndExp):Term_KndExp
  (* Expand type abbreviations and named types until something solid is 
     obtained *)

  scrapeKndAbbr(knd:Term_KndExp):Term_KndExp
  (* -- *)

  scrapeTyp(typ:Term_TypExp):Term_TypExp
  (* Expand rec variables, type abbreviations and named types until something
     solid is obtained *)

  scrapeTypAbbr(typ:Term_TypExp):Term_TypExp
  (* -- *)

  fetchSpecKnd(
    spec:Term_SpecExp
    hasPrefixPath:Bool
    prefixPath:Term_TypExpPath
    sel:String
    out resKnd:Term_KndExp
    out index:Int)
   :Bool
  (* Return the kind and serial position of a type field of name "sel" in a
     spec. Reaname internal type variables by prefixing the prefixPath. *)

  fetchSpecTyp(
    spec:Term_SpecExp
    hasPrefixPath:Bool
    prefixPath:Term_TypExpPath
    sel:String
    hand:Op_Hand
    out specIde:ident.T
    out resTyp:Term_TypExp
    out index:Int)
   :Bool
(* Return the type and serial position of a value field of name "sel" in a
   spec. Reaname internal type variables by prefixing the prefixPath
   (hasPrefixPath is false if internal type variables are forbidden, 
    e.g. when the selectee is a complex expression i.e. not a path) *)

  fetchSimpleSpecTyp(
    spec:Term_SpecExp
    sel:String
    hand:Op_Hand
    out resTyp:Term_TypExp
    out index:Int)
   :Bool
  (* Simpler version of FetchSpecTyp for non-dependent specs. *)

  blockTyp(spec:Term_SpecExp):Term_TypExp
  (* Fetch the type of the last item of a block. Check that the last item is a
     value and that its type does not contain local variables of the block. *)

  rangeTyp(spec:Term_SpecExp typ:Term_TypExp):Ok
  (* Check that the range type of a function (typ) does not contain any of the
     value parameter variables (from spec) *)

  selectAbbrKnd(abbrTyp:Term_TypExp sel:String):Term_KndExp
  (* -- *)

  selectAbbrTyp(abbrTyp:Term_TypExp sel:String
    out knd:Term_KndExp):Term_TypExp
  (* -- *)

  fetchTypAbbr(typ:Term_TypExp):Term_TypExp
  (* If typ is an external-interface abbreviation, returns its definition. *)

  fetchNthTyp(
    fieldNo:Int
    spec:Term_SpecExp
    hand:Op_Hand
    out resTyp:Term_TypExp
    out sel:String)
   :Bool
  (* -- *)

  contractive(typ:Term_TypExp ide:ident.T sub:subst.T):Ok
  (* Check whether typ is contractive in ide. It assumes any internal 
     recursive types in typ have already been tested for contractiveness. 
     The sub should be empty (used to terminate recursive chasing). *)

end;

