(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Sun Aug 20 18:47:07 1989 by luca           *)

interface Subst
import ident:Ident :Term
export

(* A Subst.T is a mapping of either a kind identifier to a kind, a type
   identifier to a type, or a value identifier to a selection path. Kinds and
   types are in normal form. *)

  T::TYPE

  var topSub:T

  empty:T

  consBarren(barrenIde:ident.T why:String rest:T):T

  consKnd(kndIde:ident.T knd:Term_KndExp rest:T):T

  consTyp(typIde:ident.T typ:Term_TypExp rest:T):T

  consTypPath(valIde:ident.T path:Term_TypExpPath rest:T):T

  consKndDef(defKnd:Term_DefExpKnd rest:T):T

  consTypDef(defTyp:Term_DefExpTyp rest:T):T

  isEmpty(sub:T):Bool

  skipSpecAbbr(spec:Term_SpecExp):Term_SpecExp

  getKnd(kndIde:ident.T sub:T out defKnd:Term_KndExp):Bool

  getTyp(typIde:ident.T sub:T out defTyp:Term_TypExp):Bool

  getTypPath(valIde:ident.T sub:T out path:Term_TypExpPath):Bool

  bindsFreeVars(freeVars:Term_FreeVars sub:T):Bool
  (* Whether any of the free variables are bound by the substitution. *)

end;
