(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Mon Jun  4 05:44:18 1990 by luca           *)

interface Top
import time:Time ident:Ident :Term :Exp
export

  (* Abstract syntax trees for top-level phrases, and their
    allocation routines. *)

  Def Version = time.T

  Def Rec ImportList =
    Option
      nil
      cons with
        ide,interfaceName:ident.T
        var interfaceVersion:Version
	rest:ImportList
      end
    end

  Def Phrase =
    Option
      phraseEmptyCase
      phraseInterfaceCase
	with
          interfaceName:ident.T
          interfaceImports:ImportList
          interfaceSpec:Term_SpecExp
	  interfaceUnsound:Bool
	end
      phraseModuleCase
	with
          moduleName:ident.T
          moduleInterfaceName:ident.T
          moduleImports:ImportList
          moduleBody:Exp_DefExp
          moduleUnsound:Bool
	end
      phraseLinkageCase with linkageImports:ImportList openIt:Bool end
      (* -- Build *)
      phraseDefinitionCase with def:Exp_DefExp end
      phraseLoadCase with loadString:String end
      phraseCommandCase with commandString:String def:Exp_DefExp end
    end

  emptyImportList:ImportList
  newImportList(
    ide,interfaceName:ident.T 
    rest:ImportList)
   :ImportList

  phraseEmpty:Phrase
  newPhraseInterface(
    interfaceName:ident.T
    interfaceImports:ImportList
    interfaceSpec:Term_SpecExp
    interfaceUnsound:Bool)
   :Phrase
  newPhraseModule(
    moduleName:ident.T
    moduleInterfaceName:ident.T
    moduleImports:ImportList
    moduleBody:Exp_DefExp
    moduleUnsound:Bool)
   :Phrase
  newPhraseLinkage(linkageImports:ImportList openIt:Bool):Phrase
  newPhraseDefinition(def:Exp_DefExp):Phrase
  newPhraseLoad(loadString:String):Phrase
  newPhraseCommand(commandString:String def:Exp_DefExp):Phrase

end;
