(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Sun Aug 20 18:46:48 1989 by luca           *)

interface ArrayOp

export

  error :Exception(Ok)
    (* Raised when any of the following operation cannot be carried out. *)

  new(A ::TYPE size :Int init :A) :Array(A)
    (* Create a new array of given size, all initialized to init. *)

  size(A ::TYPE arr :Array(A)) :Int
    (* Return the size of an array *)

  get(A ::TYPE arr :Array(A) index :Int) :A
    (* Extract an array element, same as "arr[index]". *)

  set(A ::TYPE arr :Array(A) index :Int item :A) :Ok
    (* Update an array element, same as "arr[index] := item". *)

end;
