(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Mon Jun  4 04:38:40 1990 by luca           *)

interface Reader
export

  T ::TYPE
  (* A reader is a source of characters. *)

  error :Exception(Ok)
  (* Raised when any of the following operation cannot be carried out. *)

  input :T
  (* The standard input reader. *)

  file(name :String) :T
  (* Make a reader out of a file, given its file name. *)

  more(reader :T) :Bool
  (* Test for end of character stream. May block. *)

  ready(reader: T): Int
  (* Counts the number of characters that can be read without blocking;
       the end-of-stream marker counts as 1. Never blocks. *)

  getChar(reader :T) :Char
  (* Read a character from a reader. May block. *)

  getString(reader :T size :Int) :String
  (* Read a string of given size from a reader. May block. *)

  getSubString(reader :T string :String start,size :Int) :Ok
  (* Read a string of a give size from a reader and store it
       in another string at a given position. May block. *)

  close(reader :T) :Ok
  (* Close a reader; operations on it will now fail. *)

end;
