(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Mon Jun  4 05:44:19 1990 by luca           *)

interface Time
export

  T ::TYPE
  (* Time, mesured from an unspecified but fixed instant in the past. *)

  zero :T
  (* Time zero. *)

  now() :T
  (* Time now. *)

  seconds(t :T) :Int
  (* Seconds component of time t. *)

  microseconds(t :T) :Int
  (* Microseconds component of time t. *)

  equal(t1,t2 :T) :Bool
  (* Same time. *)

  before(t1,t2 :T) :Bool
  (* Whether t1 is strictly before t2. *)

  after(t1,t2 :T) :Bool
  (* Whether t1 is strictly after t2. *)

end;
