(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Mon Jun  4 05:52:31 1990 by luca           *)

interface Writer

export

  T ::TYPE
  (* A writer is a sink of characters. *)

  error :Exception(Ok)
  (* Raised when any of the following operation cannot be carried out. *)

  output :T
  (* The standard output writer. *)

  file(name :String) :T
  (* Make a writer out of a file, given its file name. *)

  flush(writer :T) :Ok
  (* Flush any buffered characters to their final destination. *)

  putChar(writer :T char :Char) :Ok
  (* Write a character to a writer. *)

  putString(writer :T string :String) :Ok
  (* Write a string to a writer. *)

  putSubString(writer :T string :String start,size :Int) :Ok
  (* Write a substring of a given string to a writer. *)

  close(writer :T) :Ok
  (* Close a writer; operations on it will now fail. *)

end;
