(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Temp.i3                                               *)
(* Last Modified On Mon Feb 10 16:00:15 PST 1992 By kalsow     *)
(*      Modified On Thu Nov  2 17:30:10 1989 By muller         *)

INTERFACE Temp;

IMPORT M3, Expr, Type, Value;

TYPE T = M3.Temp;

PROCEDURE LookUp (e: Expr.T;  lValue: BOOLEAN;  VAR t: T): BOOLEAN;

PROCEDURE AllocEmpty (type: Type.T;  lValue: BOOLEAN := FALSE): T;
PROCEDURE AllocMacro (e: Expr.T;     lValue: BOOLEAN := FALSE): T;
PROCEDURE Alloc      (e: Expr.T): T;
PROCEDURE Free (t: T);
PROCEDURE Depend (a, b: T);  (* free a -> free b *)

PROCEDURE FromExpr  (e: Expr.T): T;
PROCEDURE FromValue (v: Value.T;  lValue: BOOLEAN := FALSE): T;

PROCEDURE IsLValue (t: T): BOOLEAN;

PROCEDURE PushSet ();
PROCEDURE PopSet ();

PROCEDURE KillValues ();

PROCEDURE Write (t: T);

PROCEDURE Reset ();

END Temp.


