(* Copyright (C) 1992, Digital Equipment Corporation                     *)
(* All rights reserved.                                                  *)
(* See the file COPYRIGHT for a full description.                        *)
(*                                                                       *)
(* Last modified on Tue Sep 22 15:22:08 PDT 1992 by meehan                   *)
(* modified on Tue Jun 16 21:55:42 PDT 1992 by muller                    *)
(* modified on Mon Feb 24 17:09:29 PST 1992 by mhb                       *)

INTERFACE FVRuntime;

(* This is the (private) interface for FormsVBT. *)

IMPORT Axis, ButtonVBT, ChoiceVBT, FlexShape, Font, FormsVBT,
       FVTypes, HVSplit, List, ListVBT, PaintOp, RGB, Rsrc, Shadow,
       VBT, ZChildVBT, ZSplit;

TYPE
  Private <: SemiPublic;
  SemiPublic = FormsVBT.Public OBJECT path: Rsrc.Path END;
  Points = REAL;

CONST
  EMPTYSHAPE = FlexShape.Shape {
                 FlexShape.SizeRange {0.0, 0.0, 0.0},
                 FlexShape.SizeRange {0.0, 0.0, 0.0}};
  DefaultShadowSize: Points = 1.5;

TYPE
  ChoiceName = BRANDED REF RECORD name: TEXT END;

PROCEDURE SetPopTarget (source: ButtonVBT.T; target: ZChildVBT.T);

PROCEDURE SetVBT (fv: FormsVBT.T; name: TEXT; vbt: VBT.T)
  RAISES {FormsVBT.Error};

TYPE
  State = RECORD
            (* The inherited properties *)
            bgOp, fgOp, darkOp, lightOp: PaintOp.T;

            bgRGB    := RGB.T {0.8, 0.8, 0.8};
            fgRGB    := RGB.T {0.0, 0.0, 0.0};
            darkRGB  := RGB.T {0.333, 0.333, 0.333};
            lightRGB := RGB.T {1.0, 1.0, 1.0};

            fontName, labelFontName      : TEXT;
            font, labelFont              : Font.T;
            fontMetrics, labelFontMetrics: List.T;

            shadow  : Shadow.T;
            shadowSz: Points     := DefaultShadowSize;

            (* The next group implement "scoping". *)
            glueAxis: Axis.T            := Axis.T.Hor;
            hvsplit : HVSplit.T         := NIL;
            macros  : List.T            := NIL;
            menubar : FVTypes.FVMenuBar := NIL;
            radio   : FVTypes.FVRadio   := NIL;
            tsplit  : FVTypes.FVTSplit  := NIL;
            zchild  : ZChildVBT.T       := NIL;
            zsplit  : ZSplit.T          := NIL;
          END;

VAR DefaultFontMetrics, DefaultLabelFontMetrics: List.T; (* CONST *)

PROCEDURE InitParser ();

PROCEDURE Parse (         t          : FormsVBT.T;
                          description: FormsVBT.S_exp;
                 READONLY state      : State           ): VBT.T
  RAISES {FormsVBT.Error};

PROCEDURE NamedVBTs (t: FormsVBT.T): List.T;
(* Returns an alist of names and VBTs, sorted by name. *)

PROCEDURE GetAttachments (fv: FormsVBT.T): List.T;
PROCEDURE SetAttachments (fv: FormsVBT.T; alist: List.T)
  RAISES {FormsVBT.Error};
(* These routines get and set the procedures that are attached to "fv" via
   Attach, AttachProc, AttachKeyFilter, and AttachFocusAlert.  "alist" is an
   association list of names and [internal] refs that contain the actual
   procedures.  This is used by FormsEditVBT to copy the attachments from one
   FormsVBT to its replacement.

   SetAttachments will raise Error if an attachment fails, probably because
   "fv" does not contain a named VBT for every name in the alist. *)

PROCEDURE FindFont (fontname: TEXT): Font.T;
 (* This maintains a cache of fonts, indexed by names. *)

PROCEDURE MetricsToName (metrics: List.T): TEXT;
(* Convert a metrics-list into a font-name. *)


REVEAL FVTypes.UniSelector <: PrivateUniSelector;
TYPE
  PrivateUniSelector = ListVBT.UniSelector OBJECT
                         quick  : BOOLEAN;
                         browser: FVTypes.FVBrowser
                       END;

REVEAL FVTypes.MultiSelector <: PrivateMultiSelector;
TYPE
  PrivateMultiSelector = ListVBT.MultiSelector OBJECT
                           quick  : BOOLEAN;
                           browser: FVTypes.FVMultiBrowser
                         END;

REVEAL FVTypes.FVCloseButton <: PrivateCloseButton;
TYPE
  PrivateCloseButton =
    FVTypes.PublicCloseButton OBJECT target: ZChildVBT.T END;

REVEAL FVTypes.FVLinkButton <: PrivateLinkButton;
TYPE
  PrivateLinkButton = FVTypes.PublicLinkButton OBJECT
                        Tparent: FVTypes.FVTSplit;
                        Tchild : VBT.T
                      END;

REVEAL FVTypes.FVPageButton <: PrivatePageButton;
TYPE
  PrivatePageButton =
    FVTypes.PublicPageButton OBJECT target: FVTypes.FVTSplit END;

REVEAL FVTypes.FVChoice <: PrivateChoice;
TYPE
  PrivateChoice = ChoiceVBT.T OBJECT
                      radio: FVTypes.FVRadio
                  END;
                  
VAR
  formstack: List.T := NIL;
(* The FormsVBT parser pushes each nested form on this stack as
   it parses them, and it pops them when it has finished.  If
   "Error" is raised during the creation of a form, this
   stack may be helpful in locating the expression in which the
   error occurred. *)

END FVRuntime.
