(** !!!


   (******************* Getting and changing values ********************)

   (* In all of the following, a "name" refers to an interactor that
   constitutes a part of the VBT fv. In other words, the name occured in
   the expression that was scanned to create fv. These routines operate on
   the "Value" or "Main" properties; the appendix of the FormsVBT User
   Manual document each interactor, whether it has a Value or Main
   property, its type, whether it can be accessed at runtime, and so on.

   PutRefAny and PutRefProperty both assume that the ref is a type
   appropriate to the value type of the named interactor. Other Put
   procedures try to convert types as much as is reasonable. For example,
   PutInteger of an interactor that is a TypeIn will cause the INTEGER
   passed to PutInteger to be converted to a TEXT, as expected by a
   TypeIn.)

   FormsVBT "knows" about Choice buttons, Radio groups, and Generic
     interactors. Because the put and get procedures of these interactors are
     implemented, they do not raise Unimplemented. *)

    PROCEDURE PutRefAny(fv: T; name: TEXT; ref: REFANY)
      RAISES {Error, Unimplemented};
    PROCEDURE GetRefAny(fv: T; name: TEXT): REFANY
      RAISES {Error, Unimplemented};
 !!! *)

(** !!!
    PROCEDURE PutReal(fv: T; name: TEXT; real: REAL)
      RAISES {Error, Unimplemented};
    PROCEDURE GetReal(fv: T; name: TEXT): REAL
      RAISES {Error, Unimplemented};

    PROCEDURE PutLongReal(fv: T; name: TEXT; longReal: LONGREAL)
      RAISES {Error, Unimplemented};
    PROCEDURE GetLongReal(fv: T; name: TEXT): LONGREAL
      RAISES {Error, Unimplemented};
!!! *)
(** !!!
    PROCEDURE TransferFocus(fv: T; name: TEXT; eventTime: VBT.TimeStamp)
      RAISES {Error};
      (* Transfer the keyboard focus to the first member of the tabchain group
         that includes the specified interactor. The exception can be raised as
         in TakeFocus, or if the TabChain property on the specified interactor's
         ancestor is ill-formed. This procedure is useful when inserting a
         "dialog" in say, a VTile, and keyboard focus should be transferred to
         the new dialog. *)
!!! *)


If {\it zc} has a TabChain property on it, the
   first interactor, if any, on the TabChain list is given the
   keyboard focus by calling TakeFocus on that element, passing
   it the eventTime.  M3 Note: TabChains are not implemented.

   (** !!!
    PROCEDURE EnableEval(fv: T; enable: BOOLEAN := TRUE) RAISES {};
      (* Enable or disable the Eval mechanism for automatically computed
         dependencies. *)


    (******************  Installation and termination  ******************)

    PROCEDURE Open(
      v:          VBT.T;
      bg:         VBT.T;
      eventTime:  VBT.TimeStamp;
      forcePlace: BOOLEAN := FALSE
      ) RAISES {Error};
      (* Display v above bg and return.  The background VBT, bg, must have an
         ancestor that is a ZSplit.  Note:  Open does not depend on the fact that
         v is a FormsVBT.T, but it will use the additional information available
         (i.e., At and TabChain properties) if v is a FormsVBT.T with a ZChild or
         a ZChassis at top level.  In particular, if v is a FormsVBT.T with a
         TabChain property on it, the keyboard focus is given to the first
         visible interactor on the TabChain list. EventTime and forcePlace are
         the same as in PopUp, above. *)

    PROCEDURE Close(v: VBT.T) RAISES {Error};
      (* Presumably, v has been popped up, using Open, above some background. Now
         it will be removed (unmapped).  Close, like Open, does not depend upon
         the fact that v is a FormsVBT.T. *)

    PROCEDURE Detach(v: VBT.T) RAISES {Error};
      (* Open can attach v as a child of its background zsplit; Close only unmaps
         it, leaving a quicker path for popping it back up later. If you want to
         truly remove v as a child of its zsplit, so as to pop it up somewhere
         else later, use Detach.  Detach does a Close if necessary, and leaves v
         as a disconnected VBT or subtree of VBTs. *)


    PROCEDURE CloseOn(fv: T; waitEvent: TEXT);
      (* Register waitEvent as a completion event for fv, assuming that fv gets
         popped up by Open.  When waitEvent takes place, if fv has been popped up
         by Open, it will be automatically closed.  This does not prevent the
         client from registering an action procedure for waitEvent as well. *)

    PROCEDURE DeleteOn(fv: T; waitEvent: TEXT);
      (* Register waitEvent as a completion event for fv, assuming that fv
         (perhaps with some additional packaging) gets installed by
         Trestle.Install.  When waitEvent takes place, if fv has any ancestor
         that has been Trestle.Installed, then Trestle.Delete will be called on
         that ancestor.  DeleteOn does not prevent the client from registering an
         action procedure for waitEvent as well.  Beware of using DeleteOn if fv
         may become a component of some larger window or popped up by Open; the
         top-level window will be deleted. *)


    (***********************  Dynamic alterations  ************************)

    PROCEDURE Replace(
      fv:     T;
      parent: TEXT;        (* name of a Split in the form *)
      at:     CARDINAL;      (* position of first child to be replaced *)
      count:  CARDINAL := 1; (* number of children to be replaced *)
      description: TEXT := NIL (* an s-expression *)
      ) RAISES {Error};

      (* Modify a form that has already been built. The form may be currently
         visible or not, it doesn't matter.  The <parent> is the name of a split
         within the form, to which the new piece will be added. The <description>
         is an s-expression (only one expression allowed per call) describing the
         new piece.

         When description is NIL, this is pure deletion. Interpretation of <at>
         and <count> is lenient:  if <at> refers to a position exceeding the
         number of children or <count> is 0, nothing happens; if <count> refers
         to more children than exist after <at>, all children after <at> will be
         deleted. Thus, Replace(fv, name, 0, LAST(CARDINAL)) is a good way to
         clear out all children of a split.

         When <count> is 0, this is pure insertion. <at> tells where to insert
         it: 0 means before the first child of <parent>, 1 means after the first
         child, etc. If <at> exceeds the number of children, then the new
         material is added after all children of the split.

         When description is non-NIL and count is non-0, this is a replace.
         <count> children, starting with the one in the <at> position (0 is the
         first child) are deleted and replaced by <description>. If <count>
         refers to more children than exist after <at>, then all children after
         <at> are replaced. if <at> refers to a position exceeding the number of
         children, nothing is deleted and the new material is added at the end.

         Any children that are deleted are also VBT.Discarded.

         If the operation succeeds, the form is updated immediately, including
         changing its size if needed. *)

!!! *)
(** !!!

    PROCEDURE DeleteChild(fv: T; child: TEXT) RAISES {Error};
      (* = Replace(fv, NameOfSplit(child), PositionInSplit(child)), 1, NIL) *)

    PROCEDURE ReplaceChild(fv: T; child: TEXT; description: TEXT)
      RAISES {Error};
      (* = Replace(fv, NameOfSplit(ch), PositionInSplit(ch)), 1, description) *)

    PROCEDURE SplitCardinality(fv: T; parent: TEXT): CARDINAL RAISES {Error};
      (* Returns the number of children that <parent> has. Raises the exception
         if the named element doesn't exist or if it isn't a split. *)

    PROCEDURE NameOfSplit(fv: T; child: TEXT): TEXT RAISES {Error};
      (* Returns the name of <child>'s parent. Raises the exception if the named
         element doesn't exist, or if it isn't the child of some split. *)

    PROCEDURE NameOfChild(fv: T; parent: TEXT; index: CARDINAL): TEXT
      RAISES {Error};
      (* Returns the name of <index>th child of <parent>. Raises the exception if
         the named element doesn't exist, if it isn't a split, or if it has fewer
         than <index> children. Note that all components have a name; if no Name
         property has been set, then a default is assigned. *)

    PROCEDURE PositionInSplit(fv: T; child: TEXT): CARDINAL RAISES {Error};
      (* Returns the position of <child> in its parent. Raises the exception if
         the named element doesn't exist, or if it isn't the child of a split. *)

!!! *)


PROCEDURE GetRefProperty (fv: T; name, property: TEXT): REFANY
  RAISES {Error, Unimplemented};
PROCEDURE PutRefProperty (fv            : T;
                          name, property: TEXT;
                          ref           : REFANY)
  RAISES {Error, Unimplemented};
PROCEDURE GetIntegerProperty (fv: T; name, property: TEXT):
  INTEGER RAISES {Error, Unimplemented};
PROCEDURE PutIntegerProperty (fv            : T;
                              name, property: TEXT;
                              num           : INTEGER)
  RAISES {Error, Unimplemented};

PROCEDURE GetRealProperty (fv: T; name, property: TEXT): REAL
  RAISES {Error, Unimplemented};
PROCEDURE PutRealProperty (fv            : T;
                           name, property: TEXT;
                           real          : REAL  )
  RAISES {Error, Unimplemented};

PROCEDURE GetBooleanProperty (fv: T; name, property: TEXT):
  BOOLEAN RAISES {Error, Unimplemented};
PROCEDURE PutBooleanProperty (fv            : T;
                              name, property: TEXT;
                              val           : BOOLEAN)
  RAISES {Error, Unimplemented};
