(* Copyright (C) 1991, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Thu Nov 21 15:42:51 PST 1991 by muller         *)
(*      modified on Wed Sep 25 01:13:10 1991 by kalsow         *)


INTERFACE FPU;

(* This interface defines the VAX hardware (and libm.a) defined interface
   to floating-point values *)

(*------------------------------------------------- binary representation ---*)

TYPE
  RealRep = RECORD (* "f" floating point *)
    fraction0 : BITS  7 FOR [0..63];
    exponent  : BITS  8 FOR [0..255];
    sign      : BITS  1 FOR [0..1];
    fraction1 : BITS 16 FOR [0..64*1024-1];
  END;

CONST
  RealBias = 128;

TYPE
  LongRealRep = RECORD (* "d" floating point *)
    fraction0 : BITS  7 FOR [0..63];
    exponent  : BITS  8 FOR [0..255];
    sign      : BITS  1 FOR [0..1];
    fraction1 : BITS 16 FOR [0..64*1024-1];
    fraction2 : BITS 16 FOR [0..64*1024-1];
    fraction3 : BITS 16 FOR [0..64*1024-1];
  END;

CONST
  LongRealBias = 128;

TYPE
  ExtendedRep = LongRealRep;

CONST
  ExtendedBias = LongRealBias;

END FPU.
