(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Thu Nov 12 15:56:33 PST 1992 by muller                   *)

UNSAFE MODULE RTThread;

IMPORT Usignal, Word;

EXCEPTION InternalError;     <*FATAL InternalError*>

CONST 
  SP_pos = 2;

PROCEDURE SP (s: State): ADDRESS =
  BEGIN
    RETURN LOOPHOLE (s [SP_pos], ADDRESS);
  END SP;

PROCEDURE FlushStackCache () =
  VAR d: State;
  BEGIN
    IF Save (d) = 0 THEN
      Restore (d, 1); END;
  END FlushStackCache;

PROCEDURE UpdateStateForNewSP (VAR s: State; offset: INTEGER) =
  BEGIN
    INC (s [SP_pos], offset);
  END UpdateStateForNewSP;

PROCEDURE UpdateFrameForNewSP (a: ADDRESS;  offset: INTEGER) =
  BEGIN
    INC (LOOPHOLE (a + 14 * ADRSIZE (Word.T), UNTRACED REF INTEGER)^, offset);
  END UpdateFrameForNewSP;

PROCEDURE setup_sigvtalrm (handler: Usignal.SignalHandler) =
  VAR   sv, osv: Usignal.struct_sigvec;
  BEGIN
    sv.sv_handler := handler;
    sv.sv_mask    := Usignal.empty_sv_mask;
    sv.sv_flags   := 0;
    IF Usignal.sigvec (Usignal.SIGVTALRM, sv, osv) #  0 THEN
      RAISE InternalError; END; 
  END setup_sigvtalrm;

PROCEDURE allow_sigvtalrm () =
  VAR i : Word.T;
  BEGIN
    i := Usignal.sigsetmask (0);
    i := Word.And (i, Word.Not (Usignal.sigmask (Usignal.SIGVTALRM)));
    EVAL Usignal.sigsetmask (i); 
  END allow_sigvtalrm;

PROCEDURE disallow_sigvtalrm () =
  VAR i : Word.T;
  BEGIN
    i := Usignal.sigsetmask (0);
    i := Word.Or (i, Usignal.sigmask (Usignal.SIGVTALRM));
    EVAL Usignal.sigsetmask (i); 
  END disallow_sigvtalrm;

BEGIN
END RTThread.
