UNSAFE INTERFACE FileStamp_ux;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT Utime, Utypes;
IMPORT FileStamp;

(* provides conversion from 'FileStamp.T' values to and from the Unix file
stamp format. Unfortunately Unix is a mess in this area, at present so the
conversions are not simply inverses as you might expect.
  File stamp values are set by 'utimes' which requires 'timeval' values - i.e.
seconds since Jan 1 1970 and microseconds. This interface provides a way of
converting a 'FileStamp.T' to a 'timeval' so that it can be used with 'utimes'.
  File stamp values are read by 'stat' or 'fstat' and are returned as 'time_t'
values - i.e. seconds since Jan 1 1970 and no microseconds. This module
provides a way to convert a 'time_t', presumably obtained via 'stat' or
'fstat', into a 'FileStamp.T'.
  Note that conversion from 'time_t' to a 'timeval' and back is easy *)

PROCEDURE ToStamp(clock: Utypes.time_t): FileStamp.T RAISES {};
(* convert 'time_t' into a 'FileStamp.T'. May return 'FileStamp.Bad' *)

PROCEDURE FromStamp(t: FileStamp.T; VAR tv: Utime.struct_timeval) RAISES {};
(* convert 't' into a 'timeval'. 't' may be 'FileStamp.Bad' *)

END FileStamp_ux.
