UNSAFE INTERFACE PathName_ux;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT Udir;


CONST
  CaseSensitivity = TRUE;
  (* are names in the file system case sensitive? *)

  ExtSepChar = '.';
  ExtSepText = ".";
  (* the character used to separate the extension part of a file system name
   from the rest of the name e.g. in the Unix name "foo.c" the dot separates
   the main part of the name ("foo") from the extension ("c") *)

  DirSepChar = '/';
  DirSepText = "/";
  (* the character used to separate different components of a filing system
   path name. e.g. in Unix the name "a/b/c" has three components separated by
  the separator character "/". *)

  SepChars = SET OF CHAR{ExtSepChar, DirSepChar};
  (* a set made up of both separators *)

  CurrentDirText = ".";
  (* name of the current directory *)

  MaxLength = Udir.MAXPATHLEN;
  (* the maximum length allowed for the full path name of a filing system
   object *)

  MaxComponentLength = Udir.MAXNAMLEN;
  (* the maximum length allowed for a single component of a filing system
   path name (i.e. the maximum length of a directory entry) *)

END PathName_ux.
