INTERFACE CharType;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

(*
  The semantics of the following functions is EXACTLY as for the
  corresponding ANSI-C functions described in ctype.h 
*)

<*INLINE*> PROCEDURE IsAlphaNumeric(ch: CHAR): BOOLEAN RAISES {};
(*
  TRUE if IsDigit(ch) OR IsLower(ch) OR IsUpper(ch).
*)

<*INLINE*> PROCEDURE IsAlphabetic(ch: CHAR): BOOLEAN RAISES {};
(*
  TRUE if IsLower(ch) OR IsUpper(ch).
*)

<*INLINE*> PROCEDURE IsCntrl(ch: CHAR): BOOLEAN RAISES {};
(*
  TRUE if (ch < ' ') OR (ch >= 177C).
*)

<*INLINE*> PROCEDURE IsDigit(ch: CHAR): BOOLEAN RAISES {};
(*
  TRUE if ch = one of '0', '1',... '9'.
*)

<*INLINE*> PROCEDURE IsGraphic(ch: CHAR): BOOLEAN RAISES {};
(*
  TRUE if IsAlphaNumeric(ch) OR IsPunctuation(ch).
*)

<*INLINE*> PROCEDURE IsLower(ch: CHAR): BOOLEAN RAISES {};
(*
  TRUE if ch is one of 'a', 'b',... 'z'.
*)

<*INLINE*> PROCEDURE IsPrintable(ch: CHAR): BOOLEAN RAISES {};
(*
  TRUE if IsGraphic(ch) OR (ch = ' ')
*)

<*INLINE*> PROCEDURE IsPunctuation(ch: CHAR): BOOLEAN RAISES {};
(*
  TRUE if NOT IsCntrl(ch) AND NOT IsAlphaNumeric(ch) AND (ch # ' ').
*)

<*INLINE*> PROCEDURE IsWhitespace(ch: CHAR): BOOLEAN RAISES {};
(*
  TRUE if ch IN {' ', '\t', '\n', CHAR.VT, '\f', '\r'}
*)

<*INLINE*> PROCEDURE IsUpper(ch: CHAR): BOOLEAN RAISES {};
(*
  TRUE if ch is one of 'A', 'B',... 'Z'.
*)

<*INLINE*> PROCEDURE IsHexDigit(ch: CHAR): BOOLEAN RAISES {};
(*
  TRUE if ch IN {'0'..'9', 'a'..'f', 'A'..'F'}.
*)

<*INLINE*> PROCEDURE IsEndOfLine(ch: CHAR): BOOLEAN RAISES {};
(*
  TRUE if ch is '\n', '\r' or '\f'
*)

<*INLINE*> PROCEDURE ToLower(ch: CHAR): CHAR RAISES {};
(*
  If ch IN {'A', 'B', ...'Z'] THEN the corresponding lower-case letter.
  Otherwise, ch unchanged.
*)

<*INLINE*> PROCEDURE ToUpper(ch: CHAR): CHAR RAISES {};
(*
  If ch IN ['a', 'b', ...'z'] THEN the corresponding upper-case letter.
  Otherwise, ch unchanged. 
*)


(* Now some useful character sets - assume ASCII/ISO-Latin1 ordering *)

TYPE
  Set = SET OF CHAR;

CONST
  All = Set{FIRST(CHAR)..LAST(CHAR)};
  None = Set{};

  Lower = Set{'a'..'z'};
  Upper = Set{'A'..'Z'};
  Alphabetic = Lower + Upper;

  Digit = Set{'0'..'9'};
  HexDigit = Digit + Set{'a'..'f', 'A'..'F'};

  AlphaNumeric = Alphabetic + Digit;

  EndOfLine = Set{'\n', '\r', '\f'};
  Space = Set{' '};
  SpaceOrTab = Space + Set{'\t', '\013'};
  WhiteSpace = SpaceOrTab + EndOfLine;

  Printable = Set{' '..'~'};
  Graphic = Printable - Space;
  Cntrl = All - Printable;
  Punctuation = Printable - AlphaNumeric;

END CharType.
