INTERFACE TextTo;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT Text, Fmt;


(* Routines for converting texts into numbers/booleans. The routines return a
BOOLEAN result indicating whether the conversion succeeded. The result of the
conversion is returned via a VAR parameter, which is only updated if the
conversion succeeds.
  A conversion can fail because the given text is not a valid representation of
a number/boolean or because of overflow. Note that there must be no whitespace,
whether leading, trailing or embedded in the text.
  The case of characters is not significant e.g. "false" and "FALSE" are both
valid booleans, "ff" and "FF" are both valid hex numbers *)

CONST Decimal = 10;

PROCEDURE Card(
    t: Text.T;
    VAR c: CARDINAL;
    base: Fmt.Base := (*Fmt.*)Decimal)
    : BOOLEAN
    RAISES {};
(* Convert 't' to a cardinal, using the given base *)

PROCEDURE Int(t: Text.T;
    VAR i: INTEGER;
    base: Fmt.Base := (*Fmt.*)Decimal)
    : BOOLEAN
    RAISES {};
(* Convert 't' to an integer, using the given base. 't' can start with '+' or
'-' or the sign may be omitted entirely *)

PROCEDURE Bool(t: Text.T; VAR b: BOOLEAN): BOOLEAN RAISES {};
(* Convert "TRUE" or "FALSE" into the appropriate boolean *)

PROCEDURE BasedCard(t: Text.T; VAR c: CARDINAL): BOOLEAN RAISES {};
(* Convert a number of the form "base_digits". The base must be specified in
decimal and must be in the range given by the type 'Fmt.Base' *)

PROCEDURE BasedInt(t: Text.T; VAR i: INTEGER): BOOLEAN RAISES {};
(* Like 'BasedInt' but allows an optional sign at the start of 't' *)

PROCEDURE BigCard(t: Text.T; VAR c: CARDINAL): BOOLEAN RAISES {};
(* Like 'BasedCard' but allows an optional suffix 'k' or 'm'. 'k' multiplies
the number by 1024, 'm' multiplies it by 1024 * 1024 *)

PROCEDURE BigInt(t: Text.T; VAR i: INTEGER): BOOLEAN RAISES {};
(* Like 'BigInt' but allows an optional sign at the start of 't' *)

PROCEDURE Real(t: Text.T; VAR real: REAL): BOOLEAN RAISES {};
(* Convert 't' to a real number. The format of a real number is
    [+|-]d{d}[.{d}][(e|E)[+|-]d{d}]   where 'd' is any decimal digit
i.e. an optional sign, then a string of digits optionally containing a decimal
point, then an optional e or E followed by an optional sign, followed by an
integer. *)

PROCEDURE LongReal(t: Text.T; VAR long: LONGREAL): BOOLEAN RAISES {};
(* Convert 't' to a long real number. The format of a long real is the same as
that of a real number *)

PROCEDURE Extended(t: Text.T; VAR extended: EXTENDED): BOOLEAN RAISES {};
(* Convert 't' to a long real number. The format of a long real is the same as
that of a real number *)

END TextTo.
