MODULE BufferStream;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT Text;
IMPORT IO, IO_impl;


PROCEDURE Error(s: IO.Stream): Text.T RAISES {} =
  BEGIN
    IF IO.WhyErrant(s) = IO.Fault.Write THEN RETURN "buffer overflow" END;
    RETURN NIL;
  END Error;


EXCEPTION NILBuffer;

TYPE
  T = IO.Stream BRANDED OBJECT OVERRIDES implDescribeError := Error END;

PROCEDURE Open(
    buffer: REF ARRAY OF CHAR;
    length := WholeBuffer;
    mode := IO.OpenMode.Update;
    name := "buffer")
    : IO.Stream
    RAISES {} =
  BEGIN
    IF buffer = NIL THEN RAISE NILBuffer <*CRASH*> END;

    CONST
      Properties = IO.PropertySet{IO.Property.IsBuffer} +
          IO_impl.MappedStreamUsualProperties;
    VAR
      s := NEW(T);
    BEGIN
      IF length < 0 THEN
        IF mode IN IO_impl.TruncateModes THEN
          length := 0;
        ELSE
          length := NUMBER(buffer^);
        END;
      END;
      IO_impl.Init(s, buffer, length, mode, Properties, name);
          <*UNEXPECTED IO.Error*>
      RETURN s;
    END;

  END Open;


BEGIN
END BufferStream.
