UNSAFE INTERFACE BulkIO;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT IO;


(* 'BulkIO' provides a way to output large blocks of untyped data. It is
possible to use 'IO.GetN' and 'IO.PutN' in some cases e.g.
  IO.PutN(s, LOOPHOLE(big, ARRAY OF CHAR));
but there are other cases which cannot be handled this way (e.g. if 'big' were
an open array). 'BulkIO' allows the user to specify a pointer to the area to be
read/written plus a byte count.  This is unsafe of course; specifying a bogus
address or an incorrect byte count can lead to chaos.
  'BulkIO.PutN' and 'BulkIO.GetN' are just unsafe veneers on the corresponding
'IO' functions; their basic functionality is the same *)

PROCEDURE PutN(s: IO.Stream; a: ADDRESS; bytes: CARDINAL) RAISES {IO.Error};

PROCEDURE GetN(
    s: IO.Stream;
    a: ADDRESS;
    bytes: CARDINAL;
    raiseEndOfStream := FALSE)
    : CARDINAL
    RAISES {IO.Error, IO.EndOfStream};

END BulkIO.
