MODULE IOErr;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT Text, Fmt;

IMPORT IO, Err;


PROCEDURE Describe(s: IO.Stream): Text.T RAISES {}=
  VAR
    fault: IO.Fault := IO.WhyErrant(s);
  BEGIN
    IF fault = IO.Fault.None THEN
      RETURN "";
    ELSE
      VAR
        main := Fmt.F("Error on stream named \'%s\': %s\n",
            IO.Name(s), IO.FaultToText(fault));
        extra := IO.DescribeError(s);
      BEGIN
        IF extra = NIL THEN
          RETURN main;
        ELSE
          RETURN Fmt.F("%s  %s\n", main, extra);
        END;
      END;
    END;
  END Describe;


PROCEDURE DescribeAndClose(s: IO.Stream): Text.T RAISES {} =
  BEGIN
    IF s = NIL THEN RETURN "" END;
    VAR
      result := Describe(s);
    BEGIN
      LOOP
        TRY
          IO.Close(s);
          RETURN result;
        EXCEPT
        | IO.Error =>
            result := result & Describe(s);
            (* loop *)
        END;
      END;
    END;
  END DescribeAndClose;


PROCEDURE Close(
    s: IO.Stream;
    severity: Err.Severity := Err.Severity.Fatal)
    RAISES {} =
  VAR
    text: Text.T := DescribeAndClose(s);
  BEGIN
    IF Text.Length(text) # 0 THEN Err.Print(text, severity, FALSE) END;
  END Close;


BEGIN
END IOErr.
